/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derbyTesting.junit.BaseTestCase;

public class PathUtilTest
extends BaseTestCase {
    private static final String SEP = File.separator;

    public PathUtilTest(String name) {
        super(name);
    }

    public void testGetParent() {
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)""));
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)File.separator));
        PathUtilTest.assertEquals((String)"seg0", (String)PathUtil.getParent((String)PathUtilTest.join("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)PathUtilTest.abs("seg0"), (String)PathUtil.getParent((String)PathUtilTest.joinAbs("seg0", "c1.dat")));
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)("seg0" + SEP)));
        PathUtilTest.assertEquals((String)SEP, (String)PathUtil.getParent((String)PathUtilTest.abs("seg0" + SEP)));
        PathUtilTest.assertEquals((String)PathUtilTest.joinAbs("dir1", "dir2"), (String)PathUtil.getParent((String)PathUtilTest.joinAbs("dir1", "dir2", "myFile.txt")));
    }

    public void testGetBase() {
        PathUtilTest.assertEquals((String)"seg0", (String)PathUtil.getBaseName((String)"seg0"));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.join("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.joinAbs("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.join("aDir", "seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.joinAbs("aDir", "seg0", "c1.dat")));
    }

    public static Test suite() {
        return new TestSuite(PathUtilTest.class, "PathUtilTest suite");
    }

    public static String abs(String e1) {
        return SEP + e1;
    }

    public static String join(String e1, String e2) {
        return e1 + SEP + e2;
    }

    public static String joinAbs(String e1, String e2) {
        return SEP + PathUtilTest.join(e1, e2);
    }

    public static String join(String e1, String e2, String e3) {
        return e1 + SEP + e2 + SEP + e3;
    }

    public static String joinAbs(String e1, String e2, String e3) {
        return SEP + PathUtilTest.join(e1, e2, e3);
    }

    public static String join(String[] elems) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < elems.length; ++i) {
            str.append(elems[i]);
            str.append(SEP);
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    public static String joinAbs(String[] elems) {
        return SEP + PathUtilTest.join(elems);
    }
}

