/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdesktop.swingx.editors.PainterUtil;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPainter
extends CompoundPainter {
    URL url;
    private boolean loaded = false;

    public URLPainter() {
        this.url = null;
    }

    public URLPainter(URL url) {
        this.url = url;
    }

    public URLPainter(File file) {
        try {
            this.url = file.toURI().toURL();
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
            this.url = null;
        }
    }

    public URLPainter(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            this.url = null;
        }
    }

    public URLPainter(Class<?> baseClass, String resource) {
        this.url = baseClass.getResource(resource);
    }

    public void setURL(URL url) {
        URL old = this.url;
        this.url = url;
        this.firePropertyChange("file", old, this.url);
    }

    public URL getURL() {
        return this.url;
    }

    private void load() {
        try {
            Painter painter = PainterUtil.loadPainter(this.url);
            this.setPainters(new Painter[]{painter});
            this.loaded = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void doPaint(Graphics2D g, Object component, int width, int height) {
        if (!this.loaded) {
            this.load();
        }
        super.doPaint(g, component, width, height);
    }
}

