/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.java.ao.DatabaseProvider;
import net.java.ao.PoolProvider;

public class C3P0PoolProvider
extends PoolProvider {
    private ComboPooledDataSource cpds = new ComboPooledDataSource();

    public C3P0PoolProvider(DatabaseProvider delegate) {
        super(delegate);
        try {
            this.cpds.setDriverClass(delegate.getDriverClass().getCanonicalName());
        }
        catch (PropertyVetoException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.cpds.setJdbcUrl(this.getURI());
        this.cpds.setUser(this.getUsername());
        this.cpds.setPassword(this.getPassword());
        this.cpds.setMaxPoolSize(30);
        this.cpds.setMaxStatements(180);
    }

    protected Connection getConnectionImpl() throws SQLException {
        return this.cpds.getConnection();
    }

    public void dispose() {
        super.dispose();
        try {
            DataSources.destroy((DataSource)this.cpds);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean isAvailable() {
        try {
            Class.forName("com.mchange.v2.c3p0.ComboPooledDataSource");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

