/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.sql.Connection;
import java.sql.SQLException;
import net.java.ao.DatabaseProvider;
import net.java.ao.PoolProvider;
import org.apache.commons.dbcp.BasicDataSource;

public class DBCPPoolProvider
extends PoolProvider {
    private BasicDataSource ds = new BasicDataSource();

    public DBCPPoolProvider(DatabaseProvider delegate) {
        super(delegate);
        try {
            this.ds.setDriverClassName(delegate.getDriverClass().getCanonicalName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.ds.setUsername(this.getUsername());
        this.ds.setPassword(this.getPassword());
        this.ds.setUrl(this.getURI());
        this.ds.setMaxActive(30);
    }

    protected Connection getConnectionImpl() throws SQLException {
        return this.ds.getConnection();
    }

    public void dispose() {
        try {
            this.ds.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.ds = null;
        super.dispose();
    }

    public static boolean isAvailable() {
        try {
            Class.forName("org.apache.commons.dbcp.BasicDataSource");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

