/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.connect;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.sql.SQLException;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

import jdbcacsess2.main.GuiDivider;
import jdbcacsess2.main.GuiDivider.DividerGenerator;
import jdbcacsess2.main.GuiFont;
import jdbcacsess2.main.GuiFont.FontGenerator;
import jdbcacsess2.main.GuiWindow;
import jdbcacsess2.main.GuiWindow.WindowGenerator;
import jdbcacsess2.main.JmyTable;
import net.java.ao.Entity;
import net.java.ao.Generator;
import net.java.ao.Preload;
import net.java.ao.schema.NotNull;

public class ConnectView extends JDialog {


	/**
	 * GUIコンポーネント属性を保存する為のActiveObjectsインタフェース
	 * 
	 * @author sima
	 * 
	 */
	@Preload
	public interface ViewConnect extends Entity {

		@NotNull
		@Generator(WindowGenerator.class)
		GuiWindow getWindow();
		void setWindow(GuiWindow guiWindow);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getDivider();
		void setDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(DividerGenerator.class)
		GuiDivider getLastDivider();
		void setLastDivider(GuiDivider guiDivider);

		@NotNull
		@Generator(FontGenerator.class)
		GuiFont getFontList();
		void setFontList(GuiFont guiFont);

		ConfigConnect getConnect();
		void setConnect(ConfigConnect configConnect);

	}

	/**
	 * Viewのcomponent属性を更新用オブジェクト{ConfigViewConnect)に集める。
	 * 
	 * @param c
	 *            入力値を格納する為のConfigViewConnect。
	 * @throws SQLException
	 */
	public void collectViewConnect(ViewConnect c) throws SQLException {
		Point p = getLocationOnScreen();
		GuiWindow guiWindow = c.getWindow();
		guiWindow.setWidth(getWidth());
		guiWindow.setHeight(getHeight());
		guiWindow.setX(p.x);
		guiWindow.setY(p.y);
		guiWindow.save();

		GuiDivider guiDivider = c.getDivider();
		guiDivider.setLocation(jSplitPane.getDividerLocation());
		guiDivider.save();

		GuiDivider configLastDivider = c.getLastDivider();
		configLastDivider.setLocation(jSplitPane.getLastDividerLocation());
		configLastDivider.save();

		GuiFont guiFont = c.getFontList();
		guiFont.setFont(jTableConnect.getFont());
		guiFont.save();
	}

	/**
	 * Viewのcomponent属性を復元する。
	 * 
	 * @param c
	 *            復元するConfigViewConnect
	 * @throws SQLException
	 */
	public void setViewConnect(final ViewConnect c) throws SQLException {

		jSplitPane.setDividerLocation(c.getDivider().getLocation());
		jSplitPane.setLastDividerLocation(c.getLastDivider().getLocation());

		ConfigConnect configConnect = c.getConnect();
		if (configConnect != null) {
			int i = ((ConnectTableModel)
					jTableConnect.getModel()).getRowIndex(c.getConnect());
			if (i != -1) {
				i =
						jTableConnect.convertRowIndexToView(i);
				jTableConnect.getSelectionModel().setSelectionInterval(i, i);
			}
		}

		GuiWindow guiWindow = c.getWindow();
		setLocation(guiWindow.getX(), guiWindow.getY());
		setSize(guiWindow.getWidth(), guiWindow.getHeight());

		GuiFont guiFont = c.getFontList();
		jTableConnect.setFont(guiFont.getFont());

	}

	/**
	 * 選択行の接続情報を取得する。
	 * 
	 * @return
	 */
	public ConfigConnect getSelectedConfigConnect() {
		int row = getJTableConnect().getSelectedModelRow();
		if (row < 0) {
			return null;
		}
		ConnectTableModel connectTableModel = (ConnectTableModel) getJTableConnect().getModel();
		ConfigConnect configConnect = connectTableModel.getRow(row);
		return configConnect;
	}

	//
	//
	//

	/**
	 * 
	 */
	private static final long serialVersionUID = -7590702541649271608L;
	private JPanel jPanel = null;
	private JSplitPane jSplitPane = null;
	private JPanel jPanelConnectList = null;
	private JScrollPane jScrollPaneConnectons = null;
	private JmyTable jTableConnect = null;
	private JButton jButtonConnect = null;
	private JPanel jPanelConnectInfo = null;
	private JPanel jPanelHeader = null;
	private JLabel jLabelConnectName = null;
	private JTextField jTextFieldConnectName = null;
	private JLabel jLabelDBMS = null;
	private JComboBox<ConfigDbms> jComboBoxDBMS = null;
	private JPanel jPanelHost = null;
	private JPanel jPanelAuth = null;
	private JLabel jLabelUser = null;
	private JTextField jTextFieldUser = null;
	private JLabel jLabelPassword = null;
	private JPasswordField jPasswordFieldPassword = null;
	private JLabel jLabelHostName = null;
	private JTextField jTextFieldHostName = null;
	private JLabel jLabelPortNumber = null;
	private JTextField jTextFieldPortNumber = null;
	private JLabel jLabelDatabaseName = null;
	private JTextField jTextFieldDatabaseName = null;
	private JPanel jPanelJdbc = null;
	private JLabel jLabelClassName = null;
	private JTextField jTextFieldClassName = null;
	private JLabel jLabelDriverFile = null;
	private JTextArea jTextAreaDriverFile = null;
	private JButton jButtonFileChoose = null;
	private JLabel jLabelUrlOption = null;
	private JTextField jTextFieldUrlOption = null;
	private JTextArea jTextAreaURL = null;
	private JLabel jLabelURL = null;
	private JPanel jPanelFooter = null;
	private JButton jButtonSave = null;
	private JButton jButtonConnectTest = null;
	private JButton jButtonRemove = null;
	private JButton jButtonClose = null;
	private JPanel jPanelAction = null;
	private JButton jButtonNewSave = null;
	private JProgressBar jProgressBar = null;
	private JCheckBox jCheckBoxAutosave;

	/**
	 * This method initializes
	 * 
	 */
	public ConnectView(JFrame owner) {
		super(owner);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		// どうも、Linux java7 でバグってないか？
		this.setLocationByPlatform(false);

		this.setSize(new Dimension(600, 800));
		this.setModal(true);
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.setTitle("データベース接続");
		this.setContentPane(getJPanel());
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BorderLayout());
			jPanel.add(getJSplitPane(), BorderLayout.CENTER);
		}
		return jPanel;
	}

	/**
	 * This method initializes jSplitPane
	 * 
	 * @return javax.swing.JSplitPane
	 */
	private JSplitPane getJSplitPane() {
		if (jSplitPane == null) {
			jSplitPane = new JSplitPane();
			jSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
			jSplitPane.setOneTouchExpandable(true);
			// jSplitPane.setDividerSize(15);
			jSplitPane.setDividerLocation(200);
			jSplitPane.setBottomComponent(getJPanelConnectInfo());
			jSplitPane.setTopComponent(getJPanelConnectList());
		}
		return jSplitPane;
	}

	/**
	 * This method initializes jPanelConnectList
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelConnectList() {
		if (jPanelConnectList == null) {
			jPanelConnectList = new JPanel();
			jPanelConnectList.setLayout(new BorderLayout());
			jPanelConnectList.add(getJScrollPaneConnectons(), BorderLayout.CENTER);
			jPanelConnectList.add(getJPanelAction(), BorderLayout.EAST);
			jPanelConnectList.add(getJProgressBar(), BorderLayout.SOUTH);
		}
		return jPanelConnectList;
	}

	/**
	 * This method initializes jScrollPaneConnectons
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPaneConnectons() {
		if (jScrollPaneConnectons == null) {
			jScrollPaneConnectons = new JScrollPane();
			jScrollPaneConnectons.setViewportView(getJTableConnect());
		}
		return jScrollPaneConnectons;
	}

	/**
	 * This method initializes jTableConnect
	 * 
	 * @return javax.swing.JTable
	 */
	JmyTable getJTableConnect() {
		if (jTableConnect == null) {
			jTableConnect = new JmyTable();
		}
		return jTableConnect;
	}


	/**
	 * This method initializes jButtonConnect
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonConnect() {
		if (jButtonConnect == null) {
			jButtonConnect = new JButton();
			jButtonConnect.setText("接続");
		}
		return jButtonConnect;
	}

	/**
	 * This method initializes jPanelConnectInfo
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelConnectInfo() {
		if (jPanelConnectInfo == null) {
			jPanelConnectInfo = new JPanel();
			jPanelConnectInfo.setLayout(new BoxLayout(getJPanelConnectInfo(), BoxLayout.Y_AXIS));
			jPanelConnectInfo.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
			jPanelConnectInfo.add(getJPanelHeader(), null);
			jPanelConnectInfo.add(getJPanelAuth(), null);
			jPanelConnectInfo.add(getJPanelHost(), null);
			jPanelConnectInfo.add(getJPanelJdbc(), null);
			jPanelConnectInfo.add(getJPanelFooter(), null);
		}
		return jPanelConnectInfo;
	}

	/**
	 * This method initializes jPanelHeader
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelHeader() {
		if (jPanelHeader == null) {
			GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
			gridBagConstraints22.insets = new Insets(0, 0, 5, 5);
			gridBagConstraints22.gridx = 0;
			gridBagConstraints22.gridy = 1;
			GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
			gridBagConstraints110.anchor = GridBagConstraints.CENTER;
			gridBagConstraints110.insets = new Insets(5, 0, 5, 0);
			gridBagConstraints110.gridx = 1;
			gridBagConstraints110.gridy = 1;
			gridBagConstraints110.weightx = 1.0;
			gridBagConstraints110.fill = GridBagConstraints.BOTH;
			jLabelDBMS = new JLabel();
			jLabelDBMS.setText("ＤＢＭＳ：");
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.ipadx = 198;
			gridBagConstraints2.ipady = 4;
			gridBagConstraints2.anchor = GridBagConstraints.WEST;
			gridBagConstraints2.gridy = 1;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridx = 1;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.ipadx = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.gridwidth = 1;
			gridBagConstraints1.anchor = GridBagConstraints.CENTER;
			gridBagConstraints1.insets = new Insets(5, 0, 5, 0);
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.ipadx = 0;
			gridBagConstraints.ipady = 0;
			gridBagConstraints.anchor = GridBagConstraints.WEST;
			gridBagConstraints.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints.gridy = 0;
			jLabelConnectName = new JLabel();
			jLabelConnectName.setText("接続名：");
			jLabelConnectName.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
			jPanelHeader = new JPanel();
			jPanelHeader.setLayout(new GridBagLayout());
			jPanelHeader.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED),
			                                                        "",
			                                                        TitledBorder.DEFAULT_JUSTIFICATION,
			                                                        TitledBorder.DEFAULT_POSITION,
			                                                        null,
			                                                        null));
			jPanelHeader.add(jLabelConnectName, gridBagConstraints);
			jPanelHeader.add(getJTextFieldConnectName(), gridBagConstraints1);
			jPanelHeader.add(jLabelDBMS, gridBagConstraints22);
			jPanelHeader.add(getJComboBoxDBMS(), gridBagConstraints110);
			GridBagConstraints gbc_checkboxAutosave = new GridBagConstraints();
			gbc_checkboxAutosave.fill = GridBagConstraints.HORIZONTAL;
			gbc_checkboxAutosave.gridx = 1;
			gbc_checkboxAutosave.gridy = 2;
			jPanelHeader.add(getJCheckBoxAutosave(), gbc_checkboxAutosave);
		}
		return jPanelHeader;
	}

	/**
	 * This method initializes jTextFieldConnectName
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldConnectName() {
		if (jTextFieldConnectName == null) {
			jTextFieldConnectName = new JTextField();
		}
		return jTextFieldConnectName;
	}

	/**
	 * This method initializes jComboBoxDBMS
	 * 
	 * @return javax.swing.JComboBox
	 */
	JComboBox<ConfigDbms> getJComboBoxDBMS() {
		if (jComboBoxDBMS == null) {
			jComboBoxDBMS = new JComboBox<ConfigDbms>();
		}
		return jComboBoxDBMS;
	}

	/**
	 * This method initializes jPanelHost
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelHost() {
		if (jPanelHost == null) {
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.BOTH;
			gridBagConstraints9.gridy = 1;
			gridBagConstraints9.weightx = 1.0;
			gridBagConstraints9.insets = new Insets(5, 0, 5, 5);
			gridBagConstraints9.anchor = GridBagConstraints.CENTER;
			gridBagConstraints9.gridwidth = 3;
			gridBagConstraints9.gridx = 1;
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.gridx = 0;
			gridBagConstraints8.anchor = GridBagConstraints.EAST;
			gridBagConstraints8.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints8.gridy = 1;
			jLabelDatabaseName = new JLabel();
			jLabelDatabaseName.setText("データベース名：");
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.fill = GridBagConstraints.BOTH;
			gridBagConstraints7.gridx = 3;
			gridBagConstraints7.gridy = 0;
			gridBagConstraints7.weightx = 1.0;
			gridBagConstraints7.anchor = GridBagConstraints.CENTER;
			gridBagConstraints7.insets = new Insets(5, 0, 5, 5);
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints6.gridy = 0;
			gridBagConstraints6.anchor = GridBagConstraints.EAST;
			gridBagConstraints6.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints6.gridx = 2;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.gridx = 1;
			gridBagConstraints5.gridy = 0;
			gridBagConstraints5.weightx = 1.0;
			gridBagConstraints5.anchor = GridBagConstraints.CENTER;
			gridBagConstraints5.insets = new Insets(5, 0, 5, 5);
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints4.gridy = 0;
			gridBagConstraints4.anchor = GridBagConstraints.EAST;
			gridBagConstraints4.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints4.gridx = 0;
			jLabelPortNumber = new JLabel();
			jLabelPortNumber.setText("ポート番号：");
			jLabelHostName = new JLabel();
			jLabelHostName.setText("ホスト名：");
			jPanelHost = new JPanel();
			jPanelHost.setLayout(new GridBagLayout());
			jPanelHost.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED),
			                                                      "ホスト情報",
			                                                      TitledBorder.DEFAULT_JUSTIFICATION,
			                                                      TitledBorder.DEFAULT_POSITION));
			jPanelHost.add(jLabelHostName, gridBagConstraints4);
			jPanelHost.add(getJTextFieldHostName(), gridBagConstraints5);
			jPanelHost.add(jLabelPortNumber, gridBagConstraints6);
			jPanelHost.add(getJTextFieldPortNumber(), gridBagConstraints7);
			jPanelHost.add(jLabelDatabaseName, gridBagConstraints8);
			jPanelHost.add(getJTextFieldDatabaseName(), gridBagConstraints9);
		}
		return jPanelHost;
	}

	/**
	 * This method initializes jPanelAuth
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelAuth() {
		if (jPanelAuth == null) {
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.anchor = GridBagConstraints.EAST;
			gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.gridy = 1;
			gridBagConstraints11.fill = GridBagConstraints.VERTICAL;
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.fill = GridBagConstraints.BOTH;
			gridBagConstraints14.gridx = 3;
			gridBagConstraints14.gridy = 0;
			gridBagConstraints14.weightx = 1.0;
			gridBagConstraints14.anchor = GridBagConstraints.CENTER;
			gridBagConstraints14.insets = new Insets(5, 0, 5, 5);
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints13.gridy = 0;
			gridBagConstraints13.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints13.gridx = 2;
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.fill = GridBagConstraints.BOTH;
			gridBagConstraints12.gridx = 1;
			gridBagConstraints12.gridy = 0;
			gridBagConstraints12.weightx = 1.0;
			gridBagConstraints12.anchor = GridBagConstraints.CENTER;
			gridBagConstraints12.insets = new Insets(5, 0, 5, 5);
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints10.gridy = 0;
			gridBagConstraints10.anchor = GridBagConstraints.EAST;
			gridBagConstraints10.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints10.gridwidth = 1;
			gridBagConstraints10.gridx = 0;
			jLabelPassword = new JLabel();
			jLabelPassword.setText("パスワード：");
			jLabelUser = new JLabel();
			jLabelUser.setText("ユーザ：");
			jPanelAuth = new JPanel();
			jPanelAuth.setLayout(new GridBagLayout());
			jPanelAuth.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED),
			                                                      "認証情報",
			                                                      TitledBorder.DEFAULT_JUSTIFICATION,
			                                                      TitledBorder.DEFAULT_POSITION));
			jPanelAuth.add(jLabelUser, gridBagConstraints10);
			jPanelAuth.add(getJTextFieldUser(), gridBagConstraints12);
			jPanelAuth.add(jLabelPassword, gridBagConstraints13);
			jPanelAuth.add(getJPasswordFieldPassword(), gridBagConstraints14);
		}
		return jPanelAuth;
	}

	/**
	 * This method initializes jTextFieldUser
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldUser() {
		if (jTextFieldUser == null) {
			jTextFieldUser = new JTextField();
			jTextFieldUser.setColumns(10);
		}
		return jTextFieldUser;
	}

	/**
	 * This method initializes jPasswordFieldPassword
	 * 
	 * @return javax.swing.JPasswordField
	 */
	JPasswordField getJPasswordFieldPassword() {
		if (jPasswordFieldPassword == null) {
			jPasswordFieldPassword = new JPasswordField();
			jPasswordFieldPassword.setColumns(10);
		}
		return jPasswordFieldPassword;
	}

	/**
	 * This method initializes jTextFieldHostName
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldHostName() {
		if (jTextFieldHostName == null) {
			jTextFieldHostName = new JTextField();
			jTextFieldHostName.setColumns(20);
		}
		return jTextFieldHostName;
	}

	/**
	 * This method initializes jTextFieldPortNumber
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldPortNumber() {
		if (jTextFieldPortNumber == null) {
			jTextFieldPortNumber = new JTextField();
			jTextFieldPortNumber.setColumns(4);
		}
		return jTextFieldPortNumber;
	}

	/**
	 * This method initializes jTextFieldDatabaseName
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldDatabaseName() {
		if (jTextFieldDatabaseName == null) {
			jTextFieldDatabaseName = new JTextField();
			jTextFieldDatabaseName.setColumns(20);
		}
		return jTextFieldDatabaseName;
	}

	/**
	 * This method initializes jPanelJdbc
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelJdbc() {
		if (jPanelJdbc == null) {
			GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
			gridBagConstraints21.gridx = 0;
			gridBagConstraints21.anchor = GridBagConstraints.EAST;
			gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints21.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints21.gridy = 7;
			jLabelURL = new JLabel();
			jLabelURL.setText("ＵＲＬ：");
			GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
			gridBagConstraints20.fill = GridBagConstraints.BOTH;
			gridBagConstraints20.gridy = 6;
			gridBagConstraints20.weightx = 1.0;
			gridBagConstraints20.weighty = 1.0;
			gridBagConstraints20.gridwidth = 2;
			gridBagConstraints20.insets = new Insets(5, 0, 5, 5);
			gridBagConstraints20.gridheight = 2;
			gridBagConstraints20.gridx = 1;
			GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
			gridBagConstraints19.fill = GridBagConstraints.BOTH;
			gridBagConstraints19.gridx = 1;
			gridBagConstraints19.gridy = 5;
			gridBagConstraints19.insets = new Insets(5, 0, 5, 5);
			gridBagConstraints19.anchor = GridBagConstraints.CENTER;
			gridBagConstraints19.gridwidth = 2;
			gridBagConstraints19.gridheight = 1;
			gridBagConstraints19.weightx = 1.0;
			GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
			gridBagConstraints18.gridx = 0;
			gridBagConstraints18.anchor = GridBagConstraints.EAST;
			gridBagConstraints18.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints18.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints18.gridy = 5;
			jLabelUrlOption = new JLabel();
			jLabelUrlOption.setText("ＵＲＬ付加文字列：");
			GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
			gridBagConstraints17.gridx = 2;
			gridBagConstraints17.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints17.anchor = GridBagConstraints.EAST;
			gridBagConstraints17.insets = new Insets(5, 5, 0, 5);
			gridBagConstraints17.gridy = 2;
			GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
			gridBagConstraints16.fill = GridBagConstraints.BOTH;
			gridBagConstraints16.gridy = 2;
			gridBagConstraints16.weightx = 1.0;
			gridBagConstraints16.weighty = 1.0;
			gridBagConstraints16.gridheight = 3;
			gridBagConstraints16.insets = new Insets(5, 0, 5, 5);
			gridBagConstraints16.anchor = GridBagConstraints.CENTER;
			gridBagConstraints16.gridx = 1;
			GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
			gridBagConstraints15.gridx = 0;
			gridBagConstraints15.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints15.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints15.anchor = GridBagConstraints.EAST;
			gridBagConstraints15.gridy = 2;
			jLabelDriverFile = new JLabel();
			jLabelDriverFile.setText("ドライバファイル：");
			GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
			gridBagConstraints51.fill = GridBagConstraints.BOTH;
			gridBagConstraints51.gridx = 1;
			gridBagConstraints51.gridy = 1;
			gridBagConstraints51.weightx = 1.0;
			gridBagConstraints51.anchor = GridBagConstraints.CENTER;
			gridBagConstraints51.gridwidth = 2;
			gridBagConstraints51.insets = new Insets(5, 0, 5, 5);
			GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
			gridBagConstraints41.anchor = GridBagConstraints.EAST;
			gridBagConstraints41.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints41.gridx = 0;
			gridBagConstraints41.gridy = 1;
			gridBagConstraints41.fill = GridBagConstraints.VERTICAL;
			jLabelClassName = new JLabel();
			jLabelClassName.setText("クラス名：");
			jPanelJdbc = new JPanel();
			jPanelJdbc.setLayout(new GridBagLayout());
			jPanelJdbc.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED),
			                                                      "ＪＤＢＣ情報",
			                                                      TitledBorder.DEFAULT_JUSTIFICATION,
			                                                      TitledBorder.DEFAULT_POSITION));
			jPanelJdbc.add(jLabelClassName, gridBagConstraints41);
			jPanelJdbc.add(getJTextFieldClassName(), gridBagConstraints51);
			jPanelJdbc.add(jLabelDriverFile, gridBagConstraints15);
			jPanelJdbc.add(getJTextAreaDriverFile(), gridBagConstraints16);
			jPanelJdbc.add(getJButtonFileChoose(), gridBagConstraints17);
			jPanelJdbc.add(jLabelUrlOption, gridBagConstraints18);
			jPanelJdbc.add(getJTextFieldUrlOption(), gridBagConstraints19);
			jPanelJdbc.add(getJTextAreaURL(), gridBagConstraints20);
			jPanelJdbc.add(jLabelURL, gridBagConstraints21);
		}
		return jPanelJdbc;
	}

	/**
	 * This method initializes jTextFieldClassName
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldClassName() {
		if (jTextFieldClassName == null) {
			jTextFieldClassName = new JTextField();
			jTextFieldClassName.setColumns(0);
		}
		return jTextFieldClassName;
	}

	/**
	 * This method initializes jTextAreaDriverFile
	 * 
	 * @return javax.swing.JTextArea
	 */
	JTextArea getJTextAreaDriverFile() {
		if (jTextAreaDriverFile == null) {
			jTextAreaDriverFile = new JTextArea();
			jTextAreaDriverFile.setBorder(jTextFieldClassName.getBorder());
			jTextAreaDriverFile.setLineWrap(true);
			jTextAreaDriverFile.setText("");
			jTextAreaDriverFile.setRows(3);
		}
		return jTextAreaDriverFile;
	}

	/**
	 * This method initializes jButtonFileChoose
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonFileChoose() {
		if (jButtonFileChoose == null) {
			jButtonFileChoose = new JButton();
			jButtonFileChoose.setText("参照…");
		}
		return jButtonFileChoose;
	}

	/**
	 * This method initializes jTextFieldUrlOption
	 * 
	 * @return javax.swing.JTextField
	 */
	JTextField getJTextFieldUrlOption() {
		if (jTextFieldUrlOption == null) {
			jTextFieldUrlOption = new JTextField();
			jTextFieldUrlOption.setColumns(0);
		}
		return jTextFieldUrlOption;
	}

	/**
	 * This method initializes jTextAreaURL
	 * 
	 * @return javax.swing.JTextArea
	 */
	JTextArea getJTextAreaURL() {
		if (jTextAreaURL == null) {
			jTextAreaURL = new JTextArea();
			jTextAreaURL.setEditable(false);
			jTextAreaURL.setRows(2);
			jTextAreaURL.setEnabled(true);
			jTextAreaURL.setLineWrap(true);
			jTextAreaURL.setOpaque(false);
			jTextAreaURL.setText("");
			jTextAreaURL.setBorder(jTextFieldClassName.getBorder());
		}
		return jTextAreaURL;
	}

	/**
	 * This method initializes jPanelFooter
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelFooter() {
		if (jPanelFooter == null) {
			jPanelFooter = new JPanel();
			jPanelFooter.setLayout(new FlowLayout());
			jPanelFooter.add(getJButtonConnectTest(), null);
			jPanelFooter.add(getJButtonSave(), null);
			jPanelFooter.add(getJButtonNewSave(), null);
			jPanelFooter.add(getJButtonRemove(), null);
		}
		return jPanelFooter;
	}

	/**
	 * This method initializes jButtonSave
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonSave() {
		if (jButtonSave == null) {
			jButtonSave = new JButton();
			jButtonSave.setText("上書保存");
		}
		return jButtonSave;
	}

	/**
	 * This method initializes jButtonConnectTest
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonConnectTest() {
		if (jButtonConnectTest == null) {
			jButtonConnectTest = new JButton();
			jButtonConnectTest.setText("接続テスト");
		}
		return jButtonConnectTest;
	}

	/**
	 * This method initializes jButtonRemove
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonRemove() {
		if (jButtonRemove == null) {
			jButtonRemove = new JButton();
			jButtonRemove.setText("設定削除");
		}
		return jButtonRemove;
	}

	/**
	 * This method initializes jButtonClose
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonClose() {
		if (jButtonClose == null) {
			jButtonClose = new JButton();
			jButtonClose.setText("閉じる");
		}
		return jButtonClose;
	}

	/**
	 * This method initializes jPanelAction
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelAction() {
		if (jPanelAction == null) {
			jPanelAction = new JPanel();
			jPanelAction.setLayout(new BoxLayout(getJPanelAction(), BoxLayout.Y_AXIS));
			jPanelAction.add(getJButtonConnect(), null);
			jPanelAction.add(getJButtonClose(), null);
		}
		return jPanelAction;
	}

	/**
	 * This method initializes jButtonNewSave
	 * 
	 * @return javax.swing.JButton
	 */
	JButton getJButtonNewSave() {
		if (jButtonNewSave == null) {
			jButtonNewSave = new JButton();
			jButtonNewSave.setText("新規保存");
		}
		return jButtonNewSave;
	}

	/**
	 * This method initializes jProgressBar
	 * 
	 * @return javax.swing.JProgressBar
	 */
	JProgressBar getJProgressBar() {
		if (jProgressBar == null) {
			jProgressBar = new JProgressBar();
			jProgressBar.setIndeterminate(false);
		}
		return jProgressBar;
	}

	/**
	 * This method initializes jProgressBar
	 * 
	 * @return javax.swing.JCheckBox
	 */
	JCheckBox getJCheckBoxAutosave() {
		if (jCheckBoxAutosave == null) {
			jCheckBoxAutosave = new JCheckBox();
			jCheckBoxAutosave.setText("接続成功時に自動保存");
			jCheckBoxAutosave.setSelected(true);
		}
		return jCheckBoxAutosave;
	}

}
