/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService;

/**
 * データベーストランザクション終了のイベント通知するリスナーです。 トランザクションの開始は通知する事が出来ません。
 * 
 * @author sima
 * 
 */
public interface DataBaseTransactionListener extends DataBaseListener {

	/**
	 * AutoCommitの変更通知
	 */
	void autoCommitChange(DataBaseConnection dataBaseConnection, boolean autoCommit);

	/**
	 * COMMITの終了通知
	 */
	void commitEnd(DataBaseConnection dataBaseConnection);

	/**
	 * ROLLBACKの終了通知
	 */
	void rollbackEnd(DataBaseConnection dataBaseConnection);

}
