/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService.exception;

/**
 * データベース接続使用中チェック例外クラス。
 * 
 * @author sima
 * 
 */
public class DbConnectIllgalStateException extends Exception {
	private static final long serialVersionUID = 758337487233694859L;

	public DbConnectIllgalStateException() {
		super("Database connect in use");
	}

	public DbConnectIllgalStateException(String msg) {
		super(msg);
	}
}
