import java.awt.Image;
import java.io.IOException;
import java.util.Random;

import javax.imageio.*;

class Alice extends Body implements java.io.Serializable {
	static final long serialVersionUID = 1L;
	public static final int type = 2;
	public static final String nameJ = "ありす";
	public static final String nameE = "Alice";

	private static Image[][][] images = new Image[NUM_OF_CONDITIONS][2][3];

	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/alice/";

		// left face
		images[BODY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/body.png"));
		images[LICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/lick.png"));
		images[BRAID][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/braid.png"));
		images[ACCESSORY][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/hairband.png"));
		images[DAMAGED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/damage.png"));
		images[PANTS][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/pants.png"));
		images[STAIN][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/shit.png"));
		images[SICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/sick.png"));
		images[NORMAL][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[SLEEPING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/sleeping.png"));
		images[CHEER][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/cheer.png"));
		images[SMILE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/smile.png"));
		images[TIRED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/tired.png"));
		images[PUFF][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/puff.png"));
		images[CRYING][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/crying.png"));
		images[EXCITING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/exciting.png"));
		images[REFRESHED][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/refreshed.png"));
		images[DEAD][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/dead.png"));
		images[RUDE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/rude.png"));
		// right face
		images[BODY][RIGHT][adultIndex] =		flipImage(images[BODY][LEFT][adultIndex]);
		images[LICK][RIGHT][adultIndex] =		flipImage(images[LICK][LEFT][adultIndex]);
		images[BRAID][RIGHT][adultIndex] =		flipImage(images[BRAID][LEFT][adultIndex]);
		images[ACCESSORY][RIGHT][adultIndex] =	flipImage(images[ACCESSORY][LEFT][adultIndex]);
		images[DAMAGED][RIGHT][adultIndex] =	flipImage(images[DAMAGED][LEFT][adultIndex]);
		images[PANTS][RIGHT][adultIndex] =		flipImage(images[PANTS][LEFT][adultIndex]);
		images[STAIN][RIGHT][adultIndex] =		flipImage(images[STAIN][LEFT][adultIndex]);
		images[SICK][RIGHT][adultIndex] =		flipImage(images[SICK][LEFT][adultIndex]);		
		images[NORMAL][RIGHT][adultIndex] =		flipImage(images[NORMAL][LEFT][adultIndex]);
		images[SLEEPING][RIGHT][adultIndex] =	flipImage(images[SLEEPING][LEFT][adultIndex]);
		images[CHEER][RIGHT][adultIndex] =		flipImage(images[CHEER][LEFT][adultIndex]);
		images[SMILE][RIGHT][adultIndex] =		flipImage(images[SMILE][LEFT][adultIndex]);
		images[TIRED][RIGHT][adultIndex] =		flipImage(images[TIRED][LEFT][adultIndex]);
		images[PUFF][RIGHT][adultIndex] =		flipImage(images[PUFF][LEFT][adultIndex]);
		images[CRYING][RIGHT][adultIndex] =		flipImage(images[CRYING][LEFT][adultIndex]);
		images[EXCITING][RIGHT][adultIndex] =	flipImage(images[EXCITING][LEFT][adultIndex]);
		images[REFRESHED][RIGHT][adultIndex] =	flipImage(images[REFRESHED][LEFT][adultIndex]);
		images[DEAD][RIGHT][adultIndex] =		flipImage(images[DEAD][LEFT][adultIndex]);
		images[RUDE][RIGHT][adultIndex] =		flipImage(images[RUDE][LEFT][adultIndex]);		
		// center
		images[CRUSHED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[CRUSHED2][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[SHIT][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"shit.png"));
		images[ROLL_ACCESSORY][RIGHT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"hairband.png"));
		images[ROLL_SHIT][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_left.png"));
		images[ROLL_SHIT][RIGHT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_right.png"));
		images[PANTS2][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"pants.png"));
		images[PANTS2_ROLL][LEFT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"left_pants.png"));
		images[PANTS2_ROLL][RIGHT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"right_pants.png"));

		for(Image[][] array2d : images) {	
			for(Image[] array : array2d) {
				if(array[adultIndex] == null) {
					continue;
				}
				// Scale larger images down
				array[adultIndex] = array[adultIndex].getScaledInstance(adultSize, adultSize, Image.SCALE_AREA_AVERAGING);
				array[childIndex] = array[adultIndex].getScaledInstance(childSize, childSize, Image.SCALE_AREA_AVERAGING);
				array[babyIndex] =  array[adultIndex].getScaledInstance(babySize, babySize, Image.SCALE_AREA_AVERAGING);
			}
		}
	}

	public Image getImage(int type, int direction) {
		return images[type][direction][ageState.ordinal()];
	}

	@Override
	public int getType() {
		return type;
	}

	@Override
	public int getHybridType(int partnerType) {
		switch (partnerType) {
		default:
			return Alice.type;
		}
	}

	@Override
	public String getNameJ() {
		return nameJ;
	}

	@Override
	public String getNameE() {
		return nameE;
	}

	@Override
	protected String msgWantFoodJ () {
		if (!isRudeMessage()) {
			String[] output = {"ごはんしゃんのにおいがすりゅ", "ごはんしゃんのにおいがすりゅよ", "ごはんさんのにおいがするわ"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ごはんしゃんのにおいがすりゅ", "ありしゅのごはんしゃん！", "ごはんさんのにおいがするわ！"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgWantFoodE () {
		String[] output = {"The shmell of mishder food!", "Shmell of mishder food!", "It's the smell of mister food!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgNoFoodJ()
	{
		if (!isRudeMessage()) {
			String[][] output = {{"ごはんしゃんにゃい！", "ごはんしゃんにゃいよ？", "ごはんさんないわよ？"},
					{"ごはんしゃんかえちて、、、", "ごはんしゃんかえちて、、、", "ごはんさんがえぢでぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ごはんしゃんにゃい！", "ごはんしゃんにゃいよ？ばきゃなの？しにゅの？", "ごはんさんないわよ？ばかなの？しぬの？"},
					{"ごはんしゃんかえちて、、、", "ごはんしゃんかえちて、、、", "ごはんさんがえぢでぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgNoFoodE()
	{
		String[][] output = {{"Mishder food ish nod here!", "Mishder food ish nod here! Are you shtoopid?  Wand choo die?", "Mister food is not here?  Are you stupid? Want to die?"},
				{"Gib back mishder food...", "Gib back mishder food...", "Pwease give back mister food..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgExciteJ() {
		return "んっほおおお～とってもとかいはなまむまむね～！";
	}

	@Override
	protected String msgExciteE() {
		return "Want to refresh~!";
	}

	@Override
	protected String msgRelaxJ()
	{
		Random rnd = new Random();
		if (!isRudeMessage()) {
			if (rnd.nextInt(2) == 0) {
				String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
				return output[ageState.ordinal()];
			}
			else {
				String output[] = {"ちょかいはだわ～", "ちょっちぇもちょかいはだわ～", "とってもとかいはねぇ～"};
				return output[ageState.ordinal()];		
			}
		}
		else {
			String output[] = {"ゆっきゅちちね！", "いなかもにょはゆっきゅちちね！", "とかいはじゃないわ～"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgRelaxE()
	{
		String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFuriFuriJ()
	{
		if (!isRudeMessage()) {
			String output[] = {"ふーりふーり", "ありしゅかわいきゅてごみぇんね！", "ありすとかいはでごめんね！"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"ふーりふーり", "ありしゅのあにゃるでしこってもいいよ！", "とかいはなありすでしこってもいいわよ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgFuriFuriE()
	{
		String output[] = {"Relax-relax~", "Alish ish showwy for being sho cude!", "Taste Alice's anyaru is ok too!"};
		return output[ageState.ordinal()];
	}

	protected String msgWakeupJ()
	{
		String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
		return output[ageState.ordinal()];
	}

	protected String msgWakeupE()
	{
		String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSleepJ() { return "すーやすーや"; }

	@Override
	protected String msgSleepE() { return "Sleep-Sleep---"; }

	@Override
	protected String msgScreamJ() {
		if (!isRudeMessage()) {
			String[][] output = {{"いちゃいー！", "いちゃい！やめちぇにぇ？やめちぇにぇ？", "いたい！やめてね？やめてね？"},
					{"ゆ、ゆ、ゆ、、、", "やめちぇね、、、", "やめてくださいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"いちゃいー！", "いちゃいー！にゃにすりゅの？いなかもの！", "いだいぃ！やめろいなかもの！"},
					{"ゆ、ゆ、ゆ、、、", "ごみぇんなさいありしゅがわりゅかったでしゅ", "ありすがわるかったです、ごめんなさい、やめてくださいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgScreamE() {
		String[][] output = {{"YUNYA-!!", "ID HURD!  Going choo pyuff-pyuff!", "It hurts! Puff!!"},
				{"Shdop id shdop id-", "Alishu ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgScareJ () {
		String[][] output = {{"ゆんやー！", "ゆっくちできにゃいー！", "なんだかゆっくりできないわ！"},
				{"ゆ、ゆ、ゆ、、、", "ごめんなちゃいやめちぇにぇ、、、", "どぼじでありすにこんなごどずるのぉ、、、"}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgScareE () {
		String[][] output = {{"YUNYA-!!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
				{"Shdop id shdop id-", "Alish ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgAlarmJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆー！", "にゃんだかゆっくちできにゃい！", "なんだかゆっくりできないわ！"},
					{"ゆ、ゆ、ゆ、、、", "ごめんなちゃいやめちぇにぇ、、、", "やめてください、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ゆー！", "ゆっくちできにゃい！やめりょいにゃかもの！", "なんだかゆっくりできないわ！すぐにやめてね！"},
					{"ゆ、ゆ、ゆ、、、", "ごめんなちゃい、、、", "ありすがわるかったですぅ、やめてくださいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgAlarmE () {
		String[][] output = {{"I can'ch chake id eajy!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
				{"Shdop id shdop id-", "Alish ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgDyingJ () {
		String[] output = {"ゆべっ！", "ぷきゅっ！", "げぼっ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDyingE () {
		String[] output = {"Yubee!!", "Puff!", "Blarg!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadJ () {
		String[] output = {"もっちょゆっくち、、、", "もっちょゆっくちしちゃかった、、、", "もっとゆっくりしたかった、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadE () {
		String[] output = {"Wanted choo chake id eajy more...", "Wanted choo chake id eajy more...", "Wanted to take it easy more..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆ～ゆ～ゆ～、ちあわちぇー", "むーちゃむーちゃ、ちあわちぇー", "むーしゃむーしゃ、しあわせー"},	
					{"ゆ！ゆ！ゆ！", "むちゃむちゃ、ちあわちぇー！！！", "むっしゃむっしゃ、しあわせー！！！"}};
			return output[hungryState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"む〜ちゃむ〜ちゃ、しょれにゃりー", "むーちゃむーちゃ、しょりぇにゃりー", "むーしゃむーしゃ、それなりー"},	
					{"ゆ！ゆ！ゆ！", "むちゃむちゃ、はふはふ", "むっしゃむっしゃ、うめぇ"}};
			return output[hungryState.ordinal()][ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgEatingE () {
		String[][] output = {{"Myunch-Myunch, happinesh~ ", "Myunch~ Myunch~ Happinesh~", "Munch munch, Happiness"},
				{"Myunch myunch...", "Myunch Myunch, nom nom", "Munch munch, so good!"}};
		return output[hungryState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgEatingShitJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、げりょまじゅ、、、", "むーちゃむーちゃ、げろまじゅ、、、", "むーしゃむーしゃ、げろまず、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingShitE () {
		String[] output = {"Myunch-Myunch, disgusting,,,", "Myunch~ Myunch~ disgusting,,,", "Munch munch, disgusting,,,"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingBitterJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、こりぇどきゅはいっちぇりゅ！", "むーちゃむーちゃ、こりぇどきゅはいっちぇりゅ！", "むーしゃむーしゃ、これどくはいってるぅ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingBitterE () {
		String[] output = {"Myunch-Myunch, this is poison!", "Myunch~ Myunch~ this is poison!", "Munch munch, this is poison!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullJ () {
		String[] output = {"おにゃかいっぱい、、、", "おにゃかいっぱい、、、", "もうたべられないの、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullE () {
		String[] output = {"Tummy ish full...", "Tummy ish full...", "Can't eat anymore..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHealingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"あみゅあみゃ！", "あまあまおいしい！", "あまあまおいしいね！"},
					{"あみゃあみゃ！", "ありしゅはふっかつしちゃわ！", "ありすはふっかつしたわ！"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゅあみゃ！", "ありしゅにあまあまもっとちょうだいにぇ！", "とかいはなありすにあまあまもっとちょうだいね！"},
					{"あみゃあみゃ！", "とかいはにゃありしゅはかれいにふっかつしちゃわ！", "とかいはなありすはかれいにふっかつしたわ！"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgHealingE () {
		String[][] output = {{"Shweet-shweet!", "Eajy!", "Can take it easy!"},
				{"Shweet-shweet", "Can chake id eajy", "Can take it easy"}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgSukkiriJ () {
		String[] output = {"ちゅっきち！", "ちゅっきり！", "すっきり！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSukkiriE () {
		String[] output = {"Wefweshed!", "Wefeshed!", "Refreshed!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBirthJ () { return "ゆっくちちていっちぇね！"; }

	@Override
	protected String msgBirthE () { return "Chake id eajy!"; }

	@Override
	protected String msgShitJ () {
		if (!hasPants) {
			if (!isRudeMessage()) {
				String[] output = {"うんうんぢぇりゅ！", "ありしゅゅのすーぴゃーうんうんちゃいみゅはじみゃるよ！", "ありすのすーぱーうんうんたいむはじまるよ！"};
				return output[ageState.ordinal()];
			}
			else {
				String[] output = {"うんうんぢぇりゅ！", "くしょどれいはありしゅのうんうんたべてもいいよ！", "くそどれいはありすのうんうんたべてもいいわよ！"};
				return output[ageState.ordinal()];	    
			}
		}
		else {
			String[] output = {"うんうんぢぇりゅ！", "うんうんしゃんもりぇちゃぅ！", "うんうんさんもれちゃうぅ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShitE () {
		if (!hasPants) {
			String[] output = {"Poo-pooing!", "Alish's shuupa poo-poo time ish shtarting!", "Alice's super poo-poo time is starting!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Poo-pooing!", "Poo-poo Alish's pants!", "Leaking Mr.poo-poo!"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShit2J () {
		if (!hasPants) {
			String[] output = {"すっきち！", "すっきちー！", "すっきりー！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆんやー！", "ゆんやー！", "えぐっえぐっ、、、"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgShit2E () {
		if (!hasPants) {
			String[] output = {"Wefeshed!", "Wefeshed-!!", "Refreshed~!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Yun ya-!", "Yun ya-!", "Yuuu,,,"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgSuriSuriJ () {
		String[] output = {"ちゅりちゅり", "ちゅーりちゅーり", "すーりすーり"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSuriSuriE () {
		String[] output = {"Wub-wub", "Wub-wub", "Rub-rub"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroJ () {
		String[] output = {"ぺりょぺりょ", "ぺーりょぺーりょ", "ぺーろぺーろ"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroE () {
		String[] output = {"Wick-wick~", "Wick-wick~", "Lick-lick~"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBreedJ() {
		return "う、うばれる、、、";
	}

	@Override
	protected String msgBreedE() {
		return "B...Being born...";
	}

	@Override
	protected String msgBreed2J() {
		if (!hasPants) {
			return "ゆっくりしていってね！";
		}
		else {
			return "ありすのおちびちゃんがぁぁっ！";
		}
	}

	@Override
	protected String msgBreed2E() {
		if (!hasPants) {
			return "Take it easy!";
		}
		else {
			return "Alice's little one!";
		}
	}

	@Override
	protected String msgHateShitJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"くちゃい〜！", "うんうんかたじゅけてにぇ！", "うんうんかたづけてね！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないわ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"くちゃい～！", "くちゃい～！しゅぎゅにかたじゅきぇりょ！", "うんうんかたづけてね！すぐでいいわよ！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないわ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHateShitE () {
		String[][] output = {{"Shmelly~!", "Poo-poo shdinky!!  Help eajy!!", "Hurry up and save me from poo-poo!! Right now is fine!"},
				{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}
	
	@Override
	protected String msgHungryJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ごはんしゃんちょうじゃい！", "ごはんしゃんをありしゅにちょうじゃいね！", "ごはんさんをありすにちょうだいね！"},
					{"ゆ～、ごはんしゃん、、、", "おにゃきゃへっちゃよ、、、", "ありすにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゃあみゃもってきょい！", "ありしゅのあまあましゅぎゅにもってきょい！", "ありすのあままをすぐにもってきてね！たくさんでいいわよ！"},
					{"ゆ～、ごはんしゃん、、、", "おにゃきゃへっちゃよ、、、", "ありすにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHungryE () {
		String[][] output = {{"Gib up shweet-shweets!", "Bwing mishder munch-munch choo Alish!", "Bring the munch-munch to Alice! A lot is fine!"},
				{"Where ish mishder food?", "Misder tummy ish hungwy...", "Pwease give Alice some food..."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgNoAccessoryJ () {
		String[] output = {"ゆぇーん！かえちてね？かえちてね？", "ゆぇーん！ありしゅのきゃわいいおかざりしゃんかえちてね？", "ありすのとかいはなおかざりさんどこにいったの？"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgNoAccessoryE () {
		String[] output = {"Yunn~!  Where ish misder Hairband?", "Yunn~!  Where ish Alish's cude-cude misder Hairband?", "Where's Alice's mister Hairband?"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHateYukkuriJ () {
		if (!isRudeMessage()) {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくりできないゆっくりがいるわ！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆふふ、ゆっくちできにゃいゆっくちがいりゅよ", "ゆふふ、ゆっくりできないゆっくりがいるわ！せいっさいするわよ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgHateYukkuriE () {
		String[] output = {"There'sh a yukkuri that can'ch chake id eajy", "There'sh a yukkuri that can'ch chake id eajy", "A yukkuri that can't take it easy!  Punishment time!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFlyingJ () {
		String[] output = {"おちょらをとんでりゅみちゃい！", "ありしゅはおしょらをとぶとりさん！", "おそらをとんでるみたい！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFlyingE () {
		String[] output = {"Ich feewsh wike fwying!", "Alish ish mishter flying bird!", "I feel like I'm flying!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSadnessForChildJ () { return "おちびちゃんすきとおったきれいなおめめをあけてー！"; }

	@Override
	protected String msgSadnessForChildE () { return "Open your beautiful clear eyes, my little one!"; }

	@Override
	protected String msgSadnessForPartnerJ (Body partner) {
		return partner.getNameJ()+"めをあけてー！";
	}

	@Override
	protected String msgSadnessForPartnerE (Body partner) {
		return "Open your eyes, "+partner.getNameE()+"!";
	}
	
	@Override
	protected String msgBlockedByWallJ () {
		String[] output = {"ありしゅしゅしゅめにゃいよおぉぉぉ！？", "にゃんでかべしゃんじゃましゅるにょぉぉぉ！？", "なんでかべさんじゃまするのおぉぉぉ！？"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBlockedByWallE () {
		String[] output = {"Alish can'ch go forward!?", "Why would mishter Wall block me!?", "Why would mister Wall block me!?"};
		return output[ageState.ordinal()];
	}

	// public methods
	public Alice(int initX, int initY, int initZ, Body.AgeState initAgeState, Body p1, Body p2) {
		super(initX, initY, initZ, initAgeState, p1, p2);
	}
	
	public void tuneParameters() {
		if (rnd.nextBoolean()) {
			rapist = true;
		}
		double factor = Math.random()+1;
		HUNGRYLIMIT[AgeState.ADULT.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.CHILD.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+1;
		SHITLIMIT[AgeState.ADULT.ordinal()] *= factor;
		SHITLIMIT[AgeState.CHILD.ordinal()] *= factor;
		SHITLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+1;
		DAMAGELIMIT[AgeState.ADULT.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.CHILD.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		BABYLIMIT *= factor;
		CHILDLIMIT *= factor;
		LIFELIMIT *= factor;
		factor = Math.random()+1;
		RELAXPERIOD *= factor;
		EXCITEPERIOD *= factor;
		PREGPERIOD *= factor;
		SLEEPPERIOD *= factor;
		ACTIVEPERIOD *= factor;
		sameDest = rnd.nextInt(15)+15;
		DECLINEPERIOD *= (Math.random()+0.5);
		DISCIPLINELIMIT *= (Math.random()+1);
		ROBUSTNESS = rnd.nextInt(5);
		EYESIGHT /= 2;
		factor = Math.random()+0.5;
		STRENGTH[AgeState.ADULT.ordinal()] *= factor;
		STRENGTH[AgeState.CHILD.ordinal()] *= factor;
		STRENGTH[AgeState.BABY.ordinal()] *= factor;
	}
}