import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Food extends Obj implements java.io.Serializable {
	static final long serialVersionUID = 2L;

	public enum type {SHIT, YUKKURIFOOD, BITTER, SELFFEEDER, LEMONPOP, HOT, VIYUGRA, BODY};
	// for food
	public static final int FOOD_EMPTY = 0;
	public static final int FOOD_NOT_EMPTY_NORMAL = 1;
	public static final int FOOD_NOT_EMPTY_BITTER = 2;
	public static final int FOOD_NOT_EMPTY_LEMON = 3;
	public static final int FOOD_NOT_EMPTY_HOT = 4;
	public static final int FOOD_NOT_EMPTY_VIYUGRA = 5;
	public static final int FOOD_SHADOW = 6;
	public static final int NUM_OF_FOOD_STATE = 7;

	private type foodType;
	private int amount;

	private static final int foodSize = 64;
	private static Image[] images = new Image[NUM_OF_FOOD_STATE];
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/";

		images[FOOD_EMPTY] = ImageIO.read(loader.getResourceAsStream(path+"gohan1.png"));
		images[FOOD_NOT_EMPTY_NORMAL] = ImageIO.read(loader.getResourceAsStream(path+"gohan2.png"));
		images[FOOD_NOT_EMPTY_BITTER] = ImageIO.read(loader.getResourceAsStream(path+"gohan3.png"));
		images[FOOD_NOT_EMPTY_LEMON] = ImageIO.read(loader.getResourceAsStream(path+"gohan4.png"));
		images[FOOD_NOT_EMPTY_HOT] = ImageIO.read(loader.getResourceAsStream(path+"gohan5.png"));
		images[FOOD_NOT_EMPTY_VIYUGRA] = ImageIO.read(loader.getResourceAsStream(path+"gohan2.png"));
		images[FOOD_SHADOW] = ImageIO.read(loader.getResourceAsStream(path+"gohan-shadow.png"));
		
		for (int i=0; i < NUM_OF_FOOD_STATE; i++) {
			images[i] = images[i].getScaledInstance(foodSize, foodSize/2, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
		if (isEmpty()) {
			return images[FOOD_EMPTY];
		}
		else {
			switch (foodType) {
			case YUKKURIFOOD:
			default:
				return images[FOOD_NOT_EMPTY_NORMAL];	
			case BITTER:
				return images[FOOD_NOT_EMPTY_BITTER];
			case LEMONPOP:
				return images[FOOD_NOT_EMPTY_LEMON];
			case HOT:
				return images[FOOD_NOT_EMPTY_HOT];
			case VIYUGRA:
				return images[FOOD_NOT_EMPTY_VIYUGRA];
			}
		}
	}
	
	public Image getShadowImage() {
		return images[FOOD_SHADOW];
	}
	
	public int getSize() {
		return foodSize;
	}
	
	public static int getSizeS() {
		return foodSize;
	}

	public Food(int initX, int initY, type initType) {
		objType = Type.FOOD;
		x = initX;
		y = initY;
		z = 0;
		foodType = initType;
		switch (initType) {
		case YUKKURIFOOD:
			amount = 100*24*24;
			break;
		case BITTER:
			amount = 100*24*24;
			break;
		default:
			amount = 100*24*24;
		}
		removed = false;
	}

	public type getFoodType() {return foodType; }

	public boolean isEmpty() { return (amount == 0); }
	
	public int getAmount() {
		return amount;
	}

	public void eatFood(int eatAmount)
	{
		if (isEmpty()) {
			return;
		}
		amount -= eatAmount;
		if (amount < 0) {
			amount = 0;
		}
	}

	public Event clockTick()
	{
		if (removed) {
			return Event.REMOVED;
		}
		if (!grabbed && z > 0)
		{
			z -= 2;
			if (z <= 0) {
				z = 0;
			}
		}
		if (foodType == type.SELFFEEDER) {
			amount = 60*60; // automatically filled.
		}
		return Event.DONOTHING;
	}
}
