import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class MachinePress extends Platform implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	public static final int type = 0;
	public static final int size = 256;
	private static final int images_num = 8; //このクラスの総使用画像数
	private static final int anime_pattern = 1; //このクラスのアニメーション数
	private static int AnimeImagesNum[] = {8};//アニメごとに何枚使うか
	private static Image[] images = new Image[images_num];

	private int running;
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/machinepress/";
		for( int i = 0; i < images_num ; i++ ){
			images[i] = ImageIO.read(loader.getResourceAsStream(path+"machinepress"+String.format("%03d",i+1)+".png"));		
			images[i] = images[i].getScaledInstance(size*8/8, size*4/4, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
			return images[(int)age/2%AnimeImagesNum[0]];
	}
	
	public int getSize() {
		return size;
	}

	public int checkOnObj( Obj o ) {
		int objX = o.getX();
		int objY = o.getY();
		int objZ = o.getZ();
		int platformSize = getSize()/2;
		int platformX = getX();
		int platformY = getY();
		int platformZ = getZ();
		int offsetX = (Body.MAXSIZE - getSize())*7/32-28;
		int offsetY = (Body.MAXSIZE - getSize())*6/16-40;
			if ( objZ == 0 ){	//空中の物は移動させない
				if ((platformX + offsetX+15)<=(objX) && (objX)<=(platformX + offsetX + platformSize-25)){	//X軸比較
					if ((platformY + offsetY+50)<=(objY) && (objY)<=(platformY + offsetY + platformSize-25)){	//Y軸比較
						run( o );
						return 1;
					}
				}
			}
		return 0;
	}

	public int run( Obj o ) {
		if ( o.objType == Obj.Type.YUKKURI && (int)age/2%AnimeImagesNum[0] == 0) {
			Body p = (Body)o;
			p.strikeByPress();
		}
		return 0;
	}

	public MachinePress(int initX, int initY, Direction initDir) {
		super(initX, initY, initDir);
	}
}