/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketParserUtils {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";

    public static Packet parseMessage(XmlPullParser parser) throws Exception {
        Message message = new Message();
        String id = parser.getAttributeValue("", "id");
        message.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        message.setTo(parser.getAttributeValue("", "to"));
        message.setFrom(parser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(parser.getAttributeValue("", "type")));
        String language = PacketParserUtils.getLanguageAttribute(parser);
        if (language != null && !"".equals(language.trim())) {
            message.setLanguage(language);
        }
        boolean done = false;
        String subject = null;
        String thread = null;
        Map<String, Object> properties = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("subject")) {
                    if (subject != null) continue;
                    subject = parser.nextText();
                    continue;
                }
                if (elementName.equals("body")) {
                    String xmlLang = PacketParserUtils.getLanguageAttribute(parser);
                    String body = parser.nextText();
                    message.addBody(xmlLang, body);
                    continue;
                }
                if (elementName.equals("thread")) {
                    if (thread != null) continue;
                    thread = parser.nextText();
                    continue;
                }
                if (elementName.equals("error")) {
                    message.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    properties = PacketParserUtils.parseProperties(parser);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("message")) continue;
            done = true;
        }
        message.setSubject(subject);
        message.setThread(thread);
        if (properties != null) {
            for (String name : properties.keySet()) {
                message.setProperty(name, properties.get(name));
            }
        }
        return message;
    }

    public static Presence parsePresence(XmlPullParser parser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            try {
                type = Presence.Type.valueOf(typeString);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Found invalid presence type " + typeString);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(parser.getAttributeValue("", "to"));
        presence.setFrom(parser.getAttributeValue("", "from"));
        String id = parser.getAttributeValue("", "id");
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        String language = PacketParserUtils.getLanguageAttribute(parser);
        if (language != null && !"".equals(language.trim())) {
            presence.setLanguage(language);
        }
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("status")) {
                    presence.setStatus(parser.nextText());
                    continue;
                }
                if (elementName.equals("priority")) {
                    try {
                        int priority = Integer.parseInt(parser.nextText());
                        presence.setPriority(priority);
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (IllegalArgumentException iae) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (elementName.equals("show")) {
                    String modeText = parser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(modeText));
                    }
                    catch (IllegalArgumentException iae) {
                        System.err.println("Found invalid presence mode " + modeText);
                    }
                    continue;
                }
                if (elementName.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    Map<String, Object> properties = PacketParserUtils.parseProperties(parser);
                    for (String name : properties.keySet()) {
                        presence.setProperty(name, properties.get(name));
                    }
                    continue;
                }
                presence.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("presence")) continue;
            done = true;
        }
        return presence;
    }

    public static Map<String, Object> parseProperties(XmlPullParser parser) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        block2: while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2 && parser.getName().equals("property")) {
                boolean done = false;
                String name = null;
                String type = null;
                String valueText = null;
                Object value = null;
                while (true) {
                    if (done) continue block2;
                    eventType = parser.next();
                    if (eventType == 2) {
                        String elementName = parser.getName();
                        if (elementName.equals("name")) {
                            name = parser.nextText();
                            continue;
                        }
                        if (!elementName.equals("value")) continue;
                        type = parser.getAttributeValue("", "type");
                        valueText = parser.nextText();
                        continue;
                    }
                    if (eventType != 3 || !parser.getName().equals("property")) continue;
                    if ("integer".equals(type)) {
                        value = new Integer(valueText);
                    } else if ("long".equals(type)) {
                        value = new Long(valueText);
                    } else if ("float".equals(type)) {
                        value = new Float(valueText);
                    } else if ("double".equals(type)) {
                        value = new Double(valueText);
                    } else if ("boolean".equals(type)) {
                        value = Boolean.valueOf(valueText);
                    } else if ("string".equals(type)) {
                        value = valueText;
                    } else if ("java-object".equals(type)) {
                        try {
                            byte[] bytes = StringUtils.decodeBase64(valueText);
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                            value = in.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (name != null && value != null) {
                        properties.put(name, value);
                    }
                    done = true;
                }
            }
            if (eventType == 3 && parser.getName().equals("properties")) break;
        }
        return properties;
    }

    public static XMPPError parseError(XmlPullParser parser) throws Exception {
        String errorNamespace = "urn:ietf:params:xml:ns:xmpp-stanzas";
        String errorCode = "-1";
        String type = null;
        String message = null;
        String condition = null;
        ArrayList<PacketExtension> extensions = new ArrayList<PacketExtension>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeName(i).equals("code")) {
                errorCode = parser.getAttributeValue("", "code");
            }
            if (!parser.getAttributeName(i).equals("type")) continue;
            type = parser.getAttributeValue("", "type");
        }
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("text")) {
                    message = parser.nextText();
                    continue;
                }
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) {
                    condition = elementName;
                    continue;
                }
                extensions.add(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("error")) continue;
            done = true;
        }
        XMPPError.Type errorType = XMPPError.Type.CANCEL;
        try {
            if (type != null) {
                errorType = XMPPError.Type.valueOf(type.toUpperCase());
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return new XMPPError(Integer.parseInt(errorCode), errorType, condition, message, extensions);
    }

    public static PacketExtension parsePacketExtension(String elementName, String namespace, XmlPullParser parser) throws Exception {
        Object provider = ProviderManager.getInstance().getExtensionProvider(elementName, namespace);
        if (provider != null) {
            if (provider instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)provider).parseExtension(parser);
            }
            if (provider instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
            }
        }
        DefaultPacketExtension extension = new DefaultPacketExtension(elementName, namespace);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                if (parser.isEmptyElementTag()) {
                    extension.setValue(name, "");
                    continue;
                }
                eventType = parser.next();
                if (eventType != 4) continue;
                String value = parser.getText();
                extension.setValue(name, value);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(elementName)) continue;
            done = true;
        }
        return extension;
    }

    private static String getLanguageAttribute(XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i);
            if (!"xml:lang".equals(attributeName) && (!"lang".equals(attributeName) || !"xml".equals(parser.getAttributePrefix(i)))) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String elementName, Class objectClass, XmlPullParser parser) throws Exception {
        return null;
    }

    private static Object decode(Class type, String value) throws Exception {
        if (type.getName().equals("java.lang.String")) {
            return value;
        }
        if (type.getName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.getName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.getName().equals("long")) {
            return Long.valueOf(value);
        }
        if (type.getName().equals("float")) {
            return Float.valueOf(value);
        }
        if (type.getName().equals("double")) {
            return Double.valueOf(value);
        }
        if (type.getName().equals("java.lang.Class")) {
            return Class.forName(value);
        }
        return null;
    }
}

