package jp.ito.camera;

import java.util.Collection;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class InitSetting extends Activity {
	private static final String TAG = InitSetting.class.getSimpleName();
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "onCreate");
        setContentView(R.layout.initsetting);
        setTitle("N - ݒ");

		Button btn  = (Button) findViewById(R.id.button);
        btn.setOnClickListener(btnListener);	//Xi̓o^
    }
    private OnClickListener btnListener = new OnClickListener() {
        public void onClick(View v) {
            switch(v.getId()){
            case R.id.button:
    			try {
					ConnectionConfiguration config = new ConnectionConfiguration("talk.google.com", 5222, "gmail.com");
					XMPPConnection connection = new XMPPConnection(config);
					connection.connect();
					connection.login(((EditText)findViewById( R.id.editGoogleAccount )).getText().toString(), ((EditText)findViewById( R.id.editGooglePassWord )).getText().toString());
					Roster roster = connection.getRoster();
					String[] groups = {"N"};
					String parent = ((EditText)findViewById( R.id.editParent )).getText().toString();
					if ( parent.equals("clear") ){
						Collection<RosterEntry> entries = roster.getEntries();
						for (RosterEntry entry : entries) {
							roster.removeEntry(entry);
						}
						Toast toast = Toast.makeText(getApplicationContext(), "NA܂", Toast.LENGTH_LONG);
						toast.show();
						break;
					}
					if (parent.length() != 0){
						roster.createEntry(parent, parent, groups);
					}
					roster.createEntry("mimamorikunn@appspot.com", "mimamorikunn", groups);
				} catch (XMPPException e) {
					Toast toast = Toast.makeText(getApplicationContext(), "ݒG[:" + e.getMessage(), Toast.LENGTH_LONG);
					toast.show();
					break;
				}

                SharedPreferences pref = getSharedPreferences("jp.ito.mimamori",MODE_PRIVATE);
        		Editor e = pref.edit();
        		e.putString(XmppSetting.USER, ((EditText)findViewById( R.id.editGoogleAccount )).getText().toString());
        		e.putString(XmppSetting.PASSWORD, ((EditText)findViewById( R.id.editGooglePassWord )).getText().toString());
        		e.putString(XmppSetting.PARENT, ((EditText)findViewById( R.id.editParent )).getText().toString());
        		e.putString(MailSetting.ADDRESS, ((EditText)findViewById( R.id.editGoogleAccount )).getText().toString() + "@gmail.com");
        		e.putString(MailSetting.PASSWORD, ((EditText)findViewById( R.id.editGooglePassWord )).getText().toString());
        		e.commit();
        		Intent intent = new Intent();
        		setResult(RESULT_OK, intent);
        		finish();
                break;
            }
        }
    };
    @Override
    protected void onStart() {
        super.onStart();
		Log.d(TAG, "onStart()");
    }
    //Av̊Jn
    @Override
    protected void onResume() {
        super.onResume();
		Log.d(TAG, "onResume()");
    }

    @Override
    protected void onPause(){
		super.onPause();
		Log.d(TAG, "onPause()");
	}

    //Av̒~
    @Override
    protected void onStop() {
        super.onStop();
		Log.d(TAG, "onStop()");
    }    

    @Override
    protected void onDestroy(){
		super.onDestroy();
		Log.d(TAG, "onDestroy()");
	}
}
