import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;


public class Card {
	static Integer[] _card = new Integer[13*4+1];
	static final String[] MARK = { "s", "h", "d", "c" };
	static final String[] NUM = { "A", "2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K" };
	static Random rnd = new Random(System.currentTimeMillis());
	static {
		for ( int i = 0; i < _card.length; i++ ){
			_card[i] = i;
		}
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Integer[] card = _card.clone();
		for ( int i = 0; i < card.length; i++ ){
			System.out.print( toString(card[i]) + "," );
		}
		System.out.println();
		card = shuffle(card);
		for ( int i = 0; i < card.length; i++ ){
			System.out.print( toString(card[i]) + "," );
		}
		System.out.println();
		List[] playerCard = deal(card, 4);
		for ( int i = 0; i < playerCard.length; i++ ){
			Object obj = playerCard[i].toArray();
			card = (Integer[])(playerCard[i].toArray(new Integer[0]));
			for ( int j = 0; j < card.length; j++ ){
				System.out.print( toString(card[j]) + "," );
			}
			System.out.print(" => ");
			card = sort(card);
			for ( int j = 0; j < card.length; j++ ){
				System.out.print( toString(card[j]) + "," );
			}
			System.out.print(" => ");
			card = discard(card);
			for ( int j = 0; j < card.length; j++ ){
				System.out.print( toString(card[j]) + "," );
			}
			System.out.println();
		}
	}
	public static String toString(int i) {
		if ( i == _card.length - 1 ){
			return "JK";
		} else if ( i > _card.length - 1 ){
			return "ER";
		}
		int mark = i % 4;
		int num = i / 4;
		return MARK[mark] + NUM[num];
	}
	public static Integer[] getCard() {
		return _card.clone();
	}
	public static Integer[] sort(Integer[] card) {
		Arrays.sort(card);
		return card;
	}
	public static Integer[] shuffle(Integer[] card) {
		Integer[] ret = new Integer[card.length];
//		ArrayList list = new ArrayList(Arrays.asList(card));
//		List list = Arrays.asList(card); 
		List<Integer> list = new ArrayList<Integer>();
		for ( int i = 0; i < card.length; i++ ){
			list.add(card[i]);
		}
		for ( int i = 0; i < card.length; i++ ){
			int index = rnd.nextInt(list.size());
			ret[i] = list.remove(index);
		}
		return ret;
	}
	public static List[] deal(Integer[] card, int nPlayer) {
		List[] playerCard = new List[nPlayer];
		for ( int i = 0; i < nPlayer; i++ ){
			playerCard[i] = new ArrayList();
		}
		for ( int i = 0; i < card.length; i++ ){
			int idx = i % nPlayer;
			playerCard[idx].add(card[i]);
		}
		return playerCard;
	}
	public static Integer[] discard(Integer[] card) {
		List list = new ArrayList();
		for ( int i = 0; i < card.length; i++ ){
			if ( i == card.length - 1){
				list.add(card[i]);
				break;
			}
			int n1 = card[i] / 4;
			int n2 = card[i+1] / 4;
			if ( n1 == n2 ){
				++i;
			} else {
				list.add(card[i]);
			}
		}
		return (Integer[])list.toArray(new Integer[0]);
	}
	public static Integer[] add(Integer[] cards, Integer arg) {
		Integer[] ret = new Integer[cards.length + 1];
		for ( int i = 0; i < cards.length; i++ ){
			ret[i] = cards[i];
		}
		ret[cards.length] = arg;
		return ret;
	}
	public static Integer[] del(Integer[] cards, int idx) {
		Integer[] ret = new Integer[cards.length - 1];
		for ( int i = 0, j = 0; i < ret.length; i++, j++ ){
			if ( i == idx ){
				j++;
			}
			ret[i] = cards[j];
		}
		return ret;
	}
}
