import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;

public class Client {
	public static int port_no = 5550;
	public static String hostName = "localhost";
	public static int intv_time = 100;
	static String _name;
	Integer[] _card;
	public static void main(String[] args) {
		_name = args[0];
		Client c = new Client();
		c.start();
	}
	
	public void start() {
		try {
			Socket socket = new Socket(hostName, port_no);
			OutputStream os = socket.getOutputStream();
			InputStream is = socket.getInputStream();

			ObjectOutputStream oos = new ObjectOutputStream(os);
			ObjectInputStream ois = new ObjectInputStream(is);
			ClientThread st = new ClientThread(oos);
			Thread t = new Thread(st);
			t.start();

			Command.send(oos, Command.CMD_CONNECT, _name);
			while (is.available() >= 0) {
				while (is.available() >= 0) {
					if (is.available() == 0){
						Thread.sleep(intv_time);
						continue;
					}
					int cmd = ois.readInt();
					Object obj = ois.readObject();
					func(cmd, obj, oos);
				}
			}
			System.out.println();
			socket.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	class ClientThread implements Runnable {
		private ObjectOutputStream _oos = null;
		public ClientThread(ObjectOutputStream oos){
			_oos = oos;
		}
		@Override
		public void run() {
			try {
				System.out.println("oldMaind - client");

				Thread.sleep(1000000);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	private void func(int cmd, Object obj, ObjectOutputStream oos) throws Exception{
		List list = null;
		switch(cmd){
		case Command.CMD_DEAL:
			_card = (Integer[])obj;
			sortAndDisplay();
			break;
		case Command.CMD_PICKUP:
			String msg = (String)obj;
			System.out.println(msg);
			int idx = 0;
			while (true){
				System.out.print("input 1-" + _card.length + "\n" + _name + ">");
				try {
					String buf = new BufferedReader(new InputStreamReader(System.in)).readLine();
					idx = Integer.parseInt(buf) - 1;
					if (idx >= 0 && idx < _card.length){
						break;
					}
				} catch (Exception e) {
				}
			}
			Command.send(oos, Command.CMD_CARD_DEL, _card[idx]);
			_card = Card.del(_card, idx);
			sortAndDisplay();
			break;
		case Command.CMD_CARD_ADD:
			System.out.println("pickup [" + Card.toString((Integer)obj) + "]");
			_card = Card.add(_card, (Integer)obj);
			sortAndDisplay();
			break;
		}
	}
	private void sortAndDisplay() throws Exception{
		for ( int j = 0; j < _card.length; j++ ){
			System.out.print( Card.toString(_card[j]) + "," );
		}
		System.out.println(" sort =>");
		Thread.sleep(100);
		_card = Card.sort(_card);
		for ( int j = 0; j < _card.length; j++ ){
			System.out.print( Card.toString(_card[j]) + "," );
		}
		System.out.println(" discard =>");
		Thread.sleep(100);
		_card = Card.discard(_card);
		for ( int j = 0; j < _card.length; j++ ){
			System.out.print( Card.toString(_card[j]) + "," );
		}
		System.out.println();
	}
}
