package jp.co.spiritek.dev.mapapp;

import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;

import android.location.LocationManager;
import android.os.Bundle;
/*
 * see:
 * http://www.spiritek.co.jp/spkblog/
 */
public class MapSampleActivity extends MapActivity {
	MyLocationOverlay myLocationOverlay;
    MapView mapView;
    MapController controller;

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

//        MapView mapView = (MapView)findViewById(R.id.mapview);
//        MapController controller = mapView.getController();
//        GeoPoint point = new GeoPoint((int)(35.658704 * 1E6), (int)(139.745408 * 1E6));
//        controller.setCenter(point);
        mapView = (MapView)findViewById(R.id.mapview);
        controller = mapView.getController();
        controller.setZoom(17);
        myLocationOverlay = new MyLocationOverlay(getApplicationContext(),
                mapView);
        myLocationOverlay.onProviderEnabled(LocationManager.GPS_PROVIDER);
        myLocationOverlay.enableMyLocation();
        myLocationOverlay.runOnFirstFix(new Runnable() {
            public void run() {
                controller.animateTo(myLocationOverlay.getMyLocation());
            }
        });
        mapView.getOverlays().add(myLocationOverlay);
        mapView.invalidate();
    }

	@Override
	protected boolean isRouteDisplayed() {
		// TODO Auto-generated method stub
		return false;
	}
 }