package com.kekenzy.model.sqllite.helper;

import java.util.ArrayList;
import java.util.List;


public class AbstractTable {
	protected String tb_name;
	protected int columnCnt;
	protected ArrayList al;

	public ArrayList<TableColumnBean> getColumns() {
		return al;
	}
	public String getTableName() {
		return tb_name;
	}


	public String[] getColumnList(){
		String[] columnList = new String[columnCnt];

		int index = 0;
		for (int i=0; i<al.size(); i++) {
			columnList[index] = ((TableColumnBean)al.get(i)).getName();
			index++;
		}

		return columnList;
	}


	public String createTable(){
		StringBuffer sb = new StringBuffer("CREATE TABLE IF NOT EXISTS " + tb_name);

		sb.append("(");
		for (int i=0; i<al.size(); i++) {
			sb.append(((TableColumnBean)al.get(i)).getName());
			sb.append(" ");
			sb.append(((TableColumnBean)al.get(i)).getType());
			sb.append(",");
		}
		sb.deleteCharAt(sb.length()-1);
		sb.append(");");
		return sb.toString();
	}

	public String dropTable(){
		StringBuffer sb = new StringBuffer("DROP TABLE " + tb_name + ";");
		return sb.toString();
	}

}
