package com.kekenzy.model.sqllite.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import android.util.Log;


public class RunningDbHelper extends SQLiteOpenHelper {

	static final String TAG = "RunningDbHelper";

	private static final int DB_VERSION = 1;
	private static final String DB = "running.db";

	MapPosTB tb;
	RunningTB rb;

	public RunningDbHelper(Context context) {
		super(context, DB, null, DB_VERSION);
		tb = new MapPosTB();
		rb = new RunningTB();
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		String sql = rb.createTable();
		db.execSQL(sql);
        Log.d(TAG, "onCreate" + sql );
		sql = tb.createTable();
		db.execSQL(sql);
        Log.d(TAG, "onCreate" + sql );
	}


	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		String sql = rb.dropTable();
		db.execSQL(sql);
        Log.d(TAG, "dropTable" + sql );
		sql = rb.dropTable();
		db.execSQL(sql);
        Log.d(TAG, "dropTable" + sql );
		onCreate(db);
	}

	public String[] getRunnningTBColumnList(){
		return rb.getColumnList();
	}

}
