package demo.soot;

import java.util.Map;

import soot.Body;
import soot.BodyTransformer;
import soot.PackManager;
import soot.Transform;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.HashMutablePDG;
import soot.toolkits.graph.pdg.PDGNode;
import soot.toolkits.graph.pdg.ProgramDependenceGraph;
import demo.util.MemoryInfo;

public class ControlAndDataDependencePerformance {

	public static void main(String[] args) {
		PackManager.v().getPack("jap").add(new Transform("jap.myTransform", new BodyTransformer() {
			@Override
			protected void internalTransform(Body body, String phase, Map options) {
				UnitGraph graph = new ExceptionalUnitGraph(body);
				ProgramDependenceGraph pdg = new HashMutablePDG(graph);
				for (PDGNode node1: pdg.getNodes()) {
					for (PDGNode node2: pdg.getDependents(node1)) {
//						System.out.println(node1.toShortString() + " -> " + node2.toShortString());
					}
				}
			}
		}));
		
		long start = System.currentTimeMillis();
		soot.Main.main(args);
		long end = System.currentTimeMillis();

		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
