package demo.soba;

import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.util.callgraph.CallGraph;
import soba.util.files.ClasspathUtil;
import demo.util.MemoryInfo;

public class CallGraphPerformance {

	public static void main(String[] args) {
		long start = System.currentTimeMillis();
		
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		CallGraph cg = new CallGraph(program);
		for (MethodInfo caller: cg.getMethods()) {
			for (MethodInfo callee: cg.getCallees(caller)) {
//				System.out.println(caller.toLongString() + " may call " + callee.toLongString());
			}
		}
		
		long end = System.currentTimeMillis();
		
		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
