package demo.util;

import java.text.DecimalFormat;

public class MemoryInfo {

	public static String getMemoryInfo() {
	    DecimalFormat f1 = new DecimalFormat("#,###KB");
	    DecimalFormat f2 = new DecimalFormat("##.#");
	    long free = Runtime.getRuntime().freeMemory() / 1024;
	    long total = Runtime.getRuntime().totalMemory() / 1024;
	    long max = Runtime.getRuntime().maxMemory() / 1024;
	    long used = total - free;
	    double ratio = (used * 100 / (double)total);
	    String info = 
	    "Java Memory: total=" + f1.format(total) + "A" +
	    "used=" + f1.format(used) + " (" + f2.format(ratio) + "%)A" +
	    "available="+f1.format(max);
	    return info;
	}
	
}
