package demo.soba;

import demo.util.MemoryInfo;
import soba.core.ClassHierarchy;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.util.files.ClasspathUtil;

public class ClassHierarchyPerformance {

	public static void main(String[] args) {
		long start = System.currentTimeMillis();
		
		JavaProgram program = new JavaProgram(ClasspathUtil.getClassList(args));
		ClassHierarchy ch = program.getClassHierarchy();
		for (ClassInfo c: program.getClasses()) {
			for (MethodInfo m: c.getMethods()) {
				for (CallSite cs: m.getCallSites()) {
					MethodInfo[] callees = ch.resolveCall(cs);
					if (callees.length > 0) {
						for (MethodInfo callee: callees) {
							System.out.println(" [inside] " + m.toLongString() + " may call " + callee.toLongString());
						}
					} else {
						System.out.println(" [outside] " + cs.toString());
					}
				}
			}
		}
		
		long end = System.currentTimeMillis();
		
		System.err.println((end - start) + " [ms]");
		System.err.println(MemoryInfo.getMemoryInfo());
	}

}
