﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Somali.Base
{
    public abstract class Model
    {
        public bool IsInstanceOfType( Type type )
        {
            return type.Equals( this.GetType() );
        }

        public bool TryGetModelImpl<T>( out T model )
            where T : Model
        {
            if ( IsInstanceOfType( typeof(T) ) )
            {
                model = (T)this;
                return true;
            }
            else
            {
                model = default(T);
                return false;
            }
        }
    }
}
