/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Char.cpp,v 1.23 2004/03/21 05:48:06 randy Exp $
 */

#include "soopy.h"

//
// SpChar Util routines
//
//const char* spCharToCString(SpChar ch, Writer& writer)
const char* spCharToCString(SpChar ch, WriteEncoder& writer)
{
    ostringstream ost;
    StreamWriter sw(&ost);
    Writer* old = writer.getWriter();
    writer.setWriter(&sw);
    writer.WriteChar(ch);
    writer.setWriter(old);

    static string str;
    str = ost.str();
    return str.c_str();
}

bool isEOF(SpChar c)
{
    return c == (SpChar)NULL;
}

bool isEOL(SpChar c)
{
    switch(c){
#ifdef __WIN32__
    case JIS('\n'):
#else
    case JIS('\r'):
    case JIS(10):
#endif
    case 0: // EOF
        return true;
    }
    return false;
}

bool isWhiteSpace(SpChar c)
{
    switch(c){
    case JIS(' '):
    case JIS('\t'):
    case JIS(8):
    case JIS(13):
    case JIS(10):
      //case JIS('\n'):
      //case JIS('\r'):
        return true;
    }
    return false;
}

bool isAlpha(SpChar c)
{
    if((JIS('a') <= c) && (c <= JIS('z')) ||
       (JIS('A') <= c) && (c <= JIS('Z')))
    {
      return true;
    }else{
      return false;
    }
}

bool isDIGIT(SpChar c)
{
    switch(c){
    case JIS('0'):
    case JIS('1'):
    case JIS('2'):
    case JIS('3'):
    case JIS('4'):
    case JIS('5'):
    case JIS('6'):
    case JIS('7'):
    case JIS('8'):
    case JIS('9'):
        return true;
    }
    return false;
}

int toINT(SpChar c)
{
    switch(c){
    case JIS('0'):
        return 0;
    case JIS('1'):
        return 1;
    case JIS('2'):
        return 2;
    case JIS('3'):
        return 3;
    case JIS('4'):
        return 4;
    case JIS('5'):
        return 5;
    case JIS('6'):
        return 6;
    case JIS('7'):
        return 7;
    case JIS('8'):
        return 8;
    case JIS('9'):
        return 9;
    }
    throw SpException("not digit");
}

SpChar Zenkaku2Hankaku(SpChar ch)
{
    if(0x2330 <=ch && ch <= 0x2339)
    {
        // '0' - '9'
//cout << " digit\n";
        ch = ch - 0x2330 + '0';
    }else if(0x2341 <=ch && ch <= 0x235A)
    {
        // 'A' - 'Z'
//cout << " A-Z\n";
        ch = ch - 0x2341 + 'A';
    }else if(0x2361 <=ch && ch <= 0x237A)
    {
        // 'a' - 'z'
//cout << " a-z\n";
        ch = ch - 0x2361 + 'a';
    }else{
        switch(ch){
        case 0x2121: ch = ' '; break;
        case 0x212a: ch = '!'; break;
        case 0x2149: ch = '"'; break;
        case 0x2174: ch = '#'; break;
        case 0x2170: ch = '$'; break;
        case 0x2173: ch = '%'; break;
        case 0x2175: ch = '&'; break;
        case 0x2147: ch = '\''; break;
        case 0x214a: ch = '('; break;
        case 0x214b: ch = ')'; break;
        case 0x2176: ch = '*'; break;
        case 0x215c: ch = '+'; break;
        case 0x2122: ch = ','; break;
        case 0x2124: ch = ','; break;
        case 0x215d: ch = '-'; break;
        case 0x2125: ch = '.'; break;
        case 0x2123: ch = '.'; break;
        case 0x213f: ch = '/'; break;
        case 0x2160: ch = '/'; break;
        case 0x2127: ch = ':'; break;
        case 0x2128: ch = ';'; break;
        case 0x2152: ch = '<'; break;
        case 0x2163: ch = '<'; break;
        case 0x2161: ch = '='; break;
        case 0x2153: ch = '>'; break;
        case 0x2164: ch = '>'; break;
        case 0x2129: ch = '?'; break;
        case 0x2177: ch = '@'; break;
        case 0x214e: ch = '['; break;
        case 0x2140: ch = '\\'; break;
        case 0x216f: ch = '\\'; break;
        case 0x214f: ch = ']'; break;
        case 0x2130: ch = '^'; break;
        case 0x2132: ch = '_'; break;
        case 0x2150: ch = '{'; break;
        case 0x2143: ch = '|'; break;
        case 0x2151: ch = '}'; break;
        case 0x2141: ch = '~'; break;
        case 0x2131: ch = '~'; break;
        }
    }
//cout << "conv: " << hex << ch << endl;
    return ch;
}

SpChar toHankakuLower(SpChar c)
{
    if(EqualCharCode(c, CodeJIS)){
//cout << "spch: " << hex << c << endl;
        SpChar ch = SpCharGetChar(c);
        ch = Zenkaku2Hankaku(ch);
        if(('A' <= ch) && (ch <= 'Z')){
            return MakeSpChar(CodeJIS, ch - ('A' - 'a'));
        }
        return MakeSpChar(CodeJIS, ch);
    }
    return c;
}


/*
 * Message Handler
 */

//
// Primitives
//
SpValue& char_lower(SpValue& v)
{
    SpChar c = v.getChar();
    c = SpChar2Lower(c);
    //    static SpValue res;
    //    res.setSpChar(c);
    //    return res;
    return SpCharResult(c);
}

SpValue& char_upper(SpValue& v)
{
    SpChar c = v.getChar();
    c = SpChar2Upper(c);
    //    static SpValue res;
    //    res.setSpChar(c);
    //    return res;
    return SpCharResult(c);
}

SpValue& char_pred(SpValue& v)
{
    SpChar c = v.getChar();
    //    static SpValue res;
    //    res.setSpChar(--c);
    //    return res;
    return SpCharResult(--c);
}

SpValue& char_succ(SpValue& v)
{
    SpChar c = v.getChar();
    //    static SpValue res;
    //    res.setSpChar(++c);
    //    return res;
    return SpCharResult(++c);
}

SpValue& char_toInt(SpValue& v)
{
    SpChar c = v.getChar();
    //    static SpValue res;
    //    res.setSpChar(c);
    //    res.typ = TypeInt;
    //    return res;
    return SpIntResult((SpInt)c);
}

SpValue& char_toString(SpValue& v)
{
    SpString* str = new SpString;
    str->addSpChar(v.getChar());
    //    static SpValue res;
    //    res.setNewObject(str);
    //    return res;
    return SpObjectResult(str);
}

SpValue& char_isAlpha(SpValue& v)
{
    SpChar c = v.getChar();
    if(isAlpha(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isDigit(SpValue& v)
{
    SpChar c = v.getChar();
    if(isDIGIT(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isAlphaNum(SpValue& v)
{
    SpChar c = v.getChar();
    if(isAlpha(c) || isDIGIT(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isHexDigit(SpValue& v)
{
    SpChar c = v.getChar();
    if(isDIGIT(c)){
      return TrueObject;
    }else if((JIS('a') <= c) && (c <= JIS('f')) ||
              (JIS('A') <= c) && (c <= JIS('F')))
    {
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isSpace(SpValue& v)
{
    SpChar c = v.getChar();
    if(isWhiteSpace(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isLower(SpValue& v)
{
    SpChar c = v.getChar();
    if(isLower(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isUpper(SpValue& v)
{
    SpChar c = v.getChar();
    if(isUpper(c)){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isDoubleByte(SpValue& v)
{
    SpChar c = v.getChar();
    c = SpCharGetChar(c);
    if(0x0100 <= c && c <= 0xFFFF){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

SpValue& char_isWide(SpValue& v)
{
    SpChar c = v.getChar();
    c = SpCharGetChar(c);
    if(0x0100 <= c){
      return TrueObject;
    }else{
      return FalseObject;
    }
}

// init Message Handler
void initChar()
{
    CharMsgHandler.append(SymIsChar, PrimTrue);

    SpValue PrimLower(new SpPrim1(char_lower));
    CharMsgHandler.append(SymLower, PrimLower);

    SpValue PrimUpper(new SpPrim1(char_upper));
    CharMsgHandler.append(SymUpper, PrimUpper);

    SpValue PrimPred(new SpPrim1(char_pred));
    CharMsgHandler.append(SymPred, PrimPred);

    SpValue PrimSucc(new SpPrim1(char_succ));
    CharMsgHandler.append(SymSucc, PrimSucc);

    SpValue PrimToInt(new SpPrim1(char_toInt));
    CharMsgHandler.append(SymToInt, PrimToInt);

    SpValue PrimToString(new SpPrim1(char_toString));
    CharMsgHandler.append(SymToString, PrimToString);

    SpValue SymIsAlpha(new SpSymbol("isalpha?"));
    SpValue PrimIsAlpha(new SpPrim1(char_isAlpha));
    CharMsgHandler.append(SymIsAlpha, PrimIsAlpha);

    SpValue SymIsDigit(new SpSymbol("isdigit?"));
    SpValue PrimIsDigit(new SpPrim1(char_isDigit));
    CharMsgHandler.append(SymIsDigit, PrimIsDigit);

    SpValue SymIsAlphaNum(new SpSymbol("isalphanum?"));
    SpValue PrimIsAlphaNum(new SpPrim1(char_isAlphaNum));
    CharMsgHandler.append(SymIsAlphaNum, PrimIsAlphaNum);

    SpValue SymIsHexDigit(new SpSymbol("ishexdigit?"));
    SpValue PrimIsHexDigit(new SpPrim1(char_isHexDigit));
    CharMsgHandler.append(SymIsHexDigit, PrimIsHexDigit);

    SpValue SymIsSpace(new SpSymbol("isspace?"));
    SpValue PrimIsSpace(new SpPrim1(char_isSpace));
    CharMsgHandler.append(SymIsSpace, PrimIsSpace);

    SpValue SymIsUpper(new SpSymbol("isupper?"));
    SpValue PrimIsUpper(new SpPrim1(char_isUpper));
    CharMsgHandler.append(SymIsUpper, PrimIsUpper);

    SpValue SymIsLower(new SpSymbol("islower?"));
    SpValue PrimIsLower(new SpPrim1(char_isLower));
    CharMsgHandler.append(SymIsLower, PrimIsLower);

    SpValue SymIsDoubleByte(new SpSymbol("isdoublebytechar?"));
    SpValue PrimIsDoubleByte(new SpPrim1(char_isDoubleByte));
    CharMsgHandler.append(SymIsDoubleByte, PrimIsDoubleByte);

    SpValue SymIsWide(new SpSymbol("iswidechar?"));
    SpValue PrimIsWide(new SpPrim1(char_isWide));
    CharMsgHandler.append(SymIsWide, PrimIsWide);
}
