/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Except.cpp,v 1.10 2004/03/24 11:53:44 randy Exp $
 */

#include <stdio.h>
#include "soopy.h"

// SpException
const char* SpException::what() const throw()
{
    static char buf[256];
    sprintf(buf, "%s,  file '%s', line %d", str, file, line);
    return buf;
}

// SpIllegalMessageException
const char* SpIllegalMessageException::what() const throw()
{
  static char buf[256];
#ifdef _MBCS
  _snprintf(buf, 255, "Illegal message. <%s> is not symbol.", ((SpValue)msg).toCString());
#else
  snprintf(buf, 255, "Illegal message. <%s> is not symbol.", ((SpValue)msg).toCString());
#endif
  return buf;
}

// SpSystemError
const char* SpSystemError::what() const throw()
{
    static char buf[2048];
    sprintf(buf, "%s, file '%s:%d', source '%s:%d'", str, file, line, filename, lineno);
    return buf;
}

// SpNoMethodException
const char* SpNoMethodException::what() const throw()
{
    static char buf[2048];
    sprintf(buf, "%s, receiver=%s, message=%s, file '%s', line %d", str, receiver, message, file, line);
    return buf;
}

// SpKeyException
const char* SpKeyException::what() const throw()
{
    static char buf[2048];
    sprintf(buf, "%s, %s, file '%s', line %d", str, key, file, line);
    return buf;
}

// SpTypeException
const char* SpTypeException::what() const throw()
{
    static char buf[2048];
    sprintf(buf, "%s. declare type '%s' but value type '%s', file '%s', line %d",
            str, rtype, vtype, file, line);
    return buf;
}

