/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Expr.cpp,v 1.12 2004/03/24 11:53:44 randy Exp $
 */

#include "soopy.h"

SpValue& SpQuote::toString(){
    SpString* str = new SpString("$");
    *str += expr;
    //    static SpValue v;
    //    v.setNewObject(str);
    //    return v;
    return SpObjectResult(str);
}

/*
 * class ExprUMinus
 */
SpValue& ExprUMinus::eval()
{
    //    static SpValue result;
    //    result = expr.eval().uminus();
    //    return result;

    //return SpValueResult(expr.eval().uminus());
    SpValue temp;
    temp = expr.eval();
    return SpValueResult(temp.uminus());
}

SpValue& ExprUMinus::toString()
{
    SpString* str;

    str = new SpString();
    *str = "-";
    *str += expr.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}


/*
 * class ExprPlus
 */

SpValue& ExprPlus::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.plus(v2);
    //    return result;
    return SpValueResult(v1.plus(v2));
}

SpValue& ExprPlus::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " + ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprMinus
 */

SpValue& ExprMinus::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.minus(v2);
    //    return result;
    return SpValueResult(v1.minus(v2));
}

SpValue& ExprMinus::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " - ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprTimes
 */

SpValue& ExprTimes::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.times(v2);
    //    return result;
    return SpValueResult(v1.times(v2));
}

SpValue& ExprTimes::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " * ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprDiv
 */

SpValue& ExprDiv::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.div(v2);
    //    return result;
    return SpValueResult(v1.div(v2));
}

SpValue& ExprDiv::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " / ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprMod
 */

SpValue& ExprMod::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.mod(v2);
    //    return result;
    return SpValueResult(v1.mod(v2));
}

SpValue& ExprMod::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " % ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprNOT
 */
SpValue& ExprNOT::eval()
{
    //    static SpValue result;
    //    result = expr.eval().boolNot();
    //    return result;

    //return SpValueResult(expr.eval().boolNot());
    SpValue temp;
    temp = expr.eval();
    return SpValueResult(temp.boolNot());
}

SpValue& ExprNOT::toString()
{
    SpString* str;

    str = new SpString();
    *str = "!";
    *str += expr.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprAND
 */

SpValue& ExprAND::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.boolAnd(v2);
    //    return result;
    return SpValueResult(v1.boolAnd(v2));
}

SpValue& ExprAND::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " && ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprOR
 */

SpValue& ExprOR::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.boolOr(v2);
    //    return result;
    return SpValueResult(v1.boolOr(v2));
}

SpValue& ExprOR::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " || ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprEQ (==)
 */

SpValue& ExprEQ::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.eq(v2);
    //    return result;
    return SpValueResult(v1.eq(v2));
}

SpValue& ExprEQ::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " == ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprNE (!=)
 */

SpValue& ExprNE::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.ne(v2);
    //    return result;
    return SpValueResult(v1.ne(v2));
}

SpValue& ExprNE::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " != ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprGT (>)
 */

SpValue& ExprGT::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.gt(v2);
    //    return result;
    return SpValueResult(v1.gt(v2));
}

SpValue& ExprGT::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " > ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprGE
 */

SpValue& ExprGE::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.ge(v2);
    //    return result;
    return SpValueResult(v1.ge(v2));
}

SpValue& ExprGE::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " >= ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class Expr
 */

SpValue& ExprLT::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.lt(v2);
    //    return result;
    return SpValueResult(v1.lt(v2));
}

SpValue& ExprLT::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " < ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprLE
 */

SpValue& ExprLE::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.le(v2);
    //    return result;
    return SpValueResult(v1.le(v2));
}

SpValue& ExprLE::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " <= ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprWColon
 */

SpValue& ExprWColon::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.wcolon(v2);
    //    return result;
    return SpValueResult(v1.wcolon(v2));
}

SpValue& ExprWColon::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " :: ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class ExprAT
 */

SpValue& ExprAT::eval()
{
    SpValue v1, v2;
    v1 = expr1.eval();
    v2 = expr2.eval();
    //    static SpValue result;
    //    result = v1.at(v2);
    //    return result;
    return SpValueResult(v1.at(v2));
}

SpValue& ExprAT::toString()
{
    SpString* str;

    str = new SpString();
    *str += expr1.toString();
    *str += " @ ";
    *str += expr2.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

