/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Handler.cpp,v 1.15 2004/03/28 02:30:35 randy Exp $
 */

#include "soopy.h"


bool VVCmp::operator()(const SpValue& key1, const SpValue& key2) const
{
    return (SpValue&)key1 < (SpValue&)key2;
}

MsgHandler::~MsgHandler()
{
}

void MsgHandler::append(SpValue& message, SpValue& handler)
{
//    VVMap::iterator it;
//    it = aMap.find(message);
//    if(it != aMap.end()){
//        aMap.erase(it);
//    }
    aMap[message] = handler;
}

bool MsgHandler::hasMessage(SpValue& message)
{
    VVMap::iterator it;
    it = aMap.find(message);
    if(it == aMap.end()){
        return false;
    }
    return true;
}

SpValue& MsgHandler::operator()(SpValue& receiver, SpValue& message)
{
    VVMap::iterator it;
    it = aMap.find(message);
    if(it == aMap.end()){
        if(parent == NULL){
            static char buf[256];
            strncpy(buf, receiver.toCStringWithEncoder(), 255);
            buf[255] = '\0';
            static char buf2[256];
            strncpy(buf2, message.toCStringWithEncoder(), 255);
            buf2[255] = '\0';
            throw SpNoMethodException("no such a feature", buf, buf2);
        }
        //        return (*parent)(receiver, message);
        return SpValueResult((*parent)(receiver, message));
    }
    SpFunc* f = dynamic_cast<SpFunc*>(it->second.getObject());
    if(f == NULL){ throw SpException("call not function"); }
    //    return (*f)(receiver);
    SpValue result = (*f)(receiver);
    return SpValueResult(result);
}
