/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: If.cpp,v 1.12 2004/03/21 05:48:06 randy Exp $
 */

#include "soopy.h"

SpValue& SpIf::eval()
{
    SpValue condition = cond.eval();
    SpNameSpace* ns = new SpNameSpace(getCurrentNS());
    SpValue taker(ns);

    SpTuple* tuple = assoc.asTuple();
    SpValueVector::iterator it = tuple->begin();
    for(; it != tuple->end(); it++){
        NSPairAdaptor* adapt = dynamic_cast<NSPairAdaptor*>(it->getObject());
        if(adapt == NULL){ throw SpSystemError(__FILE__, __LINE__); }
        NSPair* pair = adapt->pair;

        ns->clear();
        if(pair->first.match(condition, ns)){
            //            static SpValue result;
            SpValue result;
            pushCurrentNS(taker);
            try{
                if(pair->second.isList()){
                    // second is list.
                    SpValue L = pair->second;
                    while(L.isList()){
                        SpList* list = dynamic_cast<SpList*>(L.getObject());
                        SpValue v = list->value();
                        result = v.eval();
                        L = list->nextList();
                    }
                }else{ // not list
                    result = pair->second.eval();
                }
            }catch(...){
	      popCurrentNS();
	      throw;
            }
            popCurrentNS();
	    //            return result;
	    return SpValueResult(result);
        }
    }
    return NilObject; // not match
}

SpValue& SpIf::toString()
{
    SpString* str;

    str = new SpString();
    *str += "if(";
    *str += cond.toString();
    *str += "){\n";

    SpTuple* tuple = assoc.asTuple();
    SpValueVector::iterator it = tuple->begin();
    for(; it != tuple->end(); it++){
        NSPairAdaptor* adapt = dynamic_cast<NSPairAdaptor*>(it->getObject());
        if(adapt == NULL){ throw SpSystemError(__FILE__, __LINE__); }
        NSPair* pair = adapt->pair;

        *str += "  ";
        *str += pair->first;
        *str += ": ";
        *str += pair->second;
        *str += ";\n";
    }
    *str += "}";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}
