/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Japanese.cpp,v 1.7 2004/03/21 05:48:06 randy Exp $
 */

#include "soopy.h"

/*
 * Class JapaneseReadDecoder
 */

SpChar JapaneseReadDecoder::readCh()
{
    SpChar c;
    int ch1, ch2;

    if(encoder != NULL){
        return encoder->ReadChar();
    }

    if(eof()){ return (SpChar)NULL; }
    c = reader->ReadChar();
    if(isEOF(c)){ return (SpChar)NULL; }
    ch1 = c & 0xff;
    if(ch1 == 0x1B){
        reader->UnreadChar(c);
        setEncoder(new ISO2022JPReadDecoder(reader));
        return encoder->ReadChar();
    }else if(ch1 > 0x7F){
        unsigned char s[3];
        s[0] = c;
        c = reader->ReadChar();
        ch2 = c & 0xff;
        s[1] = c;
        s[2] = '\0';
        istringstream is((char*)s);
        StreamReader* r = new StreamReader(&is);
        SpValue taker(r);
        if((0xA1 <= ch1 && ch1 <= 0xFE) &&
           (0xA1 <= ch2 && ch2 <= 0xFE)){ // Euc
            EucJPReadDecoder euc_enc(r);
            c = euc_enc.ReadChar();
            setEncoder(new EucJPReadDecoder(reader));
        }else{ // Sjis
            SjisReadDecoder sjis_enc(r);
            c = sjis_enc.ReadChar();
            setEncoder(new SjisReadDecoder(reader));
        }
    }else{
        c = MakeSpChar(CodeJIS, c);
    }
    return c;
}

/*
 * JapaneseFile
 *   openIn, openOut
 */

SpValue& japanese_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Japanese.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
    fin->open(filename);
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
    ReadEncoder* encoder = new JapaneseReadDecoder(sr);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& japanese_decoderIn(SpValue& v)
{
    SpValue r = v.eval();
    if(!r.isReader()){
        throw SpException("not reader (Japanese.decoderIn)");
    }
    Reader* reader = r.asReader();
    ReadEncoder* encoder = new JapaneseReadDecoder(reader);
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

// init
void initJapaneseFile()
{
    SpValue SymJapanese(new SpSymbol("japanese"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSJapanese(ns);
    PMainNameSpace->internConst(SymJapanese, NSJapanese);

    SpValue PrimOpenIn(new SpPrim1(&japanese_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);
    SpValue PrimDecoderIn(new SpPrim1(&japanese_decoderIn));
    ns->internConst(SymDecoderIn, PrimDecoderIn);
}

