/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Mutex.cpp,v 1.3 2004/03/29 10:38:20 randy Exp $
 */

#include "soopy.h"

//
// Soopy Mutex Class
//

#ifdef THREAD

//
// instance primitives
//
SpValue& SpMutex::prim_synchronize(SpValue& self, SpValue& func)
{
  SpValue result;
  SpValue taker;
  SpFunc* f;
  if(func.isNameSpace()){
    SpNameSpace* ns = func.asNameSpace();
    f = SpUsrFunc::fromNameSpace(ns);
    taker.setObject(f);
  }else if(func.isFunc()){
    f = func.asFunc();
  }else{
    throw SpException("not function (mutex.synchronize)");
  }
  SpMutex* ptr = dynamic_cast<SpMutex*>(self.getObject());
  if(ptr == NULL){
    throw SpException("not mutex (synchronize)");
  }
  ptr->lock();
  try{
    result = (*f)(NilObject);
  }catch(...){
    ptr->unlock();
    throw;
  }
  ptr->unlock();

  return SpValueResult(result);
}

SpValue& SpMutex::toString()
{
    SpString* str;
    char buf[32];

    sprintf(buf, "%X", mutex);
    str = new SpString();
    *str = "<mutex: ";
    *str += buf;
    *str += ">";
    return SpObjectResult(str);
}

//
// primitives (Mutex)
//
SpValue& SpMutex::prim_new()
{
  SpValue result;
  SpMutex* mutex = new SpMutex();
  result.setNewObject(mutex);
  return SpValueResult(result);
}

//
// onMessage
//
MsgHandler MutexMsgHandler;

SpValue& SpMutex::onMessage(SpValue& rec, SpValue& msg)
{
  return MutexMsgHandler(rec, msg);
}

//
// init
//
//SpNameSpace* PMutexNameSpace;
//SpValue      MutexNS;

void SpMutex::init()
{
/*
  // set namespace to symbol 'mutex'.
  PMutexNameSpace = new SpNameSpace();
  MutexNS.setNewObject(PMutexNameSpace);
  SpValue SymMutex(new SpSymbol("mutex"));
  PMainNameSpace->internConst(SymMutex, MutexNS);

  SpValue SymNew(new SpSymbol("new"));
  SpValue PrimNew(new SpPrim0(prim_new));
  PMutexNameSpace->internFunc(SymNew, PrimNew);
 */
  SpValue SymMakeMutex(new SpSymbol("make_mutex"));
  SpValue PrimMakeMutex(new SpPrim0(prim_new));
  PMainNameSpace->internFunc(SymMakeMutex, PrimMakeMutex);

  // init instance method
  SpValue SymSynchronize(new SpSymbol("synchronize"));
  SpValue PrimSynchronize(new SpPrim2(prim_synchronize));
  MutexMsgHandler.append(SymSynchronize, PrimSynchronize);
}

#endif /* THREAD */
