/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Check.cpp,v 1.5 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpCheckBox
 */

void __fastcall TSpCheckBox::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    if(!creating){
        SpValue onClick  = ns->lookup(SymOnClick);
        if(onClick.isFunc()){
            SpFunc* f = onClick.asFunc();
            (*f)(NilObject);
        }
    }
}


/*
 * class SpCheckBox
 */

SpValue& SpCheckBox::make()
{
    SpCheckBox* box = new SpCheckBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(box);
//    return result;
  return SpObjectResult(box);
}

// Caption
SpValue& SpCheckBox::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TCheckBox*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TCheckBox*)w)->Caption).c_str()));
}

void SpCheckBox::setCaption(TWidgetControl* w, const char* str)
{
    ((TCheckBox*)w)->Caption = str;
}

SpValue& SpCheckBox::primGetCheck()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setBool(((TCheckBox*)comp->widget)->Checked);
//    return result;
    SpValue result;
    result.setBool(((TCheckBox*)comp->widget)->Checked);
    return SpValueResult(result);
}

SpValue& SpCheckBox::primSetCheck(SpValue& v)
{
    if(v.isBool()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TCheckBox*)comp->widget)->Checked = v.getBool();
    }
    return TrueObject;
}


// creation
void SpCheckBox::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpCheckBox(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    // set checked
    SpValue vchecked  = assoc->lookup(SymCheckedP);
    if(vchecked.isTrue()){
        ((TCheckBox*)widget)->Checked = true;
    }
    ((TSpCheckBox*)widget)->creating = false;

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc);
}

// init
static SpValue GetCheck;
static SpValue SetCheck;

void SpCheckBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);

    // Checked
    pNS->internPrimProperty(SymCheckedP, NilObject, GetCheck, SetCheck);
}

void SpCheckBox::init()
{
    // set namespace to symbol 'std_checkbox'.
    PCheckBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    CheckBoxNS.setNewObject(PCheckBoxNameSpace);
    SpValue SymStdCheckBox(new SpSymbol("std_checkbox"));
    PMainNameSpace->internConst(SymStdCheckBox, CheckBoxNS);

    GetCheck.setNewObject(new SpPrim0(primGetCheck));
    SetCheck.setNewObject(new SpPrim1(primSetCheck));

    SpValue PrimMake(new SpPrim0(make));
    PCheckBoxNameSpace->internFunc(SymMake, PrimMake);
}

