/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Label.cpp,v 1.8 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpLabel
 */


void __fastcall TSpLabel::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    //SpNameSpace* assoc = ns.asNameSpace();
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpLabel::DblClick(void)
{
    TWinControl::DblClick();        // nȟĂяoȂǕWIȏs
    SpValue onDblClick  = ns->lookup(SymOnDblClick);
    if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpLabel
 */

SpValue& SpLabel::make()
{
    SpLabel* label = new SpLabel(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(label);
//    return result;
  return SpObjectResult(label);
}

// Caption
SpValue& SpLabel::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TLabel*)w)->Caption).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TLabel*)w)->Caption).c_str()));
}

//void SpLabel::initCaption(TWidgetControl* w, const char* str)
void SpLabel::setCaption(TWidgetControl* w, const char* str)
{
    ((TLabel*)w)->Caption = str;
}

void SpLabel::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpLabel(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties
}

void SpLabel::init()
{
    // set namespace to symbol 'std_window'.
    PLabelNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    LabelNS.setNewObject(PLabelNameSpace);
    SpValue SymStdLabel(new SpSymbol("std_label"));
    PMainNameSpace->internConst(SymStdLabel, LabelNS);

    SpValue PrimMake(new SpPrim0(make));
    PLabelNameSpace->internFunc(SymMake, PrimMake);
}

