/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: TableView.cpp,v 1.8 2004/05/16 05:20:25 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

static SpValue GetRow;
static SpValue SetRow;
static SpValue GetCol;
static SpValue SetCol;
static SpValue GetTable;

/*
 * class TSpTableView
 */


void __fastcall TSpTableView::Click(void)
{
    TStringGrid::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpTableView::DblClick(void)
{
    TStringGrid::DblClick();        // nȟĂяoȂǕWIȏs
    SpValue onDblClick  = ns->lookup(SymOnDblClick);
    if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpTableView
 */

SpValue& SpTableView::make()
{
  return SpObjectResult(new SpTableView(getCurrentNS()));
}

// Caption
SpValue& SpTableView::getCaption(TWidgetControl* w)
{
    throw SpCaptionException("can't get tableview.caption");
}

void SpTableView::setCaption(TWidgetControl* w, const char* str)
{
    throw SpCaptionException("can't set tableview.caption");
}

void SpTableView::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpTableView(parent, assoc);

    // set cols & rows
    SpValue vcols  = assoc->lookup(SymCols);
    SpValue vrows  = assoc->lookup(SymRows);
    SpValue header = assoc->lookup(SymHeader);
    if(!header.isList()){
        header = NilObject;
        ((TSpTableView*)widget)->hasHeader = false;
        ((TSpTableView*)widget)->FixedRows = 0;
    }else{
        ((TSpTableView*)widget)->hasHeader = true;
    }
    SpInt cols     = vcols.asInt();
    SpInt rows     = vrows.asInt();
    ((TSpTableView*)widget)->ColCount = cols;
    if(((TSpTableView*)widget)->hasHeader){
        ((TSpTableView*)widget)->RowCount = rows + 1;
    }else{
        ((TSpTableView*)widget)->RowCount = rows;
    }
    if(header.isList()){
        SpValue v = header;
        SpList* list;
        for(int i=0; (i < cols) && !v.isNil(); v = list->nextList(), i++){
            list = v.asList();
            ((TSpTableView*)widget)->Cells[i][0] = AnsiString(list->value().toString().toCString());
        }
    }

    // Table
    assoc->internPrimProperty(SymTable, NilObject, GetTable, NilObject);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);


    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpTableView::primGetRow()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TSpTableView* tview = (TSpTableView*)comp->widget;

    SpValue result;
    if(tview->hasHeader){
      result.setInt(tview->Row - 1);
    }else{
      result.setInt(tview->Row);
    }
    return SpValueResult(result);
}

SpValue& SpTableView::primSetRow(SpValue& value)
{
    if(!value.isInt()){
        throw SpException("not int(tableview.row)");
    }
    SpInt i = value.asInt();
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TSpTableView* tview = (TSpTableView*)comp->widget;
    if(tview->hasHeader){
      tview->Row = i + 1;
    }else{
      tview->Row = i;
    }

    return TrueObject;
}

SpValue& SpTableView::primGetCol()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TSpTableView* tview = (TSpTableView*)comp->widget;

    SpValue result;
    result.setInt(tview->Col);
    return SpValueResult(result);
}

SpValue& SpTableView::primSetCol(SpValue& value)
{
    if(!value.isInt()){
        throw SpException("not int(tableview.row)");
    }
    SpInt i = value.asInt();
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TSpTableView* tview = (TSpTableView*)comp->widget;
    tview->Col = i;

    return TrueObject;
}

SpValue& SpTableView::primGetTable()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    TSpTableView* tview = (TSpTableView*)comp->widget;

  return SpObjectResult(new TableOfTableView(tview));
}

// init

void SpTableView::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);

    // Row
    pNS->internPrimProperty(SymRow, NilObject, GetRow, SetRow);
    // Column
    pNS->internPrimProperty(SymCol, NilObject, GetCol, SetCol);
/*
    // Table
    pNS->internPrimProperty(SymTable, NilObject, GetTable, NilObject);
*/
}

void SpTableView::init()
{
    // set namespace to symbol 'std_tableview'.
    PTableViewNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    TableViewNS.setNewObject(PTableViewNameSpace);
    SpValue SymStdTableView(new SpSymbol("std_tableview"));
    PMainNameSpace->internConst(SymStdTableView, TableViewNS);

    // set default top, left, width, height
    SpValue I;
    I.setInt(80);
    PListBoxNameSpace->internConst(SymWidth, I);
    I.setInt(97);
    PListBoxNameSpace->internConst(SymHeight, I);

    GetRow.setNewObject(new SpPrim0(primGetRow));
    SetRow.setNewObject(new SpPrim1(primSetRow));
    GetCol.setNewObject(new SpPrim0(primGetCol));
    SetCol.setNewObject(new SpPrim1(primSetCol));
    GetTable.setNewObject(new SpPrim0(primGetTable));

    SpValue PrimMake(new SpPrim0(make));
    PTableViewNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * class TableOfTableView
 */

SpValue& TableOfTableView::toString()
{
  return SpObjectResult(new SpString("<table of tableview>"));
}

SpValue& TableOfTableView::operator[](SpValue& tuple)
{
    if(!tuple.isTuple()){
        throw SpException("few arguments (access table)");
    }
    SpTuple* t = dynamic_cast<SpTuple*>(tuple.getObject());
    if(t->length() != 2){
        throw SpException("too much arguments (access table)");
    }
    SpValueVector::iterator tit;
    tit = t->begin();
    SpValue i = tit->eval();
    if(!i.isInt()){
        throw SpException("not int (access table)");
    }
    tit++;
    SpValue j = tit->eval();
    if(!j.isInt()){
        throw SpException("not int (access table)");
    }
    int col = i.getInt();
    int row;
    if(view->hasHeader){
        row = j.getInt() + 1;
    }else{
        row = j.getInt();
    }

  return SpObjectResult(new SpString(((AnsiString)view->Cells[col][row]).c_str()));
}

void TableOfTableView::set(SpValue& tuple, SpValue& value)
{
    if(!tuple.isTuple()){
        throw SpException("few arguments (access table)");
    }
    SpTuple* t = dynamic_cast<SpTuple*>(tuple.getObject());
    if(t->length() != 2){
        throw SpException("too much arguments (access table)");
    }
    SpValueVector::iterator tit;
    tit = t->begin();
    SpValue i = tit->eval();
    if(!i.isInt()){
        throw SpException("not int (access table)");
    }
    tit++;
    SpValue j = tit->eval();
    if(!j.isInt()){
        throw SpException("not int (access table)");
    }
    int col = i.getInt();
    int row;
    if(view->hasHeader){
        row = j.getInt() + 1;
    }else{
        row = j.getInt();
    }
    view->Cells[col][row] = AnsiString(value.toString().toCString());
}

SpValue& TableOfTableView::onMessage(SpValue& rec, SpValue& msg)
{
//    if(TableMsgHandler.hasMessage(msg)){
//        return TableMsgHandler(rec, msg);
//    }
    SpValue val = msg.eval();
    if(val.isTuple()){
        return operator[](val);
    }

    // Error
    static char buf[256];
    strncpy(buf, rec.toCStringWithEncoder(), 255);
    buf[255] = '\0';
    static char buf2[256];
    strncpy(buf2, msg.toCStringWithEncoder(), 255);
    buf2[255] = '\0';
    throw SpNoMethodException("no such a feature", buf, buf2);
}

