#/usr/local/bin/soopyg

SimpleEdit = {
  comment:  "Simple editor in Soopy2";
  author:   "randy";
  date:     "$Date: 2004/02/14 12:10:52 $";
  revision: "$Revision: 1.1 $";

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun main(){
    var: [panel1, edit1, win, msgbox];
    do: [
          panel1 = std_panel + {
            align: alTop;
            height: 30;
            components: [
              button1 = std_button + {
                         left: 10;
                         top:  5;
                         caption: "Load";
                         fun onClick(){
                           var: [dialog];
                           do: [
                             if(edit1 modified?){
                                true: [
                                        msgbox = OkCancelDialog + {
                                          caption: "Caution!";
                                          message: "file is changed! really clear?";
                                        };
                                        msgbox make();
                                        if(msgbox canceled?){
                                          true: [
                                            onClick.exit;
                                          ];
                                        };
                                      ];
                             };
                             dialog = std_openDialog make();
                             if(dialog Canceled?){
                               false: [
                                 win caption = "Simple Edit -- " + (dialog filename);
                                 field1 text = dialog filename;
                                 edit1 clear();
                                 with_openIn_file (dialog filename) {
                                   arg: [fin];
                                   var: [line];
                                   do: [
                                     loop {
                                       from: [line = fin readLine];
                                       step: [line = fin readLine];
                                       until: fin eof?;
                                       do: [
                                         edit1 append line;
                                       ];
                                     };
                                   ];
                                 };
                               ];
                             };
                           ];
                         };
                       };

              button2 = std_button + {
                         left: 70;
                         top:  5;
                         caption: "Save";
                         fun onClick(){
                           var: [dialog];
                           do: [
                             dialog = std_saveDialog make();
                             if(dialog Canceled?){
                               false: [
                                 win caption = "Simple Edit -- " + (dialog filename);
                                 field1 text = dialog filename;
                                 with_openOut_file (dialog filename) {
                                   arg: [fout];
                                   var: [lines];
                                   do: [
                                     lines = edit1 text;
                                     fout writeLine lines;
                                   ];
                                 };
                                 edit1 modified? = false;
                               ];
                             };
                           ];
                         };
                       };
              label1 = std_label + {
                        left: 130;
                        top:  10;
                        caption: "Filename:";
                      };
              field1 = std_field + {
                        left: 180;
                        top:  5;
                        width: 200;
                        text: "<Unknown>";
                      };
            ]; /* components */
          };

          edit1 = std_edit + {
            align: alClient;
          };

          win = std_window + {
            caption: "Simple Edit";
            left:     0;
            top:      0;
            width:  400;
            height: 400;

            components: [
              panel1 = panel1;
              edit1 =  edit1;
            ];
          };

          win run();
     ];
  };
};

SimpleEdit main();

