/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: soopyg.h,v 1.32 2004/05/16 01:31:37 randy Exp $
 */

#ifdef LINUX
#include <QGrids.hpp>
#else
#include <qgrids.hpp>
#endif

#ifdef __linux__
#include "../soopy.h"
#else
#include "..\soopy.h"
#endif

class SpCaptionException : public SpException {
public:
    SpCaptionException(const char* s)
        : SpException(s) {}
};

/***********************************/
/*          Base Component         */
/***********************************/

/*
 * class TSpComponent
 */
/*
class TSpComponent : public TWidgetControl {
};
*/

/*
 * class SpComponent
 */

class SpComponent : public SpObject {
protected:
    //TWidgetControl* widget;
    TComponent* widget;
    SpValue ns;       // NameSpace
    SpValue parentNameSpace;   // NameSpace

    virtual SpValue& getCaption(TWidgetControl* w) = 0;
    virtual void setCaption(TWidgetControl* w, const char* str) = 0;

    static SpValue& primGetCaption();
    static SpValue& primSetCaption(SpValue& v);
    static SpValue& primGetParent();
    static SpValue& primGetTop();
    static SpValue& primSetTop(SpValue& v);
    static SpValue& primGetLeft();
    static SpValue& primSetLeft(SpValue& v);
    static SpValue& primGetWidth();
    static SpValue& primSetWidth(SpValue& v);
    static SpValue& primGetHeight();
    static SpValue& primSetHeight(SpValue& v);
    static SpValue& primGetAlign();
    static SpValue& primSetAlign(SpValue& v);
public:
    SpComponent(SpValue& n, TWidgetControl* w=NULL) : ns(n), widget(w) {}
    SpValue& toString();
    const char* typeString(){ return "component"; }
    bool isComponent(){ return true; }

    virtual void creation(SpValue& parentNS, TWidgetControl* parent) = 0;
    void after_creation(SpNameSpace* ns, SpValue& parentNS, TWidgetControl* parent, TWidgetControl* child);
    //void after_creation(SpNameSpace* ns, SpValue& parentNS, TWidgetControl* parent, TComponent* child);

    static void init();
    virtual void initProperties(SpNameSpace* ns);

    friend class SpEdit;
    friend class SpMemo;
    friend class SpCheckBox;
    friend class SpSaveDialog;
    friend class SpOpenDialog;
    friend class SpComboBox;
    friend class SpListBox;
    friend class SpRadioGroup;
    friend class SpTableView;
};

/***********************************/
/*          Container Base        */
/***********************************/

class SpContainer : public SpComponent {
protected:
    void create_components(TWidgetControl* parent_control,
                           SpValue& parent_NS,
                           SpValue& vcomps);
public:
    SpContainer(SpValue& n) : SpComponent(n) {}
};

/***********************************/
/*            Label                */
/***********************************/

/*
 * class TSpLabel
 */

class TSpLabel : public TLabel {
private:
//    SpValue ns;  // NameSpace
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall DblClick(void);
public:
    TSpLabel(TWidgetControl* parent, SpNameSpace* n) : TLabel(parent), ns(n) {}
};

/*
 * class SpLabel
 */

class SpLabel : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);
public:
    SpLabel(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "label"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    friend class TSpLabel;
};

/***********************************/
/*            Button               */
/***********************************/

/*
 * class TSpButton
 */

class TSpButton : public TButton {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall DblClick(void);
public:
    TSpButton(TWidgetControl* parent, SpNameSpace* n) : TButton(parent), ns(n) {}
};

/*
 * class SpButton
 */

class SpButton : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);
public:
    SpButton(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "button"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    friend class TSpButton;
};

/***********************************/
/*          CheckBox               */
/***********************************/

/*
 * class TSpCheckBox
 */

class TSpCheckBox : public TCheckBox {
private:
    SpNameSpace* ns;
    bool creating;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
public:
    TSpCheckBox(TWidgetControl* parent, SpNameSpace* n) : TCheckBox(parent), ns(n)
    {
        creating = true;
    }

    friend class SpCheckBox;
};

/*
 * class SpCheckBox
 */

class SpCheckBox : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetCheck();
    static SpValue& primSetCheck(SpValue& v);
public:
    SpCheckBox(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "checkbox"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpCheckBox;
};

/***********************************/
/*            Edit                 */
/***********************************/

/*
 * class TSpEdit
 */

class TSpEdit : public TEdit {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall DblClick(void);
    void __fastcall Change(void);
public:
    TSpEdit(TWidgetControl* parent, SpNameSpace* n) : TEdit(parent), ns(n) {}
};

/*
 * class SpEdit
 */

class SpEdit : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetText();
    static SpValue& primSetText(SpValue& v);
public:
    SpEdit(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "field"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpEdit;
};

/***********************************/
/*             Memo                */
/***********************************/

/*
 * class TSpMemo
 */

class TSpMemo : public TMemo {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    void __fastcall Change(void);
public:
    TSpMemo(TWidgetControl* parent, SpNameSpace* n) : TMemo(parent), ns(n)
    {
        WantTabs = true;
    }
};

/*
 * class SpMemo
 */

class SpMemo : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetText();
    static SpValue& primSetText(SpValue& v);
    static SpValue& primGetModified();
    static SpValue& primSetModified(SpValue& v);
    static SpValue& primAppend(SpValue& v);
    static SpValue& primClear();
public:
    SpMemo(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "edit"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpMemo;
};

/***********************************/
/*            ComboBox             */
/***********************************/

/*
 * class TSpComboBox
 */

class TSpComboBox : public TComboBox {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall Change(void);
public:
    TSpComboBox(TWidgetControl* parent, SpNameSpace* n) : TComboBox(parent), ns(n) {}
};

/*
 * class SpComboBox
 */

class SpComboBox : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetText();
    static SpValue& primSetText(SpValue& v);
public:
    SpComboBox(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "combobox"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpComboBox;
};

/***********************************/
/*            ListBox              */
/***********************************/

/*
 * class TSpListBox
 */

class TSpListBox : public TListBox {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    void __fastcall Changed(void);
public:
    TSpListBox(TWidgetControl* parent, SpNameSpace* n) : TListBox(parent), ns(n) {}
};

/*
 * class SpListBox
 */

class SpListBox : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetText();
//    static SpValue& primSetText(SpValue& v);
public:
    SpListBox(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "listbox"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpListBox;
};

/***********************************/
/*          TableView              */
/***********************************/

/*
 * class TSpTableView
 */

class TSpTableView : public TStringGrid {
private:
    SpNameSpace* ns;
    bool hasHeader;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
    DYNAMIC void __fastcall DblClick(void);
public:
    TSpTableView(TWidgetControl* parent, SpNameSpace* n) : TStringGrid(parent), ns(n)
    {
      FixedCols = 0;
      hasHeader = false;
    }

    friend class SpTableView;
    friend class TableOfTableView;
};

/*
 * class SpTableView
 */

class SpTableView : public SpComponent {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);
    static SpValue& primGetRow();
    static SpValue& primSetRow(SpValue& value);
    static SpValue& primGetCol();
    static SpValue& primSetCol(SpValue& value);
    static SpValue& primGetTable();

public:
    SpTableView(SpValue& n) : SpComponent(n) {}
    const char* typeString(){ return "tableview"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);

    friend class TSpTableView;
};

class TableOfTableView : public SpArray {
  private:
    TSpTableView* view;

  public:
    TableOfTableView(TSpTableView* v){
        view = v;
        depth = 2;
    }

    SpValue& toString();
    const char* typeString(){ return "table"; }
    SpValue& getFeatureType(){ return NilObject; }
    SpValue& operator[](SpValue& tuple);
    void set(SpValue& tuple, SpValue& value);
    SpValue& onMessage(SpValue& rec, SpValue& msg);
};

/***********************************/
/*            Panel                */
/***********************************/

/*
 * class TSpPanel
 */

class TSpPanel : public TPanel {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
public:
    TSpPanel(TWidgetControl* parent, SpNameSpace* n) : TPanel(parent), ns(n) {}
};


/*
 * class SpPanel
 */

class SpPanel : public SpContainer {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);
public:
    SpPanel(SpValue& n) : SpContainer(n) {}
    const char* typeString(){ return "panel"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    friend class TSpPanel;
};

/***********************************/
/*          RadioGroup             */
/***********************************/

/*
 * class TSpRadioGroup
 */

class TSpRadioGroup : public TRadioGroup {
private:
    SpNameSpace* ns;

    // override event handlers
    DYNAMIC void __fastcall Click(void);
public:
    TSpRadioGroup(TWidgetControl* parent, SpNameSpace* n) : TRadioGroup(parent), ns(n) {}
};


/*
 * class SpRadioGroup
 */

class SpRadioGroup : public SpContainer {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetIndex();
    static SpValue& primSetIndex(SpValue& i);
    static SpValue& primGetText();

    void initProperties(SpNameSpace* pNS);
public:
    SpRadioGroup(SpValue& n) : SpContainer(n) {}
    const char* typeString(){ return "radiogroup"; }

    static void init();
    void creation(SpValue& parentNS, TWidgetControl* parent);
    // primitives
    static SpValue& make();

    friend class TSpRadioGroup;
};

/***********************************/
/*           Window                */
/***********************************/

/*
 * class SpWindow
 */

class SpWindow : public SpContainer {
private:
    static bool app_running;

    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);
public:
    SpWindow(SpValue& n) : SpContainer(n) {}
    const char* typeString(){ return "window"; }
    void run();
    void creation(SpValue& parentNS, TWidgetControl* parent);

    static void init();
    // primitives
    static SpValue& create_and_run();
    static SpValue& make();
};

/***********************************/
/*           SaveDialog            */
/***********************************/

/*
 * class SpSaveDialog
 */

class SpSaveDialog : public SpContainer {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetFilename();
//    static SpValue& primGetFilenames();
public:
    SpSaveDialog(SpValue& n) : SpContainer(n) {}
    const char* typeString(){ return "save_dialog"; }
    void run();
    void creation(SpValue& parentNS, TWidgetControl* parent);

    static void init();
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);
};

/***********************************/
/*           OpenDialog            */
/***********************************/

/*
 * class SpOpenDialog
 */

class SpOpenDialog : public SpContainer {
private:
    SpValue& getCaption(TWidgetControl* w);
    void setCaption(TWidgetControl* w, const char* str);

    static SpValue& primGetFilename();
//    static SpValue& primGetFilenames();
public:
    SpOpenDialog(SpValue& n) : SpContainer(n) {}
    const char* typeString(){ return "open_dialog"; }
    void run();
    void creation(SpValue& parentNS, TWidgetControl* parent);

    static void init();
    // primitives
    static SpValue& make();

    void initProperties(SpNameSpace* pNS);
};

/***********************************/
/*             OkDialog            */
/***********************************/

/*
 * class SpOkDialog
 */

class SpOkDialog : public SpObject {
public:
    static void init();
    static SpValue& make();
};

/***********************************/
/*          OkCancelDialog         */
/***********************************/

/*
 * class SpOkCancelDialog
 */

class SpOkCancelDialog : public SpObject {
public:
    static void init();
    static SpValue& make();
};

/***********************************/
/*            YesNoDialog          */
/***********************************/

/*
 * class SpYesNoDialog
 */

class SpYesNoDialog : public SpObject {
public:
    static void init();
    static SpValue& make();
};

extern SpNameSpace* PComponentNameSpace;
extern SpValue ComponentNS;
extern SpNameSpace* PLabelNameSpace;
extern SpValue LabelNS;
extern SpNameSpace* PWindowNameSpace;
extern SpValue WindowNS;
extern SpNameSpace* PPanelNameSpace;
extern SpValue PanelNS;
extern SpNameSpace* PButtonNameSpace;
extern SpValue ButtonNS;
extern SpNameSpace* PEditNameSpace;
extern SpValue EditNS;
extern SpNameSpace* PMemoNameSpace;
extern SpValue MemoNS;
extern SpNameSpace* PCheckBoxNameSpace;
extern SpValue CheckBoxNS;
extern SpNameSpace* PSaveDialogNameSpace;
extern SpValue SaveDialogNS;
extern SpNameSpace* POpenDialogNameSpace;
extern SpValue OpenDialogNS;
extern SpNameSpace* PComboBoxNameSpace;
extern SpValue ComboBoxNS;
extern SpNameSpace* PListBoxNameSpace;
extern SpValue ListBoxNS;
extern SpNameSpace* PRadioGroupNameSpace;
extern SpValue RadioGroupNS;
extern SpNameSpace* PRadioButtonNameSpace;
extern SpValue RadioButtonNS;
extern SpNameSpace* PTableViewNameSpace;
extern SpValue TableViewNS;

extern SpValue DefaultTop;
extern SpValue DefaultLeft;
extern SpValue DefaultWidth;
extern SpValue DefaultHeight;

extern SpValue AlNone;
extern SpValue AlTop;
extern SpValue AlBottom;
extern SpValue AlLeft;
extern SpValue AlRight;
extern SpValue AlClient;

extern SpValue SymTop;
extern SpValue SymLeft;
extern SpValue SymWidth;
extern SpValue SymHeight;
extern SpValue SymComponents;
extern SpValue SymTitle;
extern SpValue SymCaption;
extern SpValue SymMake;
extern SpValue SymOnClick;
extern SpValue SymOnDblClick;
extern SpValue SymOnChange;
extern SpValue SymParent;
extern SpValue SymAlign;
extern SpValue SymText;
extern SpValue SymAppend;
extern SpValue SymClear;
extern SpValue SymCheckedP;
extern SpValue SymCanceledP;
extern SpValue SymFilename;
extern SpValue SymFilenames;
extern SpValue SymItems;
extern SpValue SymModifiedP;
extern SpValue SymMessage;
extern SpValue SymIndex;
extern SpValue SymCols;
extern SpValue SymRows;
extern SpValue SymCol;
extern SpValue SymRow;
extern SpValue SymTable;
extern SpValue SymHeader;
extern SpValue SymOnCreate;

