/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Dialog.mm,v 1.2 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

SpNameSpace* POkDialogNameSpace;
SpValue OkDialogNS;
SpNameSpace* POkCancelDialogNameSpace;
SpValue OkCancelDialogNS;
SpNameSpace* PYesNoDialogNameSpace;
SpValue YesNoDialogNS;

/*
 * OkCancelDialog
 */

// creation
SpValue& SpOkDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCString(), 255);
    strncpy(caption, vcaption.toCString(), 255);
    message[255] = '\0';
    caption[255] = '\0';

    // Display modal dialog
    int i  = NSRunAlertPanel(
                [NSString stringWithCString:caption], 
                [NSString stringWithCString:message], 
                @"OK", 
                nil, 
                nil);
/*
    if(i == NSAlertDefaultReturn) {
        // OK button was pushed
    }
    else if(i == NSAlertAlternateReturn) {
        // Cancel button was pushed
    }
    else if(i == NSAlertOtherReturn) {
        // Huh? button was pushed
    }
*/
    assoc->internVar(SymCanceledP, FalseObject);

//    static SpValue result;
//    result = ns;
//    return result;
    return SpValueResult(ns);
}

// init
void SpOkDialog::init()
{
    // set namespace to symbol 'OkDialog'.
    POkDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OkDialogNS.setNewObject(POkDialogNameSpace);
    SpValue SymOkDialog(new SpSymbol("okdialog"));
    PMainNameSpace->internConst(SymOkDialog, OkDialogNS);

    SpValue StrWarning(new SpString("warning"));
    SpValue StrOK(new SpString("ok?"));
    POkDialogNameSpace->internVar(SymCaption, StrWarning);
    POkDialogNameSpace->internVar(SymMessage, StrOK);

    SpValue PrimMake(new SpPrim0(make));
    POkDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * OkCancelDialog
 */

// creation
SpValue& SpOkCancelDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCString(), 255);
    strncpy(caption, vcaption.toCString(), 255);
    message[255] = '\0';
    caption[255] = '\0';

    // Display modal dialog
    int i = NSRunAlertPanel(
                [NSString stringWithCString:caption], 
                [NSString stringWithCString:message], 
                @"OK", 
                @"Cancel", 
                nil);
    if(i == NSAlertDefaultReturn) {
        // OK button was pushed
        assoc->internVar(SymCanceledP, FalseObject);
    }else{
        assoc->internVar(SymCanceledP, TrueObject);
    }

//    static SpValue result;
//    result = ns;
//    return result;
    return SpValueResult(ns);
}

// init
void SpOkCancelDialog::init()
{
    // set namespace to symbol 'OkCancelDialog'.
    POkCancelDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OkCancelDialogNS.setNewObject(POkCancelDialogNameSpace);
    SpValue SymOkCancelDialog(new SpSymbol("okcanceldialog"));
    PMainNameSpace->internConst(SymOkCancelDialog, OkCancelDialogNS);

    SpValue StrSelect(new SpString("select"));
    SpValue StrOkCancel(new SpString("ok? or cancel?"));
    POkCancelDialogNameSpace->internVar(SymCaption, StrSelect);
    POkCancelDialogNameSpace->internVar(SymMessage, StrOkCancel);

    SpValue PrimMake(new SpPrim0(make));
    POkCancelDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * YesNoDialog
 */

// creation
SpValue& SpYesNoDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCString(), 255);
    strncpy(caption, vcaption.toCString(), 255);
    message[255] = '\0';
    caption[255] = '\0';

    // Display modal dialog
    int i = NSRunAlertPanel(
                [NSString stringWithCString:caption], 
                [NSString stringWithCString:message], 
                @"Yes", 
                @"No", 
                nil);
    if(i == NSAlertDefaultReturn) {
        // OK button was pushed
        assoc->internVar(SymCanceledP, FalseObject);
    }else{
        assoc->internVar(SymCanceledP, TrueObject);
    }

//    static SpValue result;
//    result = ns;
//    return result;
    return SpValueResult(ns);
}

// init
void SpYesNoDialog::init()
{
    // set namespace to symbol 'YesNoDialog'.
    PYesNoDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    YesNoDialogNS.setNewObject(PYesNoDialogNameSpace);
    SpValue SymYesNoDialog(new SpSymbol("yesnodialog"));
    PMainNameSpace->internConst(SymYesNoDialog, YesNoDialogNS);

    SpValue StrSelect(new SpString("select"));
    SpValue StrYesNo(new SpString("YES? or NO?"));
    PYesNoDialogNameSpace->internVar(SymCaption, StrSelect);
    PYesNoDialogNameSpace->internVar(SymMessage, StrYesNo);

    SpValue PrimMake(new SpPrim0(make));
    PYesNoDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * init dialogs
 */
void initDialogs()
{
    SpOkDialog::init();
    SpOkCancelDialog::init();
    SpYesNoDialog::init();
}

