/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Edit.mm,v 1.11 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSEdit
 */
@implementation SpNSTextView

-(void)didChangeText
{
  isModified = true;
}

-(bool)modified
{
  return isModified;
}

-(void)setModified:(bool)p
{
  isModified = p;
}

@end

/*
 * class SpNSEdit
 */
@implementation SpNSEdit

//-(id)initWithNameSpace:(SpNameSpace*)assoc parent: parent
-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    NSRect frame = NSMakeRect(left, top, width, height);
    float scrollerWidth = [NSScroller scrollerWidth] + 2;
    rect = NSMakeRect(left, top, width-scrollerWidth, height-scrollerWidth);
    //
    // create TextStorage & LayoutManager & TextContainer
    //
    NSTextStorage* textStorage;
    NSLayoutManager* layoutManager;
    NSTextContainer* textContainer;
    SpNSTextView* textView;
    
    // Create NSTextStorage
    textStorage = [[NSTextStorage alloc] init];
    
    // Create NSLayoutManager
    layoutManager = [[NSLayoutManager alloc] init];
    [textStorage addLayoutManager:layoutManager];
    [layoutManager release];
    
    // Create NSTextContainer
    //textContainer = [[NSTextContainer alloc] initWithContainerSize:NSMakeSize(frame.size.width, 1e7)];
    textContainer = [[NSTextContainer alloc] initWithContainerSize:NSMakeSize(1e7, 1e7)];
    [layoutManager addTextContainer:textContainer];
    [textContainer release];

    // Create NSTextView
    //textView = [[NSTextView alloc] initWithFrame:rect textContainer:textContainer];
    textView = [[SpNSTextView alloc] initWithFrame:rect textContainer:textContainer];
    [textView setMinSize:NSMakeSize(0, frame.size.height)];
    [textView setMaxSize:NSMakeSize(1e7, 1e7)];
    [textView setVerticallyResizable:YES];
    [textView setHorizontallyResizable:YES];
    [textView setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];
    [textView setModified: false];


    // $B%9%/%m!<%k%S%e!<$r:n$k(B
    //    NSScrollView *scrollView = [[NSScrollView alloc] initWithFrame:frame];
    [self initWithFrame:frame];
    [self setBorderType:NSBezelBorder];
    [self setHasVerticalScroller:YES];
    [self setHasHorizontalScroller:YES];
    //    [self setHorizontalLineScroll:20];
    [self setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];

    [self setDocumentView:textView];
    //    [textView setRulerVisible:YES];
    [textView release];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

/*
-(void)click:(NSObject*)sender
{
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}
*/

@end

/*
 * class SpEdit
 */

SpValue& SpEdit::make()
{
    SpEdit* edit = new SpEdit(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(edit);
//    return result;
    return SpObjectResult(edit);
}

// Caption
SpValue& SpEdit::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpEdit::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

void SpEdit::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();

    // Create NSScrollView(SpNSEdit)
    SpNSEdit* edit = [[SpNSEdit alloc] initWithNameSpace:assoc parent:parent comp:this];
    [[parent contentView] addSubview: (NSView*)edit];
    [edit setAutoresizingMask: NSViewMinYMargin];
    widget = (NSObject*)edit;

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpEdit::primClear()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    [(NSTextView*)[(NSScrollView*)comp->widget documentView] setString:@""];
    return TrueObject;
}

SpValue& SpEdit::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString([[(NSTextView*)[(NSScrollView*)comp->widget documentView] string] cString]));
//    return result;
    return SpObjectResult(new SpString([[(NSTextView*)[(NSScrollView*)comp->widget documentView] string] cString]));
}

SpValue& SpEdit::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        [(NSTextView*)[(NSScrollView*)comp->widget documentView] setString:[NSString stringWithCString:v.toCString()]];
    }
    return TrueObject;
}

SpValue& SpEdit::primGetModified()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    //if(((TMemo*)comp->widget)->Modified){
    if([(SpNSTextView*)[(NSScrollView*)comp->widget documentView] modified]){
        return TrueObject;
    }
    return FalseObject;
}

SpValue& SpEdit::primSetModified(SpValue& v)
{
    if(v.isBool()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        if(v.isTrue()){
          //((TMemo*)comp->widget)->Modified = true;
          [(SpNSTextView*)[(SpNSEdit*)comp->widget documentView] setModified: true];
        }else{
          //((TMemo*)comp->widget)->Modified = false;
          [(SpNSTextView*)[(SpNSEdit*)comp->widget documentView] setModified: false];
          return FalseObject;
        }
    }
    return TrueObject;
}

SpValue& SpEdit::primAppend(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        //        ((TMemo*)comp->widget)->Append(v.toCString());
        [(NSTextView*)[(NSScrollView*)comp->widget documentView] insertText:[NSString stringWithCString:v.toCString()]];
    }
    return TrueObject;
}


// init
static SpValue Clear;
static SpValue GetText;
static SpValue SetText;
static SpValue GetModified;
static SpValue SetModified;
static SpValue Append;

void SpEdit::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
    pNS->internPrimProperty(SymModifiedP, NilObject, GetModified, SetModified);
    pNS->internFunc(SymClear, Clear);
    pNS->internFunc(SymAppend, Append);
}

void SpEdit::init()
{
    // set namespace to symbol 'std_edit'.
    PEditNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    EditNS.setNewObject(PEditNameSpace);
    SpValue SymStdEdit(new SpSymbol("std_edit"));
    PMainNameSpace->internConst(SymStdEdit, EditNS);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));
    GetModified.setNewObject(new SpPrim0(primGetModified));
    SetModified.setNewObject(new SpPrim1(primSetModified));
    Append.setNewObject(new SpPrim1(primAppend));
    Clear.setNewObject(new SpPrim0(primClear));

    SpValue PrimMake(new SpPrim0(make));
    PEditNameSpace->internFunc(SymMake, PrimMake);
}

