/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002-2004 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: ListBox.mm,v 1.8 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

@implementation SpNSListBoxDataSource

-(id)initWithCapacity:(unsigned)numItems
{
  ary = [NSMutableArray arrayWithCapacity:numItems];
  for(int i=0; i < numItems; i++){
    [ary addObject:@""];
  }
  return self;
}

-(void)dealloc
{
  if(ary){
    [ary release];
  }
  [super dealloc];
}

-(void)addObject:(id)aObject
{
  [ary addObject:aObject];
}

-(void)replaceObjectAtIndex:index withObject:anObject
{
  [ary replaceObjectAtIndex:index withObject:anObject];
}

-(int)numberOfRowsInTableView:(NSTableView*)aTableView
{
  return [ary count];
}

-(id)tableView:(NSTableView*)aTableView objectValueForTableColumn:(NSTableColumn*)column row:(int)rowIndex
{
  return [ary objectAtIndex:rowIndex];
}

-(void)tableView:(NSTableView*)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn*)column row:(int)rowIndex
{
  //[ary addObject:anObject];
  [ary replaceObjectAtIndex:rowIndex withObject:anObject];
}

-(int)count
{
  return [ary count];
}

-(id)objectAtIndex:(int)index
{
  return [ary objectAtIndex:index];
}

@end

/*
 * class NSTableViewForListBox
 */
@implementation NSTableViewForListBox

-(int)count
{
  return [[self dataSource] count];
}

-(id)objectAtIndex:(int)index
{
  return [[self dataSource] objectAtIndex:index];
}

@end

/*
 * class SpNSListBox
 */
@implementation SpNSListBox

-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    NSRect frame = NSMakeRect(left, top, width, height);
    float scrollerWidth = [NSScroller scrollerWidth] + 2;
    rect = NSMakeRect(left, top, width-scrollerWidth, height-scrollerWidth);


    //
    // create TableView
    //
    //    NSTableViewForListBox* tableView;
    
    // Create NSTableView
    tableView = [[NSTableViewForListBox alloc] initWithFrame:rect];
    [tableView setHeaderView:nil];
    // set items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isList()){
        NSTableColumn* column = [[NSTableColumn alloc] initWithIdentifier:@"list"];
	[tableView addTableColumn:column];
	SpNSListBoxDataSource* source = [[SpNSListBoxDataSource alloc] initWithCapacity:vitems.asList()->length()];
        for(int i=0; !vitems.isNil(); i++){
            SpList* ptr = vitems.asList();
	    NSString* str = [NSString stringWithCString:ptr->value().toCString()];
	    [source replaceObjectAtIndex:i withObject:str];
            vitems = ptr->nextList();
        }
	[tableView setDataSource:source];
	[column release];
    }
    [tableView setTarget: (id)self];
    [tableView setAction:@selector(change:)];

    // $B%9%/%m!<%k%S%e!<$r:n$k(B
    [self initWithFrame:frame];
    [self setBorderType:NSBezelBorder];
    [self setHasVerticalScroller:YES];
    [self setHasHorizontalScroller:NO];
    //    [self setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];

    [self setDocumentView:tableView];
    [tableView release];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)change:(NSObject*)sender
{
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}

-(int)count
{
  return [tableView count];
}

-(int)selectedRow
{
  return [tableView selectedRow];
}

-(id)objectAtIndex:(int)index
{
  return [tableView objectAtIndex:index];
}

@end

/*
 * class SpListBox
 */

SpValue& SpListBox::make()
{
    SpListBox* box = new SpListBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(box);
//    return result;
    return SpObjectResult(box);
}

// Caption
SpValue& SpListBox::getCaption(NSObject* w)
{
    throw SpCaptionException("can't get listbox.caption");
}

void SpListBox::setCaption(NSObject* w, const char* str)
{
    throw SpCaptionException("can't set listbox.caption");
}

void SpListBox::creation(SpValue& parentNS, NSObject* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();

    // Create NSScrollView(SpNSListBox)
    SpNSListBox* listbox = [[SpNSListBox alloc] initWithNameSpace:assoc parent:parent comp:this];
    [[parent contentView] addSubview: (NSView*)listbox];
    [listbox setAutoresizingMask: NSViewMinYMargin];
    widget = (NSObject*)listbox;

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties
}

// primitives
SpValue& SpListBox::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    SpNSListBox* list = (SpNSListBox*)comp->widget;

    if([list selectedRow] < 0){
        return NilObject;
    }
//    static SpValue result;
//    result.setNewObject(new SpString([[list objectAtIndex:[list selectedRow]] cString]));
//    return result;
    return SpObjectResult(new SpString([[list objectAtIndex:[list selectedRow]] cString]));
}

// init
static SpValue GetText;

void SpListBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, NilObject);
}

void SpListBox::init()
{
    // set namespace to symbol 'std_listBox'.
    PListBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ListBoxNS.setNewObject(PListBoxNameSpace);
    SpValue SymStdListBox(new SpSymbol("std_listbox"));
    PMainNameSpace->internConst(SymStdListBox, ListBoxNS);

    // set default top, left, width, height
    DefaultWidth.setInt(80);
    PListBoxNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(97);
    PListBoxNameSpace->internConst(SymHeight, DefaultHeight);

    GetText.setNewObject(new SpPrim0(primGetText));

    SpValue PrimMake(new SpPrim0(make));
    PListBoxNameSpace->internFunc(SymMake, PrimMake);
}

