/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: RadioGroup.mm,v 1.5 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSRadioGroup
 */

@implementation SpNSRadioGroup

-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    [self initWithFrame: NSMakeRect(left, top, width, height)];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)setMatrix:(NSMatrix*)mat
{
  matrix = mat;
  [matrix retain];
}

-(NSMatrix*)getMatrix
{
  return matrix;
}

-(void)dealloc
{
  [matrix release];
  [super dealloc];
}

-(void)click:(NSObject*)sender
{
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

/*
-(void)mouseUp:(NSEvent*)event
{
    if([event clickCount] == 1){
      SpValue onClick  = ns->lookup(SymOnClick);
      if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
      }
    }else if([event clickCount] == 2){ // Double click
      SpValue onDblClick  = ns->lookup(SymOnDblClick);
      if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
      }
    }
}
*/

-(void)setIndex:(int)i
{
  [matrix selectCellAtRow:i columun:0];
}

-(int)getIndex
{
  return [matrix selectedRow];
}

-(NSString*)getText
{
  return [[matrix selectedCell] title];
}

@end

/*
 * class SpRadioGroup
 */

SpValue& SpRadioGroup::make()
{
    SpRadioGroup* group = new SpRadioGroup(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(group);
//    return result;
    return SpObjectResult(group);
}

void SpRadioGroup::resetAlign(NSRect& parent_rect)
{
  SpComponent::resetAlign(parent_rect);
  //  SpContainer::resetAlignAllComponents();
}

// primitives

// Caption
SpValue& SpRadioGroup::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpRadioGroup::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

// Index
SpValue& SpRadioGroup::primGetIndex()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    SpNSRadioGroup* ptr = (SpNSRadioGroup*)comp->widget;
//    static SpValue result;
//    result.setInt([ptr getIndex]);
//    return result;
    SpValue result;
    result.setInt([ptr getIndex]);
    return SpValueResult(result);
}

SpValue& SpRadioGroup::primSetIndex(SpValue& v)
{
    if(!v.isInt()){
        throw SpException("not integer (radiogroup.index)");
    }
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    SpNSRadioGroup* ptr = (SpNSRadioGroup*)comp->widget;
    [ptr setIndex:v.asInt()];
    return v;
}

// Text of selected radio button
SpValue& SpRadioGroup::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
    SpNSRadioGroup* ptr = (SpNSRadioGroup*)comp->widget;
    if([ptr getIndex] < 0){
        return NilObject;
    }
//    static SpValue result;
//    result.setNewObject(new SpString([[ptr getText] cString]));
//    return result;
    return SpObjectResult(new SpString([[ptr getText] cString]));
}

// creation
void SpRadioGroup::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSRadioGroup* panel = [[SpNSRadioGroup alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)panel;
    [[parent contentView] addSubview: (NSView*)panel];
    [panel setAutoresizesSubviews:YES];
    [panel setAutoresizingMask: NSViewMinYMargin];

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    // set title
    SpValue vcaption = assoc->lookup(SymCaption);
    if(vcaption.isString()){
      [panel setTitle: [NSString stringWithCString: vcaption.toCString()]];
    }else{
      [panel setTitle: [NSString stringWithCString: typeString()]];
    }
    [panel setTitlePosition:NSAtTop];

    initProperties(assoc); // SpComponent::initProperties

    // setup items
    SpValue vitems = assoc->lookup(SymItems);
    if(vitems.isCons()){
	NSRect parent_rect = [[panel contentView] frame];
	parent_rect.origin.x = 0;
	parent_rect.origin.y = 0;
	SpCons* list = vitems.asList();
	int len = list->length();
	NSMatrix* mat = [[NSMatrix alloc] initWithFrame:parent_rect
					  mode:NSRadioModeMatrix
					  cellClass:[NSButtonCell class]
					  numberOfRows:len
					  numberOfColumns:1];
	[mat setTarget:widget];
	[mat setAction:@selector(click:)];
        for(int i=0;!vitems.isNil(); i++){
            SpList* ptr = vitems.asList();
            SpValue v = ptr->value();
            if(!v.isString()){
                throw SpException("not string (radiogroup items:)");
            }
            SpString* str = v.asString();
	    NSButtonCell* cell = [[NSButtonCell alloc] init];
	    [cell setButtonType:NSRadioButton];
            [cell setTitle:[NSString stringWithCString:str->toCString()]];
	    [mat putCell:cell atRow:i column:0];
            vitems = ptr->nextList();
        }
	// size to fit
	[mat sizeToFit];
	NSRect rect = [mat frame];
	rect.origin.y = parent_rect.size.height - rect.size.height;
	[mat setFrame:rect];
	[mat setAutoresizingMask: NSViewMinYMargin];

	// add matrix to panel
	[[panel contentView] addSubview:mat];
	[panel setMatrix:mat];

	[mat release];
    }
/*
    // create components
    SpValue vcomps = assoc->lookup(SymComponents);
    create_components((NSObject*)widget, ns, vcomps);
*/
}

// init
static SpValue GetText;
static SpValue GetIndex;
static SpValue SetIndex;

void SpRadioGroup::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, NilObject);
    // Index
    pNS->internPrimProperty(SymIndex, NilObject, GetIndex, SetIndex);
}

void SpRadioGroup::init()
{
    // set namespace to symbol 'std_window'.
    PRadioGroupNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    RadioGroupNS.setNewObject(PRadioGroupNameSpace);
    SpValue SymStdRadioGroup(new SpSymbol("std_radiogroup"));
    PMainNameSpace->internConst(SymStdRadioGroup, RadioGroupNS);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PRadioGroupNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PRadioGroupNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(200);
    PRadioGroupNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(80);
    PRadioGroupNameSpace->internConst(SymHeight, DefaultHeight);

    GetText.setNewObject(new SpPrim0(primGetText));
    GetIndex.setNewObject(new SpPrim0(primGetIndex));
    SetIndex.setNewObject(new SpPrim1(primSetIndex));

    SpValue PrimMake(new SpPrim0(make));
    PRadioGroupNameSpace->internFunc(SymMake, PrimMake);
}

