/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Window.mm,v 1.17 2004/05/10 12:52:12 randy Exp $
 */

#import "soopyg.h"



@implementation WindowCtrl

-(id)window:(NSWindow*)win
{
  window = win;
  [window setDelegate:self];
  [window makeKeyAndOrderFront:self]; // main window
  return self;
}

-(void)dealloc
{
//  [window setDelegate:nil];
  [super dealloc];
}

-(id)mainMenu
{
  id <NSMenuItem> item;
  NSMenu* menu;
  NSMenu* submenu;

  menu = [[NSMenu alloc] initWithTitle: @"SoopyG"];
/*
  item = [menu addItemWithTitle: @"File"
	       action: @selector(submenuAction:) keyEquivalent: @""];
  submenu = [[NSMenu alloc] initWithTitle: @"File"];
  [menu setSubmenu:submenu forItem:item];
  item = [submenu addItemWithTitle:@"Open File..."
		  action:@selector(openFile:) keyEquivalent:@"o"];
  [item setTarget: self];
  item = [submenu addItemWithTitle:@"Inspector..."
		  action:@selector(activateInspector:) keyEquivalent:@"i"];
  [item setTarget:self];
*/
  return [menu autorelease];
}

/* Local Method */
-(void)showTitle:(NSString*)title message:(NSString*)message
{
  id panel = NSGetAlertPanel(title, @"%@", nil, nil,nil, message);
  [panel center];
  [panel makeKeyAndOrderFront:panel];
  [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow: 3]];
  [panel close];
  NSReleaseAlertPanel(panel);
}

/* Delegate Messages */
-(void)applicationDidFinishLaunching:(NSNotification*)aNotification
{
  //  [self showTitle:@"Start" message:@"Wellcome to SoopyG"];
}

-(void)applicationWillTerminate:(NSNotification*)aNotification
{
  //  [self showTitle:@"Exit" message:@"bye"];
}


-(BOOL)windowShouldClose:(id)sender
{
  return YES;
}

-(void)windowWillClose:(NSNotification*)aNotification
{
  [NSApp stop:self];
  [self release];
}

@end

@implementation SpNSWindow

-(id)initWithNameSpace:(SpNameSpace*)assoc rect:(NSRect)rect comp:(SpComponent*)spc;
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    [self initWithContentRect: rect
	  styleMask: (NSTitledWindowMask
		      | NSClosableWindowMask
		      | NSMiniaturizableWindowMask
		      | NSResizableWindowMask)
	  backing: NSBackingStoreBuffered
	  defer: YES];
    [self setReleasedWhenClosed: YES];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)setFrame:(NSRect)rect
{
  [self setFrame:rect display:YES];
}

/*
-(void)close
{
  NSArray* ary = [self childWindows];
  NSEnumerator *enumerator = [ary objectEnumerator];
  NSWindow* child;
	
  while(child = (NSWindow*)[enumerator nextObject]){
    [child close];
  }
  [super close];
}
*/

@end

/*
 * class SpContainer
 */
void SpContainer::create_components(NSObject* parent_control,
                                    SpValue& parent_NS,
                                    SpValue& vcomps)
{
    if(vcomps.isList()){
        SpList* list = vcomps.asList();
        SpNameSpace* assoc = parent_NS.asNameSpace();
        for(; list != NULL; list = list->next()){
            SpValue value = list->value();
            if(!value.isAssign()){
                throw SpException("not assignment (components:)");
            }
            SpAssign* a = value.asAssign();
            SpValue sym = a->place;
            SpValue v = a->val.eval();
            if(!sym.isSymbol()){
                throw SpException("not symbol (components:)");
            }
            SpNameSpace* ns2 = v.asNameSpace();
            SpValue f = ns2->lookup(SymMake);
            if(!f.isFunc()){
                throw SpException("not function (make)");
            }
            SpFunc* func = f.asFunc();
            SpValue aComp = (*func)(NilObject);
            if(!aComp.isComponent()){
                throw SpException("not component (make)");
            }
            SpComponent* aComponent = aComp.asComponent();
            aComponent->creation(parent_NS, parent_control);

            assoc->internConst(sym, v);
            ns2->parentNS = parent_NS;
        }
        resetAlignAllComponents();
    }
/*
    if(vcomps.isNameSpace()){
        SpComponent* aComponent = NULL;
        SpNameSpace* comps = vcomps.asNameSpace();
        SpNameSpace* assoc = parent_NS.asNameSpace();
        NSMap::iterator it = comps->begin();
        for(; it != comps->end(); it++){
            if(it->first.isNSKey()){
                NSKey* key = it->first.asNSKey();
                if(!(key->isNSPrimProperty() || key->isNSProperty() || key->isNSFunc() || key->isNSDataType())){
                    SpValue v = it->second;
                    SpNameSpace* ns2 = v.asNameSpace();
                    SpValue f = ns2->lookup(SymMake);
                    if(!f.isFunc()){
                        throw SpException("not function (make)");
                    }
                    SpFunc* func = f.asFunc();
                    SpValue aComp = (*func)(NilObject);
                    if(!aComp.isComponent()){
                        throw SpException("not component (make)");
                    }
                    aComponent = aComp.asComponent();
                    aComponent->creation(parent_NS, parent_control);

                    assoc->internConst(key->val, v);
                    ns2->parentNS = parent_NS;
                }
            }
        }
        resetAlignAllComponents();
    }
*/
}

void SpContainer::resetAlignAllComponents()
{
  SpComponent::resetAlignAllComponents((NSView*)widget);
}

/*
 * class SpWindow
 */
bool SpWindow::app_running = false;
SpNSWindow* SpWindow::main_window = NULL;

SpValue& SpWindow::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpWindow::setCaption(NSObject* w, const char* str)
{
  [w setTitle: [NSString stringWithCString: str]];
}

void SpWindow::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();

    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [[NSScreen mainScreen] frame];
    float top = rect.size.height - (float)vtop.getInt();
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    rect = NSMakeRect(left, top, width, height);

    SpNSWindow* win = [[SpNSWindow alloc] initWithNameSpace:assoc rect:rect comp:this];
    widget = win;

    // set window title
    SpValue vcaption = assoc->lookup(SymCaption);
    if(vcaption.isString()){
      [win setTitle: [NSString stringWithCString: vcaption.toCString()]];
    }else{
      [win setTitle:@"SoopyG"];
    }

    SpValue vcomps = assoc->lookup(SymComponents);

    //    SpComponent::after_creation(assoc, parentNS, parent, form);

    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties

    // create components
    create_components(win, ns, vcomps);
}

void SpWindow::run()
{
    if(app_running){
        throw SpException("can't run two application");
    }
    app_running = true;

    try{
      id pool = [[NSAutoreleasePool alloc] init];
      id controller = [[WindowCtrl alloc] init];
      // init app
      id app = [NSApplication sharedApplication];
      [app setDelegate: controller];
      [app setMainMenu: [controller mainMenu]];

      // create main window
      creation(NilObject, NULL);
      [controller window: widget];
      main_window = (SpNSWindow*)widget;

      // run app
      [NSApp run];

      // release
      [pool release];
      //      [controller release];
    }catch(...){
      main_window = NULL;
      app_running = false;
      throw;
    }

    main_window = NULL;
    app_running = false;
}

// primitives

SpValue& SpWindow::create_and_run()
{
    SpWindow* win = new SpWindow(getCurrentNS());
    SpValue taker(win);
    win->run();

//    static SpValue result;
//    result = taker;
//    return result;
    return SpValueResult(taker);
}

SpValue& SpWindow::make()
{
    SpWindow* win = new SpWindow(getCurrentNS());
    SpValue taker(win);
    win->creation(getCurrentNS(), NULL);

    id controller = [[WindowCtrl alloc] init];
    [controller window: win->widget];
    //    [controller autorelease];

//    static SpValue result;
//    result = taker;
//    return result;
    return SpValueResult(taker);
}


// init std_window
void SpWindow::init()
{
    // set namespace to symbol 'std_window'.
    PWindowNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    WindowNS.setNewObject(PWindowNameSpace);
    SpValue SymStdWindow(new SpSymbol("std_window"));
    PMainNameSpace->internConst(SymStdWindow, WindowNS);

    // set top, left, width, height
    SpValue temp;
    temp.setInt(10);
    PWindowNameSpace->internConst(SymTop, temp);
    temp.setInt(10);
    PWindowNameSpace->internConst(SymLeft, temp);
    temp.setInt(200);
    PWindowNameSpace->internConst(SymWidth, temp);
    temp.setInt(200);
    PWindowNameSpace->internConst(SymHeight, temp);

    PWindowNameSpace->internConst(SymComponents, NilObject);

    SpValue SymRun(new SpSymbol("run"));
    SpValue PrimRun(new SpPrim0(create_and_run));
    PWindowNameSpace->internFunc(SymRun, PrimRun);

    SpValue PrimMake(new SpPrim0(make));
    PWindowNameSpace->internFunc(SymMake, PrimMake);
}

