/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.util.StringUtils;
import flex.webtier.compiler.ConfigConstants;
import flex.webtier.server.j2ee.filemanager.HistoryFileManager;
import flex.webtier.server.j2ee.html.HistorySettings;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.ServerConfiguration;

public class HistorySettingsFactory
implements ConfigConstants {
    private static HistorySettings hs;

    public static HistorySettings getInstance(String contextRoot) {
        if (hs == null) {
            hs = HistorySettingsFactory.setupDefaultHistorySettings(contextRoot);
        }
        return hs;
    }

    protected static HistorySettings setupDefaultHistorySettings(String contextRoot) {
        HistorySettings defaultHistorySettings = new HistorySettings();
        String historyEndpoint = HistoryFileManager.HISTORY_URI;
        String htmlUri = historyEndpoint + "?action=" + HistoryFileManager.HISTORY_ACTION_HTML;
        htmlUri = StringUtils.substitute((String)htmlUri, (String)"{context.root}", (String)contextRoot);
        defaultHistorySettings.setHtmlUri(htmlUri);
        String htmlSecureUri = historyEndpoint + "?action=" + HistoryFileManager.HISTORY_ACTION_HTML_SECURE;
        htmlSecureUri = StringUtils.substitute((String)htmlSecureUri, (String)"{context.root}", (String)contextRoot);
        defaultHistorySettings.setHtmlSecureUri(htmlSecureUri);
        String jsUri = historyEndpoint + "?action=" + HistoryFileManager.HISTORY_ACTION_JS;
        jsUri = StringUtils.substitute((String)jsUri, (String)"{context.root}", (String)contextRoot);
        defaultHistorySettings.setJsUri(jsUri);
        String swfUri = historyEndpoint + "?action=" + HistoryFileManager.HISTORY_ACTION_SWF;
        swfUri = StringUtils.substitute((String)swfUri, (String)"{context.root}", (String)contextRoot);
        defaultHistorySettings.setSwfUri(swfUri);
        ServerConfiguration configurator = ServiceFactory.getConfigurator().getServerConfiguration();
        defaultHistorySettings.setEnabled(configurator.useHistoryManagement());
        return defaultHistorySettings;
    }
}

