/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.cache;

import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import flex.webtier.server.j2ee.RequestContext;
import flex.webtier.server.j2ee.SWFInfo;
import flex.webtier.server.j2ee.cache.CacheEntryRefreshPolicy;
import flex.webtier.server.j2ee.cache.PageState;
import flex.webtier.server.j2ee.cache.PageStateCache;
import flex.webtier.server.j2ee.cache.ResourceManager;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.CacheConfiguration;
import flex.webtier.services.config.Configurator;
import flex.webtier.services.config.DebuggingConfiguration;
import flex.webtier.services.config.ServerConfiguration;
import flex.webtier.util.J2EEUtil;
import flex.webtier.util.Trace;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class CacheHelper {
    private PageStateCache pages;
    private String dependencyFile;
    private boolean incremental;
    private boolean processRecompile;
    private boolean productionMode;
    private long configurationVersion;
    private static CacheHelper cacheHelper;
    public GeneralCacheAdministrator cache;
    private ResourceManager resourceManager;

    public static CacheHelper getInstance(ServletContext context) {
        if (cacheHelper == null) {
            cacheHelper = new CacheHelper(context);
        }
        return cacheHelper;
    }

    private CacheHelper(ServletContext context) {
        Configurator configurator = ServiceFactory.getConfigurator();
        this.configurationVersion = configurator.getVersion();
        ServerConfiguration defaultConfiguration = configurator.getServerConfiguration();
        this.productionMode = defaultConfiguration.isProductionMode();
        this.incremental = defaultConfiguration.isIncrementalCompile();
        DebuggingConfiguration debuggingConfiguration = defaultConfiguration.getDebuggingConfiguration();
        boolean bl = this.processRecompile = debuggingConfiguration.processDebugQueryParams() && !this.productionMode;
        if (Trace.cache) {
            Trace.trace((String)("[cache] configuration: production mode = " + this.productionMode));
            Trace.trace((String)("[cache] configuration: " + defaultConfiguration.getCacheConfiguration().toString()));
        }
        this.initCache();
        ResourceManager.checkInterval = defaultConfiguration.getCacheConfiguration().getFileWatcherInterval() * 1000;
        this.resourceManager = new ResourceManager();
        this.pages = new PageStateCache(25, 500);
        this.dependencyFile = J2EEUtil.getRealPath((String)"/WEB-INF/flex/cache.dep", (ServletContext)context);
        this.loadDependencies();
    }

    public void stop() {
        this.storeDependencies();
        cacheHelper = null;
        this.cache.flushAll();
        this.cache.destroy();
    }

    public void initCache() {
        Configurator configurator = ServiceFactory.getConfigurator();
        CacheConfiguration cacheConfiguration = configurator.getServerConfiguration().getCacheConfiguration();
        Properties cacheProperties = new Properties();
        cacheProperties.put("cache.capacity", Integer.toString(cacheConfiguration.getContentSize()));
        cacheProperties.put("cache.blocking", "true");
        this.cache = new GeneralCacheAdministrator(cacheProperties);
    }

    public boolean forceRecompile(HttpServletRequest request) {
        String param;
        boolean recompile = false;
        if (this.processRecompile && (param = request.getParameter("recompile")) != null && "true".equals(param.toLowerCase())) {
            recompile = true;
        }
        return recompile;
    }

    public void addToCache(String key, SWFInfo swfInfo, HashMap dependencies) {
        CacheEntryRefreshPolicy policy = new CacheEntryRefreshPolicy();
        policy.init(this, this.cache.getCache(), key, this.incremental);
        this.pages.put(key, new PageState(key, dependencies, swfInfo.getLastModified(), this.resourceManager));
        this.cache.putInCache(key, (Object)swfInfo, (EntryRefreshPolicy)policy);
    }

    public void removeFromCache(String key) {
        if (Trace.cache) {
            Trace.trace((String)("[cache] remove cache entry; key = " + key));
        }
        this.remove(key);
        this.pages.remove(key);
    }

    public void lockCache() {
    }

    public void unlockCache(String key) {
        this.cache.cancelUpdate(key);
    }

    public SWFInfo getFromCache(String key) {
        try {
            SWFInfo swf = (SWFInfo)this.cache.getFromCache(key, -1);
            return swf;
        }
        catch (NeedsRefreshException nre) {
            return null;
        }
    }

    public long getLastModified(String key, HttpServletRequest request) {
        long lastModified = -1L;
        PageState pageState = (PageState)this.pages.get(key);
        if (pageState != null) {
            if (!this.productionMode && !pageState.isUpToDate()) {
                this.pages.remove(key);
            } else {
                lastModified = pageState.getLastModified();
            }
        }
        return lastModified;
    }

    public boolean needsRecompile(String key, long ifModifiedSince) {
        boolean needsRecompile = true;
        PageState pageState = (PageState)this.pages.get(key);
        if (pageState != null) {
            if (!this.productionMode && !pageState.isUpToDate()) {
                this.pages.remove(key);
                needsRecompile = true;
            } else if (pageState.getLastModified() == ifModifiedSince) {
                needsRecompile = false;
            }
        }
        return needsRecompile;
    }

    public static boolean isBrowserUpToDate(HttpServletRequest request, ServletContext context, String cacheKey) {
        String dependencyKey;
        CacheHelper ch;
        boolean uptodate = false;
        long modified = request.getDateHeader("If-Modified-Since");
        if (Trace.cache) {
            Trace.trace((String)("[cache] Checking cache key " + cacheKey));
        }
        if (!(ch = CacheHelper.getInstance(context)).needsRecompile(dependencyKey = new RequestContext(context, request).getDependencyKey(), modified)) {
            uptodate = true;
            if (Trace.cache) {
                Trace.trace((String)("[cache] Browser cache up-to-date, key = " + cacheKey + "; modified = " + modified));
            }
            uptodate = true;
        } else if (Trace.cache) {
            Trace.trace((String)("[cache] Browser cache is out-of-date, key = " + cacheKey + "; modified = " + modified));
        }
        return uptodate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDependencies() {
        ObjectInputStream ois = null;
        ois = new ObjectInputStream(new FileInputStream(this.dependencyFile));
        long lastConfiguration = ois.readLong();
        if (lastConfiguration != this.configurationVersion && Trace.cache) {
            Trace.trace((String)"[cache] invalidating dependencies because configuration changed");
        }
        Map previousLicenses = (Map)ois.readObject();
        Map currentLicenses = ServiceFactory.getLicenseService().getLicenseMap();
        if (previousLicenses.size() != currentLicenses.size() || !((Object)previousLicenses).equals(currentLicenses)) {
            if (Trace.cache) {
                Trace.trace((String)"[cache] invalidating dependencies because license changed");
            }
        } else {
            Map map = (Map)ois.readObject();
            if (Trace.cache) {
                Trace.trace((String)("[cache] load dependencies from " + this.dependencyFile));
                Iterator i = map.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    Trace.trace((String)(key + " = " + map.get(key)));
                }
            }
            Iterator pageIter = map.keySet().iterator();
            while (pageIter.hasNext()) {
                String pageKey = (String)pageIter.next();
                PageState pageState = (PageState)map.get(pageKey);
                pageState.setResourceManager(this.resourceManager);
                if (pageState.isUpToDate()) {
                    this.pages.put(pageKey, pageState);
                    continue;
                }
                if (!Trace.cache) continue;
                Trace.trace((String)("[cache] " + pageKey + " is out of date"));
            }
        }
        Object var11_11 = null;
        if (ois == null) return;
        try {
            ois.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (FileNotFoundException e) {
                ServiceFactory.getLogger().logDebug("[cache] No dependency information found in " + e.getMessage());
                Object var11_12 = null;
                if (ois == null) return;
                try {
                    ois.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                ServiceFactory.getLogger().logInfo("[cache] No existing dependency information.");
                Object var11_13 = null;
                if (ois == null) return;
                try {
                    ois.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeDependencies() {
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(this.dependencyFile));
        oos.writeLong(this.configurationVersion);
        oos.writeObject(ServiceFactory.getLicenseService().getLicenseMap());
        oos.writeObject(this.pages.getPageStates());
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                ServiceFactory.getLogger().logWarning("[cache] Dependency information could not be stored in " + this.dependencyFile);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void remove(String key) {
        if (this.cache != null) {
            this.cache.removeEntry(key);
        }
    }

    public void flushAll() {
        if (this.cache != null) {
            this.cache.flushAll();
        }
    }
}

