/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.cache;

import flex.webtier.server.j2ee.cache.InvalidResourceException;
import flex.webtier.server.j2ee.cache.Resource;
import flex.webtier.server.j2ee.cache.ResourceManager;
import flex.webtier.util.Trace;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PageState
implements Serializable {
    static final long serialVersionUID = 6632526751227714786L;
    private Map dependencies = Collections.synchronizedMap(new HashMap());
    private String key;
    private long lastModified;
    private transient ResourceManager resourceManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PageState(String key, HashMap dependencies, long lastModified, ResourceManager resourceManager) {
        this.key = key;
        this.lastModified = lastModified;
        this.resourceManager = resourceManager;
        this.dependencies = dependencies;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public boolean isUpToDate() {
        if (!$assertionsDisabled && this.resourceManager == null) {
            throw new AssertionError((Object)"resourceManager must be set");
        }
        boolean uptodate = true;
        Set entries = this.dependencies.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext() && uptodate) {
            Map.Entry entry = iter.next();
            Resource resource = this.resourceManager.getResource((String)entry.getKey());
            if (resource != null) {
                try {
                    long last = (Long)entry.getValue();
                    long current = this.calculateLastModified(resource.getLastModified());
                    if (Math.abs(current - last) <= 1000L) continue;
                    if (Trace.cache) {
                        Trace.trace((String)("[cache] file modified = " + entry.getKey() + "; last = " + last + "; current = " + current));
                    }
                    uptodate = false;
                }
                catch (InvalidResourceException ire) {
                    if (Trace.cache) {
                        Trace.trace((String)("[cache] invalid resource exception = " + entry.getKey()));
                    }
                    uptodate = false;
                }
                continue;
            }
            if (Trace.cache) {
                Trace.trace((String)("[cache] invalid resource = " + entry.getKey()));
            }
            uptodate = false;
        }
        return uptodate;
    }

    private long calculateLastModified(long lastModified) {
        lastModified -= lastModified % 1000L;
        return lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    static {
        $assertionsDisabled = !PageState.class.desiredAssertionStatus();
    }
}

