/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Point;

public final class Matrix {
    public static final Matrix IDENTITY_MATRIX = new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double tx;
    public final double ty;

    public Matrix(double[] dArray) {
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
        this.tx = dArray.length > 4 ? dArray[4] : 0.0;
        this.ty = dArray.length > 5 ? dArray[5] : 0.0;
    }

    public Matrix(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.tx = d5;
        this.ty = d6;
    }

    public boolean isIdentity() {
        return Math.abs(this.a - 1.0) < 0.001 && Math.abs(this.d - 1.0) < 0.001 && Math.abs(this.b) < 0.001 && Math.abs(this.c) < 0.001 && Math.abs(this.tx) < 0.001 && Math.abs(this.ty) < 0.001;
    }

    public boolean isInverse(Matrix matrix) {
        Matrix matrix2 = this.multiply(matrix);
        return matrix2.isIdentity();
    }

    public Matrix multiply(Matrix matrix) {
        double d = this.a * matrix.a + this.b * matrix.c;
        double d2 = this.a * matrix.b + this.b * matrix.d;
        double d3 = this.c * matrix.a + this.d * matrix.c;
        double d4 = this.c * matrix.b + this.d * matrix.d;
        double d5 = this.tx * matrix.a + this.ty * matrix.c + matrix.tx;
        double d6 = this.tx * matrix.b + this.ty * matrix.d + matrix.ty;
        return new Matrix(d, d2, d3, d4, d5, d6);
    }

    public Matrix multiply(double d) {
        return new Matrix(this.a * d, this.b * d, this.c * d, this.d * d, this.tx * d, this.ty * d);
    }

    public void applyToPoint(Point point) {
        if (this.equals(IDENTITY_MATRIX)) {
            return;
        }
        double d = point.x;
        double d2 = point.y;
        point.x = d * this.a + d2 * this.c + this.tx;
        point.y = d * this.b + d2 * this.d + this.ty;
    }

    public double applyToXYGetX(double d, double d2) {
        return d * this.a + d2 * this.c + this.tx;
    }

    public double applyToXYGetY(double d, double d2) {
        return d * this.b + d2 * this.d + this.ty;
    }
}

