/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumer2BaseImpl;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QReducer
implements ScanConverter {
    EdgeBuilder edgeBuilder;
    Map scanLines = new HashMap();
    int firstScanline = Integer.MAX_VALUE;
    int lastScanline = Integer.MIN_VALUE;
    static boolean eofill = false;

    public QReducer() {
        this.edgeBuilder = new EdgeBuilder();
        this.edgeBuilder.setFlatness(1.0);
    }

    public void setScanType(int n) {
    }

    public OutlineConsumer2 getOutlineConsumer2() {
        return this.edgeBuilder;
    }

    public void getBitmap(BitmapConsumer bitmapConsumer) {
        this.finish(bitmapConsumer);
    }

    private static boolean isIntegral(double d) {
        return d == Math.floor(d);
    }

    private void insertEdge(Edge edge) {
        this.firstScanline = Math.min(this.firstScanline, edge.bottomScanLine);
        this.lastScanline = Math.max(this.lastScanline, edge.topScanLine);
        Integer n = new Integer(edge.bottomScanLine);
        ArrayList<Edge> arrayList = (ArrayList<Edge>)this.scanLines.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<Edge>();
            this.scanLines.put(n, arrayList);
        }
        arrayList.add(edge);
    }

    private Edge[] mergeAndSort(List list, Edge[] edgeArray) {
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < edgeArray.length; ++i) {
            if (edgeArray[i] == null) continue;
            ++n;
        }
        Object[] objectArray = new Edge[n];
        n = 0;
        for (int i = 0; i < edgeArray.length; ++i) {
            if (edgeArray[i] == null) continue;
            objectArray[n++] = edgeArray[i];
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (Edge)iterator.next();
            }
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void finish(BitmapConsumer bitmapConsumer) {
        Edge[] edgeArray = new Edge[]{};
        for (int i = this.firstScanline; i <= this.lastScanline; ++i) {
            edgeArray = this.mergeAndSort((List)this.scanLines.get(new Integer(i)), edgeArray);
            boolean bl = false;
            double d = 0.0;
            int n = 0;
            int n2 = 0;
            while (n2 < edgeArray.length) {
                if (!bl) {
                    d = edgeArray[n2].leftPixelInCurrentScanLine + 1;
                    bl = true;
                }
                double d2 = edgeArray[n2].leftPixelInCurrentScanLine;
                while (n2 < edgeArray.length && (double)edgeArray[n2].leftPixelInCurrentScanLine <= d2) {
                    Edge edge = edgeArray[n2];
                    if (!edge.atVertEdge) {
                        d = Math.min(d, (double)edge.leftPixelInCurrentScanLine);
                    }
                    d2 = Math.max(d2, (double)edge.rightPixelInCurrentScanline);
                    n += edge.getCntDelta(i);
                    edgeArray[n2] = edge.moveToNextScanLine(i + 1);
                    ++n2;
                }
                if ((eofill ? n & 3 : n) != 0) continue;
                bl = false;
                bitmapConsumer.addRun(d, d2 + 1.0, i);
            }
        }
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
    }

    private static class Edge
    implements Comparable {
        private final boolean reversed;
        private final boolean endsAtHorzEdge;
        private final boolean startsAtHorzEdge;
        private static final int LEFT = -1;
        private static final int SINGLE_VERTICAL = 0;
        private static final int RIGHT = 1;
        private static final int SINGLE_HORIZONTAL = 2;
        private final int lineType;
        private final double dx;
        private final double dy;
        private final int endPixelX;
        private double g;
        public final int bottomScanLine;
        public final int topScanLine;
        public final boolean atVertEdge;
        public int leftPixelInCurrentScanLine;
        public int rightPixelInCurrentScanline;

        public int getCntDelta(int n) {
            int n2 = 2;
            if (this.bottomScanLine == n && !this.startsAtHorzEdge) {
                --n2;
            }
            if (this.topScanLine == n && !this.endsAtHorzEdge) {
                --n2;
            }
            if (!this.reversed) {
                n2 = -n2;
            }
            return n2;
        }

        public int pixel(double d) {
            int n = (int)Math.floor(d);
            if ((double)n == d) {
                --n;
            }
            return n;
        }

        public Edge(double d, double d2, double d3, double d4) {
            int n;
            boolean bl = this.reversed = d2 > d4;
            if (this.reversed) {
                double d5 = d2;
                d2 = d4;
                d4 = d5;
                d5 = d;
                d = d3;
                d3 = d5;
            }
            this.dx = d3 - d;
            this.dy = d4 - d2;
            if (this.dx < 0.0) {
                this.atVertEdge = false;
                n = this.pixel(d);
                this.endPixelX = (int)Math.floor(d3);
            } else if (this.dx == 0.0) {
                this.atVertEdge = QReducer.isIntegral(d);
                this.endPixelX = n = this.pixel(d);
            } else {
                this.atVertEdge = false;
                this.endPixelX = this.pixel(d3);
                n = (int)Math.floor(d);
            }
            this.bottomScanLine = (int)Math.floor(d2);
            this.startsAtHorzEdge = QReducer.isIntegral(d2);
            this.topScanLine = this.pixel(d4);
            this.endsAtHorzEdge = QReducer.isIntegral(d4);
            if (this.bottomScanLine == this.topScanLine) {
                this.lineType = 2;
                this.leftPixelInCurrentScanLine = Math.min(n, this.endPixelX);
                this.rightPixelInCurrentScanline = Math.max(n, this.endPixelX);
            } else if (n == this.endPixelX) {
                this.lineType = 0;
                this.leftPixelInCurrentScanLine = n;
                this.rightPixelInCurrentScanline = n;
            } else if (n < this.endPixelX) {
                this.lineType = 1;
                this.rightPixelInCurrentScanline = n;
                this.leftPixelInCurrentScanLine = n;
                this.g = d - (double)n - 1.0 - (d2 - (double)this.bottomScanLine - 1.0) * this.dx / this.dy;
                while (this.g >= 0.0) {
                    ++this.rightPixelInCurrentScanline;
                    this.g -= 1.0;
                }
            } else {
                this.lineType = -1;
                this.rightPixelInCurrentScanline = n;
                this.leftPixelInCurrentScanLine = n;
                this.g = (double)n - d + (d2 - (double)this.bottomScanLine - 1.0) * this.dx / this.dy;
                while (this.g > 0.0) {
                    --this.leftPixelInCurrentScanLine;
                    this.g -= 1.0;
                }
            }
        }

        public Edge moveToNextScanLine(int n) {
            if (n > this.topScanLine) {
                return null;
            }
            if (this.lineType == 0) {
                return this;
            }
            if (this.topScanLine == n) {
                if (this.lineType == 1) {
                    this.leftPixelInCurrentScanLine = this.rightPixelInCurrentScanline;
                    this.rightPixelInCurrentScanline = this.endPixelX;
                } else {
                    this.rightPixelInCurrentScanline = this.leftPixelInCurrentScanLine;
                    this.leftPixelInCurrentScanLine = this.endPixelX;
                }
            } else if (this.lineType == 1) {
                this.leftPixelInCurrentScanLine = this.rightPixelInCurrentScanline;
                this.g += this.dx / this.dy;
                while (this.g >= 0.0) {
                    ++this.rightPixelInCurrentScanline;
                    this.g -= 1.0;
                }
                this.rightPixelInCurrentScanline = Math.min(this.rightPixelInCurrentScanline, this.endPixelX);
            } else {
                this.rightPixelInCurrentScanline = this.leftPixelInCurrentScanLine;
                this.g -= this.dx / this.dy;
                while (this.g > 0.0) {
                    --this.leftPixelInCurrentScanLine;
                    this.g -= 1.0;
                }
                this.leftPixelInCurrentScanLine = Math.max(this.leftPixelInCurrentScanLine, this.endPixelX);
            }
            return this;
        }

        public int compareTo(Object object) {
            Edge edge = (Edge)object;
            if (edge.leftPixelInCurrentScanLine < this.leftPixelInCurrentScanLine) {
                return 1;
            }
            if (edge.leftPixelInCurrentScanLine == this.leftPixelInCurrentScanLine) {
                return 0;
            }
            return -1;
        }
    }

    private class EdgeBuilder
    extends OutlineConsumer2BaseImpl {
        private double THRESHOLD = 127.0;
        private double epsilon;

        private EdgeBuilder() {
        }

        public void setFlatness(double d) {
            this.epsilon = Math.max(1.220703125E-4, 1.5 * d / 4.0);
        }

        public void setScanType(int n) {
        }

        public void startOutline() {
        }

        public void startContour() {
        }

        public void line(double d, double d2, double d3, double d4) {
            if (d2 != d4 || !QReducer.isIntegral(d2)) {
                QReducer.this.insertEdge(new Edge(d, d2, d3, d4));
            }
        }

        public void quadraticCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            if ((d <= d3 && d3 <= d5 || d5 <= d3 && d3 <= d) && Math.abs(d5 - d) < this.THRESHOLD && Math.abs(d5 - d - 2.0 * (d3 - d)) <= this.epsilon && (d2 <= d4 && d4 <= d6 || d6 <= d4 && d4 <= d2) && Math.abs(d6 - d2) < this.THRESHOLD && Math.abs(d6 - d2 - 2.0 * (d4 - d2)) <= this.epsilon) {
                this.line(d, d2, d5, d6);
            } else {
                double d7 = (d3 + d) / 2.0;
                double d8 = (d4 + d2) / 2.0;
                double d9 = (d5 + d3) / 2.0;
                double d10 = (d6 + d4) / 2.0;
                double d11 = (d7 + d9) / 2.0;
                double d12 = (d8 + d10) / 2.0;
                this.quadraticCurve(d, d2, d7, d8, d11, d12);
                this.quadraticCurve(d11, d12, d9, d10, d5, d6);
            }
        }

        public void cubicCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            if ((d <= d3 && d3 <= d5 && d5 <= d7 || d7 <= d5 && d5 <= d3 && d3 <= d) && Math.abs(d7 - d) < this.THRESHOLD && Math.abs(d7 - d - 3.0 * (d3 - d)) <= this.epsilon && Math.abs(d7 - d - 3.0 * (d7 - d5)) <= this.epsilon && (d2 <= d4 && d4 <= d6 && d6 <= d8 || d8 <= d6 && d6 <= d4 && d4 <= d2) && Math.abs(d8 - d2) < this.THRESHOLD && Math.abs(d8 - d2 - 3.0 * (d4 - d2)) <= this.epsilon && Math.abs(d8 - d2 - 3.0 * (d8 - d6)) <= this.epsilon) {
                this.line(d, d2, d7, d8);
            } else {
                double d9 = (d3 + d) / 2.0;
                double d10 = (d4 + d2) / 2.0;
                double d11 = (d5 + d3) / 2.0;
                double d12 = (d6 + d4) / 2.0;
                double d13 = (d7 + d5) / 2.0;
                double d14 = (d8 + d6) / 2.0;
                double d15 = (d11 + d9) / 2.0;
                double d16 = (d12 + d10) / 2.0;
                double d17 = (d13 + d11) / 2.0;
                double d18 = (d14 + d12) / 2.0;
                double d19 = (d15 + d17) / 2.0;
                double d20 = (d16 + d18) / 2.0;
                this.cubicCurve(d, d2, d9, d10, d15, d16, d19, d20);
                this.cubicCurve(d19, d20, d17, d18, d13, d14, d7, d8);
            }
        }

        public void endContour() {
        }

        public void endOutline() {
        }
    }
}

