/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;

final class Charset {
    public final CFFByteArray data;
    public final int offset;
    public final int size;
    private static final int[] isoAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] expertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 27, 28, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    private static final int[] expertSubsetCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};

    Charset(CFFByteArray cFFByteArray, int n, int n2) throws InvalidFontException {
        this.data = n < 3 ? null : cFFByteArray;
        this.offset = n;
        this.size = this.size(n2);
    }

    Charset(CFFByteArray cFFByteArray) {
        this.data = cFFByteArray;
        this.offset = 0;
        this.size = cFFByteArray.getSize();
    }

    static Charset identityCharset(int n) {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder;
        if (--n > 255) {
            cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(5);
            cFFByteArrayBuilder.addCard8(2);
            cFFByteArrayBuilder.addCard16(1);
            cFFByteArrayBuilder.addCard16(n);
        } else {
            cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(4);
            cFFByteArrayBuilder.addCard8(1);
            cFFByteArrayBuilder.addCard16(1);
            cFFByteArrayBuilder.addCard8(n);
        }
        return new Charset(cFFByteArrayBuilder.toCFFByteArray());
    }

    private static Charset format0Generator(Charset charset, Subset subset) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 2 * (subset.getNumGlyphs() - 1));
        cFFByteArrayBuilder.addCard8(0);
        for (int i = 1; i < subset.getNumGlyphs(); ++i) {
            cFFByteArrayBuilder.addCard16(charset.gid2sid(subset.getFullGid(i)));
        }
        return new Charset(cFFByteArrayBuilder.toCFFByteArray());
    }

    private static Charset format1Generator(Charset charset, Subset subset, int n) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 3 * n);
        cFFByteArrayBuilder.addCard8(1);
        int n2 = 0;
        int n3 = charset.gid2sid(subset.getFullGid(1));
        cFFByteArrayBuilder.addCard16(n3);
        for (int i = 2; i < subset.getNumGlyphs(); ++i) {
            int n4 = charset.gid2sid(subset.getFullGid(i));
            if (n2 == 255 || n4 != n3 + 1) {
                cFFByteArrayBuilder.addCard8(n2);
                n2 = 0;
                cFFByteArrayBuilder.addCard16(n4);
            } else {
                ++n2;
            }
            n3 = n4;
        }
        cFFByteArrayBuilder.addCard8(n2);
        return new Charset(cFFByteArrayBuilder.toCFFByteArray());
    }

    private static Charset format2Generator(Charset charset, Subset subset, int n) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 3 * n);
        cFFByteArrayBuilder.addCard8(2);
        int n2 = 0;
        int n3 = charset.gid2sid(subset.getFullGid(1));
        cFFByteArrayBuilder.addCard16(n3);
        for (int i = 2; i < subset.getNumGlyphs(); ++i) {
            int n4 = charset.gid2sid(subset.getFullGid(i));
            if (n4 != n3 + 1) {
                cFFByteArrayBuilder.addCard16(n2);
                n2 = 0;
                cFFByteArrayBuilder.addCard16(n4);
            } else {
                ++n2;
            }
            n3 = n4;
        }
        cFFByteArrayBuilder.addCard8(n2);
        return new Charset(cFFByteArrayBuilder.toCFFByteArray());
    }

    static Charset charSetFromSubset(Charset charset, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        int n3 = subset.getNumGlyphs();
        int n4 = 2 * n3;
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        if (n3 > 1) {
            n2 = charset.gid2sid(subset.getFullGid(1));
            for (int i = 2; i < n3; ++i) {
                n = charset.gid2sid(subset.getFullGid(i));
                if (n7 == 255 || n != n2 + 1) {
                    ++n5;
                    n7 = 0;
                } else {
                    ++n7;
                }
                if (n != n2 + 1) {
                    ++n6;
                }
                n2 = n;
            }
        }
        n2 = 3 * n5;
        n = 4 * n6;
        if (n4 <= n2) {
            if (n4 <= n) {
                return Charset.format0Generator(charset, subset);
            }
            return Charset.format2Generator(charset, subset, n6);
        }
        if (n2 <= n) {
            return Charset.format1Generator(charset, subset, n5);
        }
        return Charset.format2Generator(charset, subset, n6);
    }

    public int gid2sid(int n) throws InvalidFontException, UnsupportedFontException {
        if (n == 0) {
            return 0;
        }
        if (this.data == null) {
            if (this.offset == 0) {
                return isoAdobeCharset[n];
            }
            if (this.offset == 1) {
                return expertCharset[n];
            }
            if (this.offset == 2) {
                return expertSubsetCharset[n];
            }
            throw new InvalidFontException("invalid charset offset (" + this.offset + ")");
        }
        int n2 = this.offset;
        int n3 = this.data.getcard8(n2);
        ++n2;
        switch (n3) {
            case 0: {
                return this.data.getcard16(n2 + 2 * (n - 1));
            }
            case 1: {
                int n4 = 1;
                while (n2 < this.offset + this.size) {
                    int n5 = this.data.getcard16(n2);
                    int n6 = this.data.getcard8(n2 += 2);
                    ++n2;
                    if (n4 <= n && n <= n4 + n6) {
                        return n5 + (n - n4);
                    }
                    n4 += n6 + 1;
                }
                return -1;
            }
            case 2: {
                int n7 = 1;
                while (n2 < this.offset + this.size) {
                    int n8 = this.data.getcard16(n2);
                    int n9 = this.data.getcard16(n2 += 2);
                    n2 += 2;
                    if (n7 <= n && n <= n7 + n9) {
                        return n8 + (n - n7);
                    }
                    n7 += n9 + 1;
                }
                return -1;
            }
        }
        throw new UnsupportedFontException("CFF charset in format " + n3);
    }

    public int sid2gid(int n) throws InvalidFontException, UnsupportedFontException {
        if (n == 0) {
            return 0;
        }
        if (this.data == null) {
            if (this.offset == 0) {
                for (int i = 0; i < isoAdobeCharset.length; ++i) {
                    if (isoAdobeCharset[i] != n) continue;
                    return i;
                }
                return -1;
            }
            if (this.offset == 1) {
                for (int i = 0; i < expertCharset.length; ++i) {
                    if (expertCharset[i] != n) continue;
                    return i;
                }
                return -1;
            }
            if (this.offset == 2) {
                for (int i = 0; i < expertSubsetCharset.length; ++i) {
                    if (expertSubsetCharset[i] != n) continue;
                    return i;
                }
                return -1;
            }
            throw new InvalidFontException("invalid charset offset (" + this.offset + ")");
        }
        int n2 = this.offset;
        int n3 = this.data.getcard8(n2);
        ++n2;
        switch (n3) {
            case 0: {
                int n4 = 1;
                while (n2 < this.offset + this.size) {
                    if (this.data.getcard16(n2) == n) {
                        return n4;
                    }
                    n2 += 2;
                    ++n4;
                }
                return -1;
            }
            case 1: {
                int n5 = 1;
                while (n2 < this.offset + this.size) {
                    int n6 = this.data.getcard16(n2);
                    int n7 = this.data.getcard8(n2 += 2);
                    ++n2;
                    if (n6 <= n && n <= n6 + n7) {
                        return n5 + (n - n6);
                    }
                    n5 += n7 + 1;
                }
                return -1;
            }
            case 2: {
                int n8 = 1;
                while (n2 < this.offset + this.size) {
                    int n9 = this.data.getcard16(n2);
                    int n10 = this.data.getcard16(n2 += 2);
                    n2 += 2;
                    if (n9 <= n && n <= n9 + n10) {
                        return n8 + (n - n9);
                    }
                    n8 += n10 + 1;
                }
                return -1;
            }
        }
        throw new UnsupportedFontException("CFF charset in format " + n3);
    }

    int size(int n) throws InvalidFontException {
        if (this.offset < 3) {
            return 0;
        }
        int n2 = this.offset;
        int n3 = this.data.getcard8(n2);
        ++n2;
        switch (n3) {
            case 0: {
                return 1 + 2 * n;
            }
            case 1: {
                int n4;
                for (int i = 1; i < n; i += n4 + 1) {
                    n4 = this.data.getcard8(n2 += 2);
                    ++n2;
                }
                break;
            }
            case 2: {
                int n5;
                for (int i = 1; i < n; i += n5 + 1) {
                    n5 = this.data.getcard16(n2 += 2);
                    n2 += 2;
                }
                break;
            }
        }
        return n2 - this.offset;
    }

    public int predefinedOffset() {
        if (this.data == null) {
            return this.offset;
        }
        return -1;
    }

    public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) throws InvalidFontException {
        if (this.data != null) {
            cFFByteArrayBuilder.addBytes(this.data, this.offset, this.size);
        }
    }
}

