/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Glyf;
import com.adobe.fontengine.font.opentype.Hmtx;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class TTParser {
    List points = new ArrayList();
    List endPoints = new ArrayList();

    TTParser() {
    }

    private void getSimpleGlyph(Glyf glyf, int n, int n2) throws InvalidFontException {
        int n3;
        int n4;
        int n5;
        int n6 = this.points.size();
        int n7 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = glyf.glyf.data.getuint16(n);
            n += 2;
            if (n4 < n7) {
                throw new InvalidGlyphException("endpoints in a simple TT glyph must be increasing");
            }
            n7 = n4;
            this.endPoints.add(new Integer(n4 + n6));
        }
        n5 = (Integer)this.endPoints.get(this.endPoints.size() - 1) + 1 - n6;
        n += glyf.glyf.data.getuint16(n) + 2;
        for (n4 = 0; n4 < n5; ++n4) {
            Coord coord = new Coord();
            this.points.add(coord);
            coord.flags = glyf.glyf.data.getuint8(n++);
            if ((coord.flags & 8) == 0) continue;
            int n8 = coord.flags;
            int n9 = glyf.glyf.data.getuint8(n++);
            while (n9-- > 0) {
                coord = new Coord();
                this.points.add(coord);
                coord.flags = n8;
                ++n4;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            Coord coord = (Coord)this.points.get(n3 + n6);
            if ((coord.flags & 2) != 0) {
                n4 = (coord.flags & 0x10) == 0 ? (n4 -= glyf.glyf.data.getuint8(n++)) : (n4 += glyf.glyf.data.getuint8(n++));
            } else if ((coord.flags & 0x10) == 0) {
                n4 += glyf.glyf.data.getint16(n);
                n += 2;
            }
            coord.x = n4;
        }
        n3 = 0;
        for (int i = 0; i < n5; ++i) {
            Coord coord = (Coord)this.points.get(i + n6);
            if ((coord.flags & 4) != 0) {
                n3 = (coord.flags & 0x20) == 0 ? (n3 -= glyf.glyf.data.getuint8(n++)) : (n3 += glyf.glyf.data.getuint8(n++));
            } else if ((coord.flags & 0x20) == 0) {
                n3 += glyf.glyf.data.getint16(n);
                n += 2;
            }
            coord.y = n3;
        }
    }

    private int getCompositeGlyph(Glyf glyf, int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = n2;
        while (true) {
            double d;
            double d2;
            int n4;
            int n5;
            boolean bl;
            Matrix matrix = null;
            int n6 = glyf.glyf.data.getuint16(n);
            int n7 = glyf.glyf.data.getuint16(n += 2);
            n += 2;
            boolean bl2 = bl = (n6 & 2) != 0;
            if ((n6 & 1) != 0) {
                if (bl) {
                    n5 = glyf.glyf.data.getint16(n);
                    n4 = glyf.glyf.data.getint16(n + 2);
                } else {
                    n5 = glyf.glyf.data.getuint16(n);
                    n4 = glyf.glyf.data.getuint16(n + 2);
                }
                n += 4;
            } else {
                if (bl) {
                    n5 = glyf.glyf.data.getint8(n);
                    n4 = glyf.glyf.data.getint8(n + 1);
                } else {
                    n5 = glyf.glyf.data.getuint8(n);
                    n4 = glyf.glyf.data.getuint8(n + 1);
                }
                n += 2;
            }
            if ((n6 & 8) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                n += 2;
                matrix = new Matrix(d2, 0.0, 0.0, d2, 0.0, 0.0);
            } else if ((n6 & 0x80) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                double d3 = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                double d4 = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                d = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                n += 2;
                matrix = new Matrix(d2, d3, d4, d, 0.0, 0.0);
            } else if ((n6 & 0x40) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                d = (double)glyf.glyf.data.getint16(n + 2) / 16384.0;
                matrix = new Matrix(d2, 0.0, 0.0, d, 0.0, 0.0);
                n += 4;
            }
            if ((n6 & 0x200) != 0) {
                n3 = n7;
            }
            int n8 = this.points.size();
            int n9 = n;
            n = glyf.getGlyphLocation(n7);
            if (glyf.getGlyphLocation(n7 + 1) != n) {
                int n10;
                Coord coord;
                int n11 = glyf.glyf.data.getint16(n);
                n += 10;
                if (n11 < 0) {
                    n3 = this.getCompositeGlyph(glyf, n, n7);
                } else {
                    this.getSimpleGlyph(glyf, n, n11);
                }
                if (!bl) {
                    coord = (Coord)this.points.get(n5);
                    Coord coord2 = (Coord)this.points.get(n4 + n8);
                    n5 = coord.x - coord2.x;
                    n4 = coord.y - coord2.y;
                }
                if (matrix != null) {
                    for (n10 = n8; n10 < this.points.size(); ++n10) {
                        coord = (Coord)this.points.get(n10);
                        int n12 = coord.x;
                        coord.x = (int)Math.round(matrix.applyToXYGetX(coord.x, coord.y) + (double)n5);
                        coord.y = (int)Math.round(matrix.applyToXYGetY(n12, coord.y) + (double)n4);
                    }
                } else if (n5 != 0 || n4 != 0) {
                    for (n10 = n8; n10 < this.points.size(); ++n10) {
                        coord = (Coord)this.points.get(n10);
                        coord.x += n5;
                        coord.y += n4;
                    }
                }
            }
            if ((n6 & 0x20) == 0) {
                return n3;
            }
            n = n9;
        }
    }

    private void adjustPointsBySideBearing(int n, Hmtx hmtx, int n2) throws InvalidFontException {
        int n3 = hmtx.getLeftSideBearing(n);
        int n4 = n3 - n2;
        if (n4 != 0) {
            Iterator iterator = this.points.iterator();
            while (iterator.hasNext()) {
                Coord coord = (Coord)iterator.next();
                coord.x += n4;
            }
        }
    }

    private void emitCountours(OutlineConsumer outlineConsumer) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.endPoints.size(); ++n) {
            int n3 = (Integer)this.endPoints.get(n);
            if (n2 == n3) {
                ++n2;
                continue;
            }
            int n4 = n3;
            for (int i = n3 + n2 + 1 - n4; n4 > i; --n4, ++i) {
                Object e = this.points.set(i, this.points.get(n4));
                this.points.set(n4, e);
            }
            n2 = n3 + 1;
        }
        n2 = 0;
        for (n = 0; n < this.endPoints.size(); ++n) {
            int n5;
            double d = 0.0;
            double d2 = 0.0;
            int n6 = (Integer)this.endPoints.get(n);
            if (n2 == n6) {
                ++n2;
                continue;
            }
            int n7 = n2;
            boolean bl = true;
            Coord coord = null;
            Coord coord2 = null;
            while (bl && n7 < n6) {
                coord = (Coord)this.points.get(n7);
                if ((coord.flags & 1) != 0) {
                    outlineConsumer.moveto(coord.x, coord.y);
                    bl = false;
                    continue;
                }
                ++n7;
            }
            if (bl) {
                Coord coord3 = (Coord)this.points.get(n6);
                n7 = n2;
                coord = (Coord)this.points.get(n7);
                outlineConsumer.moveto((double)(coord.x + coord3.x) / 2.0, (double)(coord.y + coord3.y) / 2.0);
                d = (double)(coord3.x + 5 * coord.x) / 6.0;
                d2 = (double)(coord3.y + 5 * coord.y) / 6.0;
            }
            int n8 = n5 = n7;
            do {
                if (n8++ == n6) {
                    n8 = n2;
                }
                coord2 = (Coord)this.points.get(n8);
                if ((coord.flags & 1) != 0) {
                    if ((coord2.flags & 1) != 0) {
                        outlineConsumer.lineto(coord2.x, coord2.y);
                    } else {
                        d = coord2.x;
                        d2 = coord2.y;
                    }
                } else if ((coord2.flags & 1) != 0) {
                    outlineConsumer.curveto(d, d2, coord2.x, coord2.y);
                } else {
                    outlineConsumer.curveto(d, d2, (double)(coord.x + coord2.x) / 2.0, (double)(coord.y + coord2.y) / 2.0);
                    d = coord2.x;
                    d2 = coord2.y;
                }
                n5 = n8;
                coord = (Coord)this.points.get(n5);
            } while (n8 != n7);
            n2 = n6 + 1;
        }
        outlineConsumer.endchar();
    }

    void parse(OpenTypeFont openTypeFont, int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidGlyphException {
        int n2;
        Glyf glyf = openTypeFont.glyf;
        this.points.clear();
        this.endPoints.clear();
        try {
            n2 = glyf.getGlyphLocation(n);
        }
        catch (InvalidFontException invalidFontException) {
            return;
        }
        try {
            int n3;
            if (glyf.getGlyphLocation(n + 1) == n2) {
                outlineConsumer.endchar();
                return;
            }
            int n4 = glyf.glyf.data.getint16(n2);
            int n5 = n;
            n2 += 10;
            if (openTypeFont.head == null) {
                throw new InvalidFontException("OpenType font with 'glyf' table needs a 'head' table");
            }
            outlineConsumer.setMatrix(new Matrix(1.0 / (double)openTypeFont.head.getUnitsPerEm(), 0.0, 0.0, 1.0 / (double)openTypeFont.head.getUnitsPerEm(), 0.0, 0.0));
            if (n4 < 0) {
                n5 = this.getCompositeGlyph(glyf, n2, n);
                n3 = glyf.glyf.data.getint16(glyf.getGlyphLocation(n5) + 2);
            } else {
                this.getSimpleGlyph(glyf, n2, n4);
                n3 = glyf.glyf.data.getint16(n2 - 8);
            }
            this.adjustPointsBySideBearing(n5, openTypeFont.hmtx, n3);
            this.emitCountours(outlineConsumer);
        }
        catch (InvalidFontException invalidFontException) {
            throw new InvalidGlyphException(invalidFontException);
        }
    }

    private static class Coord {
        int x;
        int y;
        int flags;

        private Coord() {
        }
    }
}

