/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Reader;
import com.adobe.fontengine.font.postscript.Tokenizer;
import java.io.IOException;

final class AsciiEexecReader
implements Reader {
    private int hiNib = -1;
    private int cipherR = 55665;
    private int lastRead;
    private int secondToLastRead;
    private int lastCipher;

    AsciiEexecReader() {
    }

    public int read(FontInputStream fontInputStream) throws IOException, InvalidFontException {
        this.lastCipher = this.cipherR;
        this.secondToLastRead = fontInputStream.read();
        while (this.secondToLastRead != -1 && Tokenizer.digitValue((byte)this.secondToLastRead) > 15) {
            this.secondToLastRead = fontInputStream.read();
        }
        this.lastRead = fontInputStream.read();
        while (this.lastRead != -1 && Tokenizer.digitValue((byte)this.lastRead) > 15) {
            this.lastRead = fontInputStream.read();
        }
        if (this.secondToLastRead == -1 || this.lastRead == -1) {
            throw new InvalidFontException("unexpected end of file");
        }
        this.decryptByte((byte)this.secondToLastRead);
        return this.decryptByte((byte)this.lastRead);
    }

    public void unreadLast(FontInputStream fontInputStream) throws IOException {
        this.cipherR = this.lastCipher;
        fontInputStream.unread(this.lastRead);
        fontInputStream.unread(this.secondToLastRead);
    }

    public int decryptByte(byte by) {
        if (this.hiNib == -1) {
            this.hiNib = Tokenizer.digitValue(by);
            return -1;
        }
        byte by2 = (byte)(this.hiNib << 4 | Tokenizer.digitValue(by));
        byte by3 = (byte)(by2 ^ this.cipherR >> 8);
        this.cipherR = ((by2 & 0xFF) + this.cipherR) * 52845 + 22719 & 0xFFFF;
        this.hiNib = -1;
        return by3 & 0xFF;
    }

    int decryptBuffer(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (Tokenizer.digitValue(byArray[i]) > 15 || (n3 = this.decryptByte(byArray[i])) == -1) continue;
            byArray[n2++] = (byte)n3;
        }
        return n2;
    }
}

