/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.Graph;
import flex2.compiler.util.Vertex;
import flex2.compiler.util.Visitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class Algorithms {
    public static boolean isCyclic(Graph g) {
        ConnectednessCounter counter = new ConnectednessCounter();
        Algorithms.topologicalSort(g, counter);
        return counter.count != g.getVertices().size();
    }

    public static Set detectCycles(Graph g) {
        ConnectednessCounter counter = new ConnectednessCounter(g.getVertices());
        Algorithms.topologicalSort(g, counter);
        return counter.remained;
    }

    public static void topologicalSort(Graph g, Visitor visitor) {
        int[] inDegree = new int[g.getVertices().size()];
        Vertex[] vertices = new Vertex[inDegree.length];
        Iterator i = g.getVertices().iterator();
        while (i.hasNext()) {
            Vertex v;
            vertices[v.id] = v = (Vertex)i.next();
            inDegree[v.id] = v.inDegrees();
        }
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        int length = vertices.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (inDegree[i2] != 0) continue;
            queue.add(vertices[i2]);
        }
        while (!queue.isEmpty()) {
            Vertex v = (Vertex)queue.removeFirst();
            if (visitor != null) {
                visitor.visit(v);
            }
            if (v.getSuccessors() == null) continue;
            Iterator i3 = v.getSuccessors().iterator();
            while (i3.hasNext()) {
                Vertex head = (Vertex)i3.next();
                int n = head.id;
                inDegree[n] = inDegree[n] - 1;
                if (inDegree[head.id] != 0) continue;
                queue.add(head);
            }
        }
    }

    private static class ConnectednessCounter
    implements Visitor {
        private int count;
        private Set remained;

        private ConnectednessCounter() {
            this.count = 0;
        }

        private ConnectednessCounter(Set vertices) {
            this.remained = new HashSet(vertices);
        }

        public void visit(Object v) {
            ++this.count;
            this.remained.remove(v);
        }
    }
}

