/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.util.HashSet;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.DecoderException;
import macromedia.abc.Scanner;
import macromedia.abc.Visitor;
import macromedia.asc.util.Boxing;

public final class Decoder {
    public final int minorVersion;
    public final int majorVersion;
    public final ConstantPool constantPool;
    public final MethodInfo methodInfo;
    public final MetaDataInfo metadataInfo;
    public final ClassInfo classInfo;
    public final ScriptInfo scriptInfo;
    public final MethodBodies methodBodies;
    public final Opcodes opcodes;
    private final BytecodeBuffer in;

    public Decoder(BytecodeBuffer bytecodeBuffer) throws DecoderException {
        this.minorVersion = bytecodeBuffer.readU16();
        this.majorVersion = bytecodeBuffer.readU16();
        this.constantPool = new ConstantPool(bytecodeBuffer);
        int n = bytecodeBuffer.pos();
        this.methodInfo = new MethodInfo(this, bytecodeBuffer);
        this.methodInfo.estimatedSize = bytecodeBuffer.pos() - n;
        n = bytecodeBuffer.pos();
        this.metadataInfo = new MetaDataInfo(this, bytecodeBuffer);
        this.metadataInfo.estimatedSize = bytecodeBuffer.pos() - n;
        n = bytecodeBuffer.pos();
        this.classInfo = new ClassInfo(this, bytecodeBuffer);
        this.classInfo.estimatedSize = bytecodeBuffer.pos() - n;
        n = bytecodeBuffer.pos();
        this.scriptInfo = new ScriptInfo(this, bytecodeBuffer);
        this.scriptInfo.estimatedSize = bytecodeBuffer.pos() - n;
        n = bytecodeBuffer.pos();
        this.methodBodies = new MethodBodies(this, bytecodeBuffer);
        this.methodBodies.estimatedSize = bytecodeBuffer.pos() - n;
        this.opcodes = new Opcodes(this, bytecodeBuffer);
        this.in = bytecodeBuffer;
    }

    public int pos() {
        return this.in.pos();
    }

    public class Opcodes {
        BytecodeBuffer in;
        private HashSet<Integer> targetSet;
        final /* synthetic */ Decoder this$0;

        /*
         * WARNING - void declaration
         */
        public Opcodes(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
        }

        public void addTarget(int n) {
            if (this.targetSet == null) {
                this.targetSet = new HashSet();
            }
            this.targetSet.add(Boxing.valueOf(n));
        }

        public void reset() {
            this.targetSet = null;
        }

        public void decode(int n, long l, int n2, Visitor visitor) throws DecoderException {
            for (int i = 0; i < n2; ++i) {
                this.decode(n, l, visitor);
            }
        }

        public void decode(int n, long l, Visitor visitor) throws DecoderException {
            int n2 = this.in.pos();
            this.in.seek(n);
            long l2 = (long)n + l;
            block156: while ((long)this.in.pos() < l2) {
                int n3 = this.in.pos();
                int n4 = this.in.readU8();
                if (n4 == 9) {
                    this.addTarget(n3);
                }
                if (this.targetSet != null && this.targetSet.contains(Boxing.valueOf(n3))) {
                    visitor.target(n3);
                }
                switch (n4) {
                    case 12: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifnlt(n5, this.in.pos());
                        continue block156;
                    }
                    case 13: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifnle(n5, this.in.pos());
                        continue block156;
                    }
                    case 14: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifngt(n5, this.in.pos());
                        continue block156;
                    }
                    case 15: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifnge(n5, this.in.pos());
                        continue block156;
                    }
                    case 48: {
                        visitor.OP_pushscope();
                        continue block156;
                    }
                    case 87: {
                        visitor.OP_newactivation();
                        continue block156;
                    }
                    case 90: {
                        int n5 = this.in.readU32();
                        visitor.OP_newcatch(n5);
                        continue block156;
                    }
                    case 91: {
                        visitor.OP_deldescendants();
                        continue block156;
                    }
                    case 100: {
                        visitor.OP_getglobalscope();
                        continue block156;
                    }
                    case 208: {
                        visitor.OP_getlocal0();
                        continue block156;
                    }
                    case 209: {
                        visitor.OP_getlocal1();
                        continue block156;
                    }
                    case 210: {
                        visitor.OP_getlocal2();
                        continue block156;
                    }
                    case 211: {
                        visitor.OP_getlocal3();
                        continue block156;
                    }
                    case 212: {
                        visitor.OP_setlocal0();
                        continue block156;
                    }
                    case 213: {
                        visitor.OP_setlocal1();
                        continue block156;
                    }
                    case 214: {
                        visitor.OP_setlocal2();
                        continue block156;
                    }
                    case 215: {
                        visitor.OP_setlocal3();
                        continue block156;
                    }
                    case 71: {
                        visitor.OP_returnvoid();
                        continue block156;
                    }
                    case 72: {
                        visitor.OP_returnvalue();
                        continue block156;
                    }
                    case 2: {
                        visitor.OP_nop();
                        continue block156;
                    }
                    case 1: {
                        visitor.OP_bkpt();
                        continue block156;
                    }
                    case 243: {
                        visitor.OP_timestamp();
                        continue block156;
                    }
                    case 240: {
                        int n5 = this.in.readU32();
                        visitor.OP_debugline(n5);
                        continue block156;
                    }
                    case 242: {
                        this.in.readU32();
                        visitor.OP_bkptline();
                        continue block156;
                    }
                    case 239: {
                        int n5 = this.in.readU8();
                        int n6 = this.in.readU32();
                        int n7 = this.in.readU8();
                        int n8 = this.in.readU32();
                        visitor.OP_debug(n5, n6, n7, n8);
                        continue block156;
                    }
                    case 241: {
                        int n5 = this.in.readU32();
                        visitor.OP_debugfile(n5);
                        continue block156;
                    }
                    case 16: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_jump(n5, this.in.pos());
                        continue block156;
                    }
                    case 32: {
                        visitor.OP_pushnull();
                        continue block156;
                    }
                    case 33: {
                        visitor.OP_pushundefined();
                        continue block156;
                    }
                    case 44: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushstring(n5);
                        continue block156;
                    }
                    case 49: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushnamespace(n5);
                        continue block156;
                    }
                    case 45: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushint(n5);
                        continue block156;
                    }
                    case 46: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushuint(n5);
                        continue block156;
                    }
                    case 47: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushdouble(n5);
                        continue block156;
                    }
                    case 98: {
                        int n5 = this.in.readU32();
                        visitor.OP_getlocal(n5);
                        continue block156;
                    }
                    case 38: {
                        visitor.OP_pushtrue();
                        continue block156;
                    }
                    case 39: {
                        visitor.OP_pushfalse();
                        continue block156;
                    }
                    case 40: {
                        visitor.OP_pushnan();
                        continue block156;
                    }
                    case 41: {
                        visitor.OP_pop();
                        continue block156;
                    }
                    case 42: {
                        visitor.OP_dup();
                        continue block156;
                    }
                    case 43: {
                        visitor.OP_swap();
                        continue block156;
                    }
                    case 112: {
                        visitor.OP_convert_s();
                        continue block156;
                    }
                    case 113: {
                        visitor.OP_esc_xelem();
                        continue block156;
                    }
                    case 114: {
                        visitor.OP_esc_xattr();
                        continue block156;
                    }
                    case 120: {
                        visitor.OP_checkfilter();
                        continue block156;
                    }
                    case 117: {
                        visitor.OP_convert_d();
                        continue block156;
                    }
                    case 118: {
                        visitor.OP_convert_b();
                        continue block156;
                    }
                    case 119: {
                        visitor.OP_convert_o();
                        continue block156;
                    }
                    case 144: {
                        visitor.OP_negate();
                        continue block156;
                    }
                    case 196: {
                        visitor.OP_negate_i();
                        continue block156;
                    }
                    case 145: {
                        visitor.OP_increment();
                        continue block156;
                    }
                    case 192: {
                        visitor.OP_increment_i();
                        continue block156;
                    }
                    case 146: {
                        int n5 = this.in.readU32();
                        visitor.OP_inclocal(n5);
                        continue block156;
                    }
                    case 8: {
                        int n5 = this.in.readU32();
                        visitor.OP_kill(n5);
                        continue block156;
                    }
                    case 9: {
                        visitor.OP_label();
                        continue block156;
                    }
                    case 194: {
                        int n5 = this.in.readU32();
                        visitor.OP_inclocal_i(n5);
                        continue block156;
                    }
                    case 147: {
                        visitor.OP_decrement();
                        continue block156;
                    }
                    case 193: {
                        visitor.OP_decrement_i();
                        continue block156;
                    }
                    case 148: {
                        int n5 = this.in.readU32();
                        visitor.OP_declocal(n5);
                        continue block156;
                    }
                    case 195: {
                        int n5 = this.in.readU32();
                        visitor.OP_declocal_i(n5);
                        continue block156;
                    }
                    case 149: {
                        visitor.OP_typeof();
                        continue block156;
                    }
                    case 150: {
                        visitor.OP_not();
                        continue block156;
                    }
                    case 151: {
                        visitor.OP_bitnot();
                        continue block156;
                    }
                    case 99: {
                        int n5 = this.in.readU32();
                        visitor.OP_setlocal(n5);
                        continue block156;
                    }
                    case 160: {
                        visitor.OP_add();
                        continue block156;
                    }
                    case 197: {
                        visitor.OP_add_i();
                        continue block156;
                    }
                    case 161: {
                        visitor.OP_subtract();
                        continue block156;
                    }
                    case 198: {
                        visitor.OP_subtract_i();
                        continue block156;
                    }
                    case 162: {
                        visitor.OP_multiply();
                        continue block156;
                    }
                    case 199: {
                        visitor.OP_multiply_i();
                        continue block156;
                    }
                    case 163: {
                        visitor.OP_divide();
                        continue block156;
                    }
                    case 164: {
                        visitor.OP_modulo();
                        continue block156;
                    }
                    case 165: {
                        visitor.OP_lshift();
                        continue block156;
                    }
                    case 166: {
                        visitor.OP_rshift();
                        continue block156;
                    }
                    case 167: {
                        visitor.OP_urshift();
                        continue block156;
                    }
                    case 168: {
                        visitor.OP_bitand();
                        continue block156;
                    }
                    case 169: {
                        visitor.OP_bitor();
                        continue block156;
                    }
                    case 170: {
                        visitor.OP_bitxor();
                        continue block156;
                    }
                    case 171: {
                        visitor.OP_equals();
                        continue block156;
                    }
                    case 172: {
                        visitor.OP_strictequals();
                        continue block156;
                    }
                    case 27: {
                        int n5 = this.in.pos() - 1;
                        int n6 = this.in.readS24();
                        this.addTarget(n6 + n5);
                        int n7 = this.in.readU32();
                        int[] nArray = new int[n7 + 1];
                        int n9 = this.in.pos();
                        int n10 = nArray.length;
                        for (int i = 0; i < n10; ++i) {
                            nArray[i] = this.in.readS24();
                            this.addTarget(nArray[i] + n5);
                        }
                        visitor.OP_lookupswitch(n6, nArray, n5, n9);
                        continue block156;
                    }
                    case 17: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_iftrue(n5, this.in.pos());
                        continue block156;
                    }
                    case 18: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_iffalse(n5, this.in.pos());
                        continue block156;
                    }
                    case 19: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifeq(n5, this.in.pos());
                        continue block156;
                    }
                    case 20: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifne(n5, this.in.pos());
                        continue block156;
                    }
                    case 25: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifstricteq(n5, this.in.pos());
                        continue block156;
                    }
                    case 26: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifstrictne(n5, this.in.pos());
                        continue block156;
                    }
                    case 21: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_iflt(n5, this.in.pos());
                        continue block156;
                    }
                    case 22: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifle(n5, this.in.pos());
                        continue block156;
                    }
                    case 23: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifgt(n5, this.in.pos());
                        continue block156;
                    }
                    case 24: {
                        int n5 = this.in.readS24();
                        this.addTarget(n5 + this.in.pos());
                        visitor.OP_ifge(n5, this.in.pos());
                        continue block156;
                    }
                    case 173: {
                        visitor.OP_lessthan();
                        continue block156;
                    }
                    case 174: {
                        visitor.OP_lessequals();
                        continue block156;
                    }
                    case 175: {
                        visitor.OP_greaterthan();
                        continue block156;
                    }
                    case 176: {
                        visitor.OP_greaterequals();
                        continue block156;
                    }
                    case 85: {
                        int n5 = this.in.readU32();
                        visitor.OP_newobject(n5);
                        continue block156;
                    }
                    case 86: {
                        int n5 = this.in.readU32();
                        visitor.OP_newarray(n5);
                        continue block156;
                    }
                    case 102: {
                        int n5 = this.in.readU32();
                        visitor.OP_getproperty(n5);
                        continue block156;
                    }
                    case 97: {
                        int n5 = this.in.readU32();
                        visitor.OP_setproperty(n5);
                        continue block156;
                    }
                    case 104: {
                        int n5 = this.in.readU32();
                        visitor.OP_initproperty(n5);
                        continue block156;
                    }
                    case 89: {
                        int n5 = this.in.readU32();
                        visitor.OP_getdescendants(n5);
                        continue block156;
                    }
                    case 93: {
                        int n5 = this.in.readU32();
                        visitor.OP_findpropstrict(n5);
                        continue block156;
                    }
                    case 96: {
                        int n5 = this.in.readU32();
                        visitor.OP_getlex(n5);
                        continue block156;
                    }
                    case 94: {
                        int n5 = this.in.readU32();
                        visitor.OP_findproperty(n5);
                        continue block156;
                    }
                    case 95: {
                        int n5 = this.in.readU32();
                        visitor.OP_finddef(n5);
                        continue block156;
                    }
                    case 30: {
                        visitor.OP_nextname();
                        continue block156;
                    }
                    case 35: {
                        visitor.OP_nextvalue();
                        continue block156;
                    }
                    case 31: {
                        visitor.OP_hasnext();
                        continue block156;
                    }
                    case 50: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_hasnext2(n5, n6);
                        continue block156;
                    }
                    case 106: {
                        int n5 = this.in.readU32();
                        visitor.OP_deleteproperty(n5);
                        continue block156;
                    }
                    case 109: {
                        int n5 = this.in.readU32();
                        visitor.OP_setslot(n5);
                        continue block156;
                    }
                    case 108: {
                        int n5 = this.in.readU32();
                        visitor.OP_getslot(n5);
                        continue block156;
                    }
                    case 111: {
                        int n5 = this.in.readU32();
                        visitor.OP_setglobalslot(n5);
                        continue block156;
                    }
                    case 110: {
                        int n5 = this.in.readU32();
                        visitor.OP_getglobalslot(n5);
                        continue block156;
                    }
                    case 65: {
                        int n5 = this.in.readU32();
                        visitor.OP_call(n5);
                        continue block156;
                    }
                    case 66: {
                        int n5 = this.in.readU32();
                        visitor.OP_construct(n5);
                        continue block156;
                    }
                    case 64: {
                        int n5 = this.in.readU32();
                        visitor.OP_newfunction(n5);
                        continue block156;
                    }
                    case 88: {
                        int n5 = this.in.readU32();
                        visitor.OP_newclass(n5);
                        continue block156;
                    }
                    case 68: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callstatic(n5, n6);
                        continue block156;
                    }
                    case 67: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callmethod(n5, n6);
                        continue block156;
                    }
                    case 70: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callproperty(n5, n6);
                        continue block156;
                    }
                    case 76: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callproplex(n5, n6);
                        continue block156;
                    }
                    case 74: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_constructprop(n5, n6);
                        continue block156;
                    }
                    case 69: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callsuper(n5, n6);
                        continue block156;
                    }
                    case 4: {
                        int n5 = this.in.readU32();
                        visitor.OP_getsuper(n5);
                        continue block156;
                    }
                    case 5: {
                        int n5 = this.in.readU32();
                        visitor.OP_setsuper(n5);
                        continue block156;
                    }
                    case 73: {
                        int n5 = this.in.readU32();
                        visitor.OP_constructsuper(n5);
                        continue block156;
                    }
                    case 37: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushshort(n5);
                        continue block156;
                    }
                    case 134: {
                        int n5 = this.in.readU32();
                        visitor.OP_astype(n5);
                        continue block156;
                    }
                    case 135: {
                        visitor.OP_astypelate();
                        continue block156;
                    }
                    case 128: {
                        int n5 = this.in.readU32();
                        visitor.OP_coerce(n5);
                        continue block156;
                    }
                    case 129: {
                        visitor.OP_coerce_b();
                        continue block156;
                    }
                    case 137: {
                        visitor.OP_coerce_o();
                        continue block156;
                    }
                    case 130: {
                        visitor.OP_coerce_a();
                        continue block156;
                    }
                    case 131: {
                        visitor.OP_coerce_i();
                        continue block156;
                    }
                    case 136: {
                        visitor.OP_coerce_u();
                        continue block156;
                    }
                    case 132: {
                        visitor.OP_coerce_d();
                        continue block156;
                    }
                    case 133: {
                        visitor.OP_coerce_s();
                        continue block156;
                    }
                    case 178: {
                        int n5 = this.in.readU32();
                        visitor.OP_istype(n5);
                        continue block156;
                    }
                    case 179: {
                        visitor.OP_istypelate();
                        continue block156;
                    }
                    case 36: {
                        int n5 = this.in.readU8();
                        visitor.OP_pushbyte(n5);
                        continue block156;
                    }
                    case 101: {
                        int n5 = this.in.readU8();
                        visitor.OP_getscopeobject(n5);
                        continue block156;
                    }
                    case 28: {
                        visitor.OP_pushwith();
                        continue block156;
                    }
                    case 29: {
                        visitor.OP_popscope();
                        continue block156;
                    }
                    case 115: {
                        visitor.OP_convert_i();
                        continue block156;
                    }
                    case 116: {
                        visitor.OP_convert_u();
                        continue block156;
                    }
                    case 3: {
                        visitor.OP_throw();
                        continue block156;
                    }
                    case 177: {
                        visitor.OP_instanceof();
                        continue block156;
                    }
                    case 180: {
                        visitor.OP_in();
                        continue block156;
                    }
                    case 6: {
                        int n5 = this.in.readU32();
                        visitor.OP_dxns(n5);
                        continue block156;
                    }
                    case 7: {
                        visitor.OP_dxnslate();
                        continue block156;
                    }
                    case 34: {
                        int n5 = this.in.readU32();
                        visitor.OP_pushconstant(n5);
                        continue block156;
                    }
                    case 78: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callsupervoid(n5, n6);
                        continue block156;
                    }
                    case 79: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        visitor.OP_callpropvoid(n5, n6);
                        continue block156;
                    }
                }
                throw new DecoderException("unknown opcode?? " + n4);
            }
            this.in.seek(n2);
        }
    }

    class Traits {
        BytecodeBuffer in;
        final /* synthetic */ Decoder this$0;

        /*
         * WARNING - void declaration
         */
        Traits(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
        }

        void decode(Visitor visitor) throws DecoderException {
            int n = this.in.readU32();
            visitor.traitCount(n);
            block6: for (int i = 0; i < n; ++i) {
                int n2 = this.in.readU32();
                int n3 = this.in.readU8();
                int n4 = 0;
                switch (n3 & 0xF) {
                    case 0: 
                    case 6: {
                        int n5 = this.in.readU32();
                        int n6 = this.in.readU32();
                        int n7 = this.in.readU32();
                        if (n7 != 0) {
                            n4 = this.in.readU8();
                        }
                        visitor.slotTrait(n3, n2, n5, n6, n7, n4, this.decodeMetaData(n3));
                        continue block6;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        int n8 = this.in.readU32();
                        int n9 = this.in.readU32();
                        visitor.methodTrait(n3, n2, n8, n9, this.decodeMetaData(n3));
                        continue block6;
                    }
                    case 4: {
                        int n5 = this.in.readU32();
                        int n10 = this.in.readU32();
                        visitor.classTrait(n3, n2, n5, n10, this.decodeMetaData(n3));
                        continue block6;
                    }
                    case 5: {
                        int n5 = this.in.readU32();
                        int n9 = this.in.readU32();
                        visitor.functionTrait(n3, n2, n5, n9, this.decodeMetaData(n3));
                        continue block6;
                    }
                }
            }
        }

        private int[] decodeMetaData(int n) {
            int n2;
            int[] nArray = null;
            if ((n >> 4 & 4) != 0 && (n2 = this.in.readU32()) > 0) {
                nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.in.readU32();
                }
            }
            return nArray;
        }
    }

    public final class MethodBodies {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        private Traits traits;
        final /* synthetic */ Decoder this$0;

        MethodBodies(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            this(decoder, bytecodeBuffer, Scanner.scanMethodBodies(bytecodeBuffer));
        }

        /*
         * WARNING - void declaration
         */
        MethodBodies(Decoder decoder, BytecodeBuffer bytecodeBuffer, int[] nArray) {
            void arg2;
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
            this.positions = arg2;
            this.traits = new Traits((Decoder)arg0, (BytecodeBuffer)arg1);
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int n, Visitor visitor) throws DecoderException {
            this.decode(n, 1, visitor);
        }

        public void decode(int n, int n2, Visitor visitor) throws DecoderException {
            int n3 = this.positions[n];
            int n4 = this.in.pos();
            this.in.seek(n3);
            int n5 = this.in.readU32();
            int n6 = this.in.readU32();
            int n7 = this.in.readU32();
            int n8 = this.in.readU32();
            int n9 = this.in.readU32();
            long l = this.in.readU32();
            int n10 = this.in.pos();
            this.in.skip((int)l);
            visitor.startMethodBody(n5, n6, n7, n8, n9, n10, l);
            int n11 = this.in.pos();
            for (int i = 0; i < n2; ++i) {
                this.this$0.opcodes.reset();
                this.in.seek(n11);
                int n12 = this.in.readU32();
                visitor.startOpcodes(n5);
                visitor.startExceptions(n12);
                this.decodeExceptions(this.in, n10, visitor, n12);
                this.this$0.opcodes.decode(n10, l, visitor);
                visitor.endOpcodes();
                visitor.endExceptions();
            }
            this.traits.decode(visitor);
            visitor.endMethodBody();
            this.in.seek(n4);
        }

        private void decodeExceptions(BytecodeBuffer bytecodeBuffer, int n, Visitor visitor, int n2) {
            boolean bl = bytecodeBuffer.minorVersion() != 15;
            for (int i = 0; i < n2; ++i) {
                long l = n + bytecodeBuffer.readU32();
                long l2 = n + bytecodeBuffer.readU32();
                long l3 = n + bytecodeBuffer.readU32();
                int n3 = bytecodeBuffer.readU32();
                int n4 = bl ? bytecodeBuffer.readU32() : 0;
                this.this$0.opcodes.addTarget((int)l);
                this.this$0.opcodes.addTarget((int)l2);
                this.this$0.opcodes.addTarget((int)l3);
                visitor.exception(l, l2, l3, n3, n4);
            }
        }
    }

    public final class ScriptInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        private Traits traits;
        final /* synthetic */ Decoder this$0;

        ScriptInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            this(decoder, bytecodeBuffer, Scanner.scanScripts(bytecodeBuffer));
        }

        /*
         * WARNING - void declaration
         */
        ScriptInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer, int[] nArray) {
            void arg2;
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
            this.positions = arg2;
            this.traits = new Traits((Decoder)arg0, (BytecodeBuffer)arg1);
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int n, Visitor visitor) throws DecoderException {
            int n2 = this.positions[n];
            int n3 = this.in.pos();
            this.in.seek(n2);
            int n4 = this.in.readU32();
            visitor.startScript(n4);
            this.traits.decode(visitor);
            visitor.endScript();
            this.in.seek(n3);
        }
    }

    public final class ClassInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] cPositions;
        private int[] iPositions;
        private Traits cTraits;
        private Traits iTraits;
        final /* synthetic */ Decoder this$0;

        /*
         * WARNING - void declaration
         */
        ClassInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
            int n = arg1.readU32();
            this.iPositions = Scanner.scanInstances((BytecodeBuffer)arg1, n);
            this.iTraits = new Traits((Decoder)arg0, (BytecodeBuffer)arg1);
            this.cPositions = Scanner.scanClasses((BytecodeBuffer)arg1, n);
            this.cTraits = new Traits((Decoder)arg0, (BytecodeBuffer)arg1);
        }

        public int size() {
            return this.cPositions.length;
        }

        public void decode(int n, Visitor visitor) throws DecoderException {
            int n2 = this.decodeInstance(n, visitor);
            this.decodeClass(n, n2, visitor);
        }

        public int decodeInstance(int n, Visitor visitor) throws DecoderException {
            int n2;
            int n3 = this.iPositions[n];
            int n4 = this.in.pos();
            this.in.seek(n3);
            int n5 = this.in.readU32();
            int n6 = this.in.readU32();
            int n7 = this.in.readU8();
            boolean bl = (n7 & 2) != 0;
            boolean bl2 = (n7 & 1) == 0;
            boolean bl3 = (n7 & 4) != 0;
            boolean bl4 = (n7 & 8) != 0;
            int n8 = bl4 ? this.in.readU32() : 0;
            int n9 = this.in.readU32();
            int[] nArray = new int[n9];
            if (n9 > 0) {
                for (n2 = 0; n2 < n9; ++n2) {
                    nArray[n2] = this.in.readU32();
                }
            }
            n2 = this.in.readU32();
            visitor.startInstance(n5, n6, bl2, bl, bl3, nArray, n2, n8);
            this.iTraits.decode(visitor);
            visitor.endInstance();
            this.in.seek(n4);
            return n5;
        }

        public void decodeClass(int n, int n2, Visitor visitor) throws DecoderException {
            int n3 = this.cPositions[n];
            int n4 = this.in.pos();
            this.in.seek(n3);
            int n5 = this.in.readU32();
            visitor.startClass(n2, n5);
            this.cTraits.decode(visitor);
            visitor.endClass();
            this.in.seek(n4);
        }
    }

    public final class MetaDataInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        final /* synthetic */ Decoder this$0;

        MetaDataInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            this(decoder, bytecodeBuffer, Scanner.scanMetadata(bytecodeBuffer));
        }

        /*
         * WARNING - void declaration
         */
        MetaDataInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer, int[] nArray) {
            void arg2;
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
            this.positions = arg2;
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int n, Visitor visitor) throws DecoderException {
            int n2 = this.positions[n];
            int n3 = this.in.pos();
            this.in.seek(n2);
            int n4 = this.in.readU32();
            int n5 = this.in.readU32();
            int[] nArray = null;
            int[] nArray2 = null;
            if (n5 > 0) {
                int n6;
                nArray = new int[n5];
                nArray2 = new int[n5];
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = this.in.readU32();
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray2[n6] = this.in.readU32();
                }
            }
            this.in.seek(n3);
            visitor.metadataInfo(n, n4, nArray, nArray2);
        }
    }

    public final class MethodInfo {
        BytecodeBuffer in;
        int estimatedSize;
        private int[] positions;
        final /* synthetic */ Decoder this$0;

        MethodInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer) {
            this(decoder, bytecodeBuffer, Scanner.scanMethods(bytecodeBuffer));
        }

        /*
         * WARNING - void declaration
         */
        MethodInfo(Decoder decoder, BytecodeBuffer bytecodeBuffer, int[] nArray) {
            void arg2;
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.in = arg1;
            this.positions = arg2;
        }

        public int size() {
            return this.positions.length;
        }

        public void decode(int n, Visitor visitor) throws DecoderException {
            int n2;
            int n3;
            int n4 = this.positions[n];
            int n5 = this.in.pos();
            this.in.seek(n4);
            int n6 = this.in.readU32();
            int n7 = this.in.readU32();
            int[] nArray = null;
            if (n6 > 0) {
                nArray = new int[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    nArray[n3] = this.in.readU32();
                }
            }
            n3 = this.in.readU32();
            int n8 = this.in.readU8();
            int n9 = (n8 & 8) != 0 ? this.in.readU32() : 0;
            int[] nArray2 = null;
            int[] nArray3 = null;
            if (n9 > 0) {
                nArray2 = new int[n9];
                nArray3 = new int[n9];
                for (int i = 0; i < n9; ++i) {
                    nArray2[i] = this.in.readU32();
                    nArray3[i] = this.in.readU8();
                }
            }
            int[] nArray4 = null;
            int n10 = n2 = (n8 & 0x80) != 0 ? n6 : 0;
            if (n2 > 0) {
                nArray4 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray4[i] = this.in.readU32();
                }
            }
            this.in.seek(n5);
            visitor.methodInfo(n7, nArray, n3, n8, nArray2, nArray3, nArray4);
        }
    }
}

