/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADF;
import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import java.lang.reflect.Method;

public class ADFAlgnZones {
    static final int AZ_ADF_MAXLEVEL = 5;
    static final float AZ_ADF_MAXERROR = 2.0E-4f;
    static final float AZ_EDGE_THRESHOLD = 0.04f;
    static final int AZ_MAX_NSAMPLES = 220;
    static final int AZ_MIN_NSAMPLES = 100;
    static final float AZ_RANGE_CUTOFF = 0.13f;
    static final float AZ_MIN_CHAR_DIST_PCT = 0.7f;
    static final int AZ_LEFT_EDGE_CROSSING = 0;
    static final int AZ_TOP_EDGE_CROSSING = 1;

    static void DetectEdges(ADF.ADFGlyph adf, int edgeType, int nSamplesX, int nSamplesY, float threshold, float[] pDist, int[] edgePtsIdx, ADF.IntValue nEdges, float[] edgePts) {
        int x;
        int y;
        float[] p = new float[3];
        int maxSamples = (int)ADFMathUtils.ADF_MAX(nSamplesX, nSamplesY);
        if (adf == null) {
            nEdges.value = 0;
            return;
        }
        float[] filterValues = new float[nSamplesX * nSamplesY];
        float dx = 1.0f / (float)nSamplesX;
        float dy = 1.0f / (float)nSamplesY;
        int lowerLmtX = (int)(adf.glyphMinX * (float)nSamplesX);
        int upperLmtX = (int)(adf.glyphMaxX * (float)nSamplesX);
        int lowerLmtY = (int)(adf.glyphMinY * (float)nSamplesY);
        int upperLmtY = (int)(adf.glyphMaxY * (float)nSamplesY);
        lowerLmtX = lowerLmtX < 2 ? 0 : lowerLmtX - 2;
        lowerLmtY = lowerLmtY < 2 ? 0 : lowerLmtY - 2;
        upperLmtX = upperLmtX > nSamplesX - 3 ? nSamplesX - 1 : upperLmtX + 2;
        upperLmtY = upperLmtY > nSamplesY - 3 ? nSamplesY - 1 : upperLmtY + 2;
        int pDistNum = 0;
        for (y = 0; y < nSamplesY; ++y) {
            if (y < lowerLmtY || y > upperLmtY) {
                for (x = 0; x < nSamplesX; ++x) {
                    pDist[pDistNum++] = -1.0f;
                }
                continue;
            }
            p[1] = (float)y * dy;
            for (x = 0; x < nSamplesX; ++x) {
                if (x < lowerLmtX || x > upperLmtX) {
                    pDist[pDistNum++] = -1.0f;
                    continue;
                }
                p[0] = (float)x * dx;
                float f = ADF.ADFReconstructDistAbs(adf, p);
                pDist[pDistNum++] = f;
            }
        }
        switch (edgeType) {
            case 0: {
                long nValidRows = upperLmtY - lowerLmtY + 1;
                float scaleFilterVal = (float)nValidRows * 2.0f * dx;
                if (scaleFilterVal != 0.0f) {
                    scaleFilterVal = 1.0f / scaleFilterVal;
                }
                x = lowerLmtX + 1;
                while (x < upperLmtX) {
                    for (y = lowerLmtY + 1; y < upperLmtY; ++y) {
                        float dist;
                        float filteredDist;
                        float distPrev = pDist[x - 1 + y * nSamplesX];
                        float distNext = pDist[x + 1 + y * nSamplesX];
                        if (!(distPrev * distNext < 0.0f) || !((filteredDist = -3.0f * Math.abs(dist = pDist[x + y * nSamplesX]) + distNext - distPrev) > 0.0f)) continue;
                        int n = x;
                        filterValues[n] = filterValues[n] + filteredDist;
                    }
                    int n = x++;
                    filterValues[n] = filterValues[n] * scaleFilterVal;
                }
                break;
            }
            case 1: {
                long nValidCols = upperLmtX - lowerLmtX + 1;
                float scaleFilterVal = (float)nValidCols * 2.0f * dy;
                if (scaleFilterVal != 0.0f) {
                    scaleFilterVal = 1.0f / scaleFilterVal;
                }
                for (x = lowerLmtX + 1; x < upperLmtX; ++x) {
                    for (y = lowerLmtY + 1; y < upperLmtY; ++y) {
                        float dist;
                        float filteredDist;
                        float distPrev = pDist[x + (y + 1) * nSamplesX];
                        float distNext = pDist[x + (y - 1) * nSamplesX];
                        if (!(distPrev * distNext < 0.0f) || !((filteredDist = -3.0f * Math.abs(dist = pDist[x + y * nSamplesX]) + distNext - distPrev) > 0.0f)) continue;
                        int n = y;
                        filterValues[n] = filterValues[n] + filteredDist;
                    }
                }
                y = lowerLmtY + 1;
                while (y < upperLmtY) {
                    int n = y++;
                    filterValues[n] = filterValues[n] * scaleFilterVal;
                }
                break;
            }
            default: {
                nEdges.value = 0;
                return;
            }
        }
        ADFAlgnZones.DetermineEdges(filterValues, maxSamples, threshold, edgePtsIdx, edgePts, nEdges);
    }

    static void DetermineEdges(float[] filterValues, int nSamples, float threshold, int[] edgePtsIdx, float[] edgePts, ADF.IntValue nEdges) {
        int i;
        int bestIdx = 0;
        int M = 0;
        float prevValue = 0.0f;
        float ds = 1.0f / (float)nSamples;
        for (i = 0; i < nSamples; ++i) {
            float value = filterValues[i];
            if (prevValue == 0.0f && value > threshold) {
                bestIdx = i;
                prevValue = value;
                continue;
            }
            if (prevValue == 0.0f) continue;
            if (value >= prevValue) {
                bestIdx = i;
                prevValue = value;
                continue;
            }
            if (!((float)(i - bestIdx) * ds > 0.13f)) continue;
            edgePtsIdx[M++] = bestIdx;
            prevValue = 0.0f;
        }
        if (M <= nEdges.value) {
            nEdges.value = M;
        } else {
            int idx;
            for (i = 0; i < nEdges.value; ++i) {
                int curMaxIdx = -1;
                int dstIdx = 0;
                for (int j = 0; j < M; ++j) {
                    idx = edgePtsIdx[j];
                    if (idx >= nSamples) continue;
                    if (curMaxIdx < 0) {
                        curMaxIdx = idx;
                        dstIdx = j;
                        continue;
                    }
                    if (!(filterValues[idx] > filterValues[curMaxIdx])) continue;
                    curMaxIdx = idx;
                    dstIdx = j;
                }
                int n = dstIdx;
                edgePtsIdx[n] = edgePtsIdx[n] + nSamples;
            }
            idx = 0;
            for (i = 0; i < M; ++i) {
                if (edgePtsIdx[i] < nSamples) continue;
                edgePtsIdx[idx++] = edgePtsIdx[i] - nSamples;
            }
        }
        for (i = 0; i < nEdges.value; ++i) {
            edgePts[i] = ds * (float)edgePtsIdx[i];
        }
    }

    public static Object ADFInitAlgnZoneDetection(Object libInst, Object fontID, String fontName, Method getOutlinesCB, Object methodObj) throws Exception {
        float[] edgePts = new float[2];
        float threshold = 0.04f;
        ADFTypeSystem.ADFGenAttrs genAttrs = new ADFTypeSystem.ADFGenAttrs();
        AlgnZoneState state = new AlgnZoneState();
        genAttrs.maxLevel = 5L;
        genAttrs.maxError = 2.0E-4f;
        genAttrs.distEps = 0.0f;
        state.pDist = new float[22000];
        state.edgePtsIdx = new int[220];
        ADF.IntValue nEdges = new ADF.IntValue(2);
        ADFTypeSystem.ADFPath path = (ADFTypeSystem.ADFPath)getOutlinesCB.invoke(methodObj, libInst, fontID, new Character('Z'));
        ADF.ADFGlyph adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(libInst, path, genAttrs);
        ADFAlgnZones.DetectEdges(adf, 1, 100, 220, threshold, state.pDist, state.edgePtsIdx, nEdges, edgePts);
        if (nEdges.value == 2) {
            state.capHeight = (edgePts[1] - adf.glyphOriginY) / adf.FUToADFScale;
            if (state.capHeight < 0.7f * (path.glyphMaxY - path.glyphMinY)) {
                state.capHeight = 0.0f;
            }
        } else {
            state.capHeight = 0.0f;
        }
        nEdges = new ADF.IntValue(2);
        path = (ADFTypeSystem.ADFPath)getOutlinesCB.invoke(methodObj, libInst, fontID, new Character('z'));
        adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(libInst, path, genAttrs);
        ADFAlgnZones.DetectEdges(adf, 1, 100, 220, threshold, state.pDist, state.edgePtsIdx, nEdges, edgePts);
        if (nEdges.value == 2) {
            state.xHeight = (edgePts[1] - adf.glyphOriginY) / adf.FUToADFScale;
            if (state.xHeight < 0.7f * (path.glyphMaxY - path.glyphMinY)) {
                state.xHeight = 0.0f;
            }
        } else {
            state.xHeight = 0.0f;
        }
        nEdges = new ADF.IntValue(1);
        path = (ADFTypeSystem.ADFPath)getOutlinesCB.invoke(methodObj, libInst, fontID, new Character('L'));
        adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(libInst, path, genAttrs);
        ADFAlgnZones.DetectEdges(adf, 0, 220, 100, threshold, state.pDist, state.edgePtsIdx, nEdges, edgePts);
        state.leftCapAlignPt = nEdges.value == 1 ? (edgePts[0] - adf.glyphOriginX) / adf.FUToADFScale : 0.0f;
        nEdges = new ADF.IntValue(1);
        path = (ADFTypeSystem.ADFPath)getOutlinesCB.invoke(methodObj, libInst, fontID, new Character('l'));
        adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(libInst, path, genAttrs);
        ADFAlgnZones.DetectEdges(adf, 0, 220, 100, threshold, state.pDist, state.edgePtsIdx, nEdges, edgePts);
        state.leftXAlignPt = nEdges.value == 1 ? (edgePts[0] - adf.glyphOriginX) / adf.FUToADFScale : 0.0f;
        return state;
    }

    public static void ADFDetectAlgnZones(Object libInst, Object algnZoneState, ADFTypeSystem.ADFPath path) {
        float yRange;
        float yAlgnCoord;
        float xRange;
        float xAlgnCoord;
        float[] edgePts = new float[10];
        float threshold = 0.04f;
        AlgnZoneState state = (AlgnZoneState)algnZoneState;
        ADF.IntValue nCrossingsX = new ADF.IntValue(0);
        ADF.IntValue nCrossingsY = new ADF.IntValue(0);
        if (path == null) {
            return;
        }
        if (state == null) {
            path.algnZonesMask = 0;
            return;
        }
        ADF.BooleanValue upperCase = new ADF.BooleanValue(false);
        ADFAlgnZones.SetGlyphSpecificAlgnZoneData(path.charCode, upperCase, nCrossingsX, nCrossingsY);
        ADFTypeSystem.ADFGenAttrs genAttrs = new ADFTypeSystem.ADFGenAttrs();
        genAttrs.maxError = 2.0E-4f;
        genAttrs.distEps = 0.0f;
        genAttrs.maxLevel = nCrossingsX.value == 0 && nCrossingsY.value == 0 ? 0L : 5L;
        ADF.ADFGlyph adf = (ADF.ADFGlyph)ADF.ADFGenerateADF(libInst, path, genAttrs);
        if (adf == null) {
            path.algnZonesMask = 0;
            return;
        }
        if (nCrossingsX.value != 0) {
            ADFAlgnZones.DetectEdges(adf, 0, 220, 100, threshold, state.pDist, state.edgePtsIdx, nCrossingsX, edgePts);
        }
        if (nCrossingsX.value == 0) {
            xAlgnCoord = upperCase.value ? state.leftCapAlignPt : state.leftXAlignPt;
            xRange = 0.0f;
        } else if (nCrossingsX.value == 1) {
            xAlgnCoord = (edgePts[0] - adf.glyphOriginX) / adf.FUToADFScale;
            xRange = 0.0f;
        } else {
            xAlgnCoord = (edgePts[0] - adf.glyphOriginX) / adf.FUToADFScale;
            xRange = (edgePts[1] - edgePts[0]) / adf.FUToADFScale;
            if (xRange * adf.FUToADFScale < 0.13f) {
                xRange = 0.0f;
            }
        }
        if (nCrossingsY.value != 0) {
            ADFAlgnZones.DetectEdges(adf, 1, 100, 220, threshold, state.pDist, state.edgePtsIdx, nCrossingsY, edgePts);
        }
        if (nCrossingsY.value == 0) {
            yAlgnCoord = 0.0f;
            yRange = upperCase.value ? state.capHeight : state.xHeight;
        } else {
            yAlgnCoord = 0.0f;
            yRange = (edgePts[nCrossingsY.value - 1] - adf.glyphOriginY) / adf.FUToADFScale;
            if (yRange < 0.0f) {
                yRange = -yRange;
            }
            if (yRange * adf.FUToADFScale < 0.13f && path.charCode != '_') {
                yRange = 0.0f;
            }
        }
        float inv = 1.0f / path.fontUnitsPerEM;
        adf.xAlgnCoord = xAlgnCoord *= inv;
        adf.yAlgnCoord = yAlgnCoord *= inv;
        adf.xRange = xRange *= inv;
        adf.yRange = yRange *= inv;
        adf.algnZonesMask = 3;
        ADF.ADFPackAlgnZones(adf, path);
    }

    static void SetGlyphSpecificAlgnZoneData(char charCode, ADF.BooleanValue upperCase, ADF.IntValue nCrossingsX, ADF.IntValue nCrossingsY) {
        upperCase.value = true;
        nCrossingsX.value = 0;
        nCrossingsY.value = 0;
        switch (charCode) {
            case 'l': 
            case 's': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
            case '\u00ff': 
            case '\u015b': 
            case '\u015d': 
            case '\u015f': 
            case '\u0161': 
            case '\u0175': 
            case '\u0177': 
            case '\u017a': 
            case '\u017c': 
            case '\u017e': {
                upperCase.value = false;
            }
            case '&': 
            case '\'': 
            case '/': 
            case '2': 
            case '3': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '<': 
            case '>': 
            case 'A': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Z': 
            case '\\': 
            case '\u00aa': 
            case '\u00ab': 
            case '\u00b0': 
            case '\u00b2': 
            case '\u00b3': 
            case '\u00b8': 
            case '\u00ba': 
            case '\u00bb': 
            case '\u00bc': 
            case '\u00bd': 
            case '\u00be': 
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c3': 
            case '\u00c4': 
            case '\u00c5': 
            case '\u00d7': 
            case '\u0100': 
            case '\u0102': 
            case '\u0104': 
            case '\u015a': 
            case '\u015c': 
            case '\u015e': 
            case '\u0160': 
            case '\u0174': 
            case '\u0179': 
            case '\u017b': 
            case '\u017d': 
            case '\u01cd': 
            case '\u01fa': {
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 't': 
            case '\u00a2': 
            case '\u00de': 
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e3': 
            case '\u00e4': 
            case '\u00e5': 
            case '\u00e7': 
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': 
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': 
            case '\u00f0': 
            case '\u00fd': 
            case '\u00fe': 
            case '\u0101': 
            case '\u0103': 
            case '\u0105': 
            case '\u0107': 
            case '\u0109': 
            case '\u010b': 
            case '\u010d': 
            case '\u010f': 
            case '\u0111': 
            case '\u0113': 
            case '\u0115': 
            case '\u0117': 
            case '\u0119': 
            case '\u011b': 
            case '\u011d': 
            case '\u011f': 
            case '\u0121': 
            case '\u0123': 
            case '\u0129': 
            case '\u012b': 
            case '\u012d': 
            case '\u012f': 
            case '\u0131': 
            case '\u0135': 
            case '\u0137': 
            case '\u0138': 
            case '\u013a': 
            case '\u013c': 
            case '\u013e': 
            case '\u0140': 
            case '\u0142': 
            case '\u0155': 
            case '\u0157': 
            case '\u0159': 
            case '\u0163': 
            case '\u0165': 
            case '\u0167': 
            case '\u017f': 
            case '\u0192': 
            case '\u01ce': 
            case '\u01d0': 
            case '\u01fb': {
                upperCase.value = false;
            }
            case '!': 
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case ',': 
            case '.': 
            case '1': 
            case '4': 
            case '5': 
            case '?': 
            case '@': 
            case 'C': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'P': 
            case 'R': 
            case 'T': 
            case 'Y': 
            case '[': 
            case ']': 
            case '{': 
            case '|': 
            case '}': 
            case '\u00a1': 
            case '\u00a3': 
            case '\u00a5': 
            case '\u00a6': 
            case '\u00a9': 
            case '\u00ae': 
            case '\u00b4': 
            case '\u00b6': 
            case '\u00b9': 
            case '\u00bf': 
            case '\u00c6': 
            case '\u00c7': 
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00dd': 
            case '\u0106': 
            case '\u0108': 
            case '\u010a': 
            case '\u010c': 
            case '\u0112': 
            case '\u0114': 
            case '\u0116': 
            case '\u0118': 
            case '\u011a': 
            case '\u011c': 
            case '\u011e': 
            case '\u0120': 
            case '\u0122': 
            case '\u0128': 
            case '\u012a': 
            case '\u012c': 
            case '\u012e': 
            case '\u0130': 
            case '\u0134': 
            case '\u0136': 
            case '\u0139': 
            case '\u013b': 
            case '\u013d': 
            case '\u013f': 
            case '\u0141': 
            case '\u0154': 
            case '\u0156': 
            case '\u0158': 
            case '\u0162': 
            case '\u0164': 
            case '\u0166': 
            case '\u0176': 
            case '\u0178': 
            case '\u018f': 
            case '\u01cf': 
            case '\u01fc': {
                nCrossingsX.value = 1;
                break;
            }
            case 'h': 
            case 'n': 
            case 'o': 
            case 'u': 
            case '\u00b5': 
            case '\u00e6': 
            case '\u00f1': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f5': 
            case '\u00f6': 
            case '\u00f8': 
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': 
            case '\u0125': 
            case '\u0127': 
            case '\u0133': 
            case '\u0144': 
            case '\u0146': 
            case '\u0148': 
            case '\u0149': 
            case '\u014b': 
            case '\u014d': 
            case '\u014f': 
            case '\u0151': 
            case '\u0153': 
            case '\u0169': 
            case '\u016b': 
            case '\u016d': 
            case '\u016f': 
            case '\u0171': 
            case '\u0173': 
            case '\u01a1': 
            case '\u01b0': 
            case '\u01d2': 
            case '\u01d4': 
            case '\u01d6': 
            case '\u01d8': 
            case '\u01da': 
            case '\u01dc': 
            case '\u01fd': 
            case '\u01ff': {
                upperCase.value = false;
            }
            case '%': 
            case '0': 
            case 'B': 
            case 'D': 
            case 'H': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'Q': 
            case 'U': 
            case '\u00a4': 
            case '\u00a7': 
            case '\u00d0': 
            case '\u00d1': 
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d5': 
            case '\u00d6': 
            case '\u00d8': 
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': 
            case '\u00df': 
            case '\u010e': 
            case '\u0110': 
            case '\u0124': 
            case '\u0126': 
            case '\u0132': 
            case '\u0143': 
            case '\u0145': 
            case '\u0147': 
            case '\u014a': 
            case '\u014c': 
            case '\u014e': 
            case '\u0150': 
            case '\u0152': 
            case '\u0168': 
            case '\u016a': 
            case '\u016c': 
            case '\u016e': 
            case '\u0170': 
            case '\u0172': 
            case '\u01a0': 
            case '\u01af': 
            case '\u01d1': 
            case '\u01d3': 
            case '\u01d5': 
            case '\u01d7': 
            case '\u01d9': 
            case '\u01db': 
            case '\u01fe': {
                nCrossingsX.value = 2;
                break;
            }
            case 'm': {
                upperCase.value = false;
                nCrossingsX.value = 3;
                break;
            }
            case '-': 
            case '^': 
            case '_': 
            case '~': 
            case '\u00ad': 
            case '\u00af': {
                nCrossingsY.value = 1;
                break;
            }
            case '#': 
            case '=': {
                nCrossingsY.value = 2;
                break;
            }
            case '+': 
            case '`': 
            case '\u00ac': 
            case '\u00b7': 
            case '\u00f7': {
                nCrossingsX.value = 1;
                nCrossingsY.value = 1;
                break;
            }
            case ':': 
            case ';': 
            case '\u00b1': {
                nCrossingsX.value = 1;
                nCrossingsY.value = 2;
                break;
            }
            case '\"': 
            case '\u00a8': {
                nCrossingsX.value = 2;
                nCrossingsY.value = 1;
            }
        }
    }

    public static class AlgnZoneState {
        float leftXAlignPt;
        float leftCapAlignPt;
        float xHeight;
        float capHeight;
        float[] pDist;
        int[] edgePtsIdx;
    }
}

